/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor;

import ericsson.vareditor.JFocusTable;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.Variable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JTable;
import javax.swing.KeyStroke;

public class VarTable
extends JFocusTable {
    int cellHeight = 30;

    public VarTable() {
        this.setGridColor(Color.black);
        this.setRowSelectionAllowed(true);
        this.setSelectionMode(0);
        this.setPreferredScrollableViewportSize(new Dimension(500, 70));
        this.setSurrendersFocusOnKeystroke(true);
        this.putClientProperty("JTable.autoStartsEdit", Boolean.TRUE);
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        InputMap im = this.getInputMap(1);
        KeyStroke tab = KeyStroke.getKeyStroke(9, 0);
        KeyStroke enter = KeyStroke.getKeyStroke(10, 0);
        im.put(enter, im.get(tab));
        final Action oldTabAction = this.getActionMap().get(im.get(tab));
        AbstractAction tabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                oldTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int rowCount = table.getRowCount();
                int columnCount = table.getColumnCount();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    if (++column == columnCount) {
                        column = 0;
                        ++row;
                    }
                    if (row == rowCount) {
                        row = 0;
                    }
                    if (row != table.getSelectedRow() || column != table.getSelectedColumn()) continue;
                }
                table.changeSelection(row, column, false, false);
            }
        };
        this.getActionMap().put(im.get(tab), tabAction);
        KeyStroke shiftTab = KeyStroke.getKeyStroke(9, 64);
        final Action oldShiftTabAction = this.getActionMap().get(im.get(shiftTab));
        AbstractAction shiftTabAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                oldShiftTabAction.actionPerformed(e);
                JTable table = (JTable)e.getSource();
                int rowCount = table.getRowCount();
                int columnCount = table.getColumnCount();
                int row = table.getSelectedRow();
                int column = table.getSelectedColumn();
                while (!table.isCellEditable(row, column)) {
                    if (--column < 0) {
                        column = columnCount - 1;
                        --row;
                    }
                    if (row < 0) {
                        row = rowCount - 1;
                    }
                    if (row != table.getSelectedRow() || column != table.getSelectedColumn()) continue;
                }
                table.changeSelection(row, column, false, false);
            }
        };
        this.getActionMap().put(im.get(shiftTab), shiftTabAction);
    }

    public void setRowHeights(VarTableModel model) {
        for (int ii = 0; ii < this.getRowCount(); ++ii) {
            Variable var = model.dataVector.get(ii);
            Component comp = var.getRenderer();
            Dimension dim = comp.getPreferredSize();
            if (dim.height < this.cellHeight) {
                this.setRowHeight(ii, this.cellHeight);
                continue;
            }
            this.setRowHeight(ii, dim.height);
        }
    }
}

