/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor;

import java.awt.Component;
import java.awt.FocusTraversalPolicy;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.ListSelectionModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;

public class JFocusTable
extends JTable {
    private boolean reallySurrendersFocus;

    public JFocusTable() {
    }

    public JFocusTable(int rows, int columns) {
        super(rows, columns);
    }

    public JFocusTable(TableModel model) {
        super(model);
    }

    @Override
    public void setSurrendersFocusOnKeystroke(boolean surrender) {
        this.reallySurrendersFocus = surrender;
    }

    public boolean isReallySurrendersFocusEnabled() {
        return this.reallySurrendersFocus;
    }

    @Override
    public boolean getSurrendersFocusOnKeystroke() {
        return false;
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Object value = this.getValueAt(row, column);
        boolean isSelected = this.isCellSelected(row, column);
        return editor.getTableCellEditorComponent(this, value, isSelected, row, column);
    }

    public void startEditing(boolean transferFocus) {
        ListSelectionModel csm;
        int anchorColumn;
        ListSelectionModel rsm = this.getSelectionModel();
        int anchorRow = rsm.getAnchorSelectionIndex();
        boolean startedEdit = this.editCellAt(anchorRow, anchorColumn = (csm = this.getColumnModel().getSelectionModel()).getAnchorSelectionIndex());
        if (startedEdit && transferFocus) {
            this.transferFocusToEditor();
        }
    }

    public void stopEditing(boolean grabFocus) {
        if (!this.getCellEditor().stopCellEditing()) {
            return;
        }
        if (grabFocus) {
            this.requestFocus();
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean notWasEditing = !this.isEditing();
        boolean result = super.processKeyBinding(ks, e, condition, pressed);
        if (notWasEditing && this.isEditing() && this.isReallySurrendersFocusEnabled()) {
            this.transferFocusToEditor();
        }
        return result;
    }

    protected void transferFocusToEditor() {
        if (this.getManager().getCurrentFocusCycleRoot() != this) {
            this.transferFocusDownCycle();
        }
        this.transferFocus();
    }

    private KeyboardFocusManager getManager() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager();
    }

    @Override
    protected void initializeLocalVars() {
        super.initializeLocalVars();
        this.initEditProperties();
    }

    protected void initEditProperties() {
        this.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.setSurrendersFocusOnKeystroke(true);
        this.setFocusCycleRoot(true);
        this.getActionMap().put("startEditing", this.createToggleEditAction());
        this.setFocusTraversalPolicy(this.createTablePolicy());
    }

    protected FocusTraversalPolicy createTablePolicy() {
        LayoutFocusTraversalPolicy policy = new LayoutFocusTraversalPolicy();
        policy.setImplicitDownCycleTraversal(false);
        return policy;
    }

    protected Action createToggleEditAction() {
        return new ToggleEditAction();
    }

    private class ToggleEditAction
    extends AbstractAction {
        private ToggleEditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JFocusTable.this.isEditing()) {
                JFocusTable.this.stopEditing(true);
            } else {
                JFocusTable.this.startEditing(true);
            }
        }
    }
}

