/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DomWriter {
    private static TransformerFactory myFactory = TransformerFactory.newInstance();

    public static String elementToString(Element element) {
        return DomWriter.nodeToString(element, false);
    }

    public static void elementToStream(Element element, Writer out) {
        DomWriter.nodeToWriter(element, out, false, false);
    }

    public static String elementToStringIndent(Element element) {
        return DomWriter.nodeToString(element, true);
    }

    public static String nodeToString(Node node, boolean indent) {
        return DomWriter.nodeToString(node, indent, false);
    }

    public static String nodeToString(Node node, boolean indent, boolean xmlDeclaration) {
        StringWriter buffer = new StringWriter(200);
        DomWriter.nodeToWriter(node, new PrintWriter(buffer), indent, xmlDeclaration);
        return buffer.toString().trim();
    }

    public static void nodeToWriter(Node node, Writer out, boolean indent, boolean xmlDeclaration) {
        try {
            DomWriter.nodeToWriterImpl(node, out, indent, xmlDeclaration);
        }
        catch (TransformerException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void nodeToWriterImpl(Node node, Writer out, boolean indent, boolean xmlDeclaration) throws TransformerException {
        Transformer transformer;
        TransformerFactory transformerFactory = myFactory;
        synchronized (transformerFactory) {
            transformer = myFactory.newTransformer();
        }
        transformer.setOutputProperty("indent", indent ? "yes" : "no");
        transformer.setOutputProperty("omit-xml-declaration", xmlDeclaration ? "no" : "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "xml");
        DOMSource requestSource = new DOMSource(node);
        transformer.transform(requestSource, new StreamResult(out));
        try {
            out.flush();
        }
        catch (IOException ex) {
            throw new TransformerException(ex);
        }
    }

    static {
        myFactory.setAttribute("indent-number", new Integer(4));
    }
}

