/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListIterable
implements Iterable<Node> {
    private NodeList myNodeList;
    private short myTypeFilter;
    private String[] myNameFilter;

    public NodeListIterable(NodeList nl) {
        this(nl, -1);
    }

    public NodeListIterable(NodeList nl, short typeFilter) {
        this.myNodeList = nl;
        this.myTypeFilter = typeFilter;
    }

    public NodeListIterable(NodeList nl, short typeFilter, String ... nameFilter) {
        this.myNodeList = nl;
        this.myTypeFilter = typeFilter;
        this.myNameFilter = nameFilter;
    }

    @Override
    public Iterator<Node> iterator() {
        return new NodeListIterator();
    }

    private class NodeListIterator
    implements Iterator<Node> {
        private int myIndex = -1;

        private NodeListIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.searchForNext(this.myIndex) > this.myIndex;
        }

        @Override
        public Node next() {
            int index = this.searchForNext(this.myIndex);
            if (index == this.myIndex) {
                throw new NoSuchElementException();
            }
            this.myIndex = index;
            return NodeListIterable.this.myNodeList.item(this.myIndex);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private int searchForNext(int start) {
            for (int i = start + 1; i < NodeListIterable.this.myNodeList.getLength(); ++i) {
                boolean matchesTypeFilter = false;
                boolean matchesNameFilter = false;
                if (NodeListIterable.this.myTypeFilter < 0 || NodeListIterable.this.myTypeFilter == NodeListIterable.this.myNodeList.item(i).getNodeType()) {
                    matchesTypeFilter = true;
                }
                if (NodeListIterable.this.myNameFilter == null || NodeListIterable.this.myNameFilter.length == 0) {
                    matchesNameFilter = true;
                } else {
                    for (String name : NodeListIterable.this.myNameFilter) {
                        if (!name.equals(NodeListIterable.this.myNodeList.item(i).getNodeName())) continue;
                        matchesNameFilter = true;
                        break;
                    }
                }
                if (!matchesTypeFilter || !matchesNameFilter) continue;
                return i;
            }
            return start;
        }
    }
}

