/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.structure;

import ericsson.ere.RatingData;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.statement.NodeStatement;
import ericsson.ere.statement.Statement;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractTariffStructure
extends AbstractDAGNode
implements TariffStructure,
TariffStructureNode,
XMLInitializable {
    protected String myName;
    protected String myNodeId = null;
    protected Statement myStatement = null;
    protected ClassRepository myRepository = null;

    public AbstractTariffStructure() {
    }

    public AbstractTariffStructure(ClassRepository rep) {
        this.myRepository = rep;
    }

    @Override
    public ClassRepository getClassRepository() {
        return this.myRepository;
    }

    @Override
    public void setClassRepository(ClassRepository rep) {
        this.myRepository = rep;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        NamedNodeMap attr = iterator.getAttributes();
        if (attr == null) {
            throw new IllegalArgumentException("Attributes not found in TariffStructure");
        }
        Node node = attr.getNamedItem("id");
        if (node != null) {
            this.myNodeId = node.getNodeValue();
        }
        if ((node = attr.getNamedItem("Name")) == null) {
            throw new IllegalArgumentException(EreDefs.getErrorString("error.noNameAttrInTariff"));
        }
        this.myName = node.getNodeValue();
        return this;
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myNodeId == null ? 0 : this.myNodeId.hashCode());
        result = 31 * result + (this.myRepository == null ? 0 : this.myRepository.hashCode());
        result = 31 * result + (this.myStatement == null ? 0 : this.myStatement.hashCode());
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTariffStructure other = (AbstractTariffStructure)obj;
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        if (this.myNodeId == null ? other.myNodeId != null : !this.myNodeId.equals(other.myNodeId)) {
            return false;
        }
        if (this.myRepository == null ? other.myRepository != null : !this.myRepository.equals(other.myRepository)) {
            return false;
        }
        return !(this.myStatement == null ? other.myStatement != null : !this.myStatement.equals(other.myStatement));
    }

    protected void checkCreateStatement() {
        if (this.myStatement == null) {
            this.myStatement = new NodeStatement(this.myName, false, 100.0);
            if (this.myNodeId != null && !"".equals(this.myNodeId.trim())) {
                this.myStatement.setNodeId(this.myNodeId);
            }
        }
    }

    @Override
    public void add(Statement child) throws Exception {
        this.checkCreateStatement();
        this.myStatement.add(child);
    }

    @Override
    public DAGNode getChildAt(int i) {
        this.checkCreateStatement();
        return this.myStatement.getChildAt(i);
    }

    @Override
    public int getChildCount() {
        this.checkCreateStatement();
        return this.myStatement.getChildCount();
    }

    @Override
    public void insertChildAt(int i, DAGNode n) {
        this.checkCreateStatement();
        this.myStatement.insertChildAt(i, n);
    }

    @Override
    public void insertLinkAt(int i, DAGNode n) {
        this.checkCreateStatement();
        this.myStatement.insertLinkAt(i, n);
    }

    @Override
    protected void removeChild(DAGNode n) {
        throw new IllegalArgumentException(EreDefs.getErrorString("error.nodeNotRemoved"));
    }

    @Override
    protected void removeLink(DAGNode n) {
        throw new IllegalArgumentException(EreDefs.getErrorString("error.nodeNotRemoved"));
    }

    @Override
    public abstract void rate(RatingData var1, DoubleValue var2, LongValue var3) throws Exception;

    @Override
    public int getNodeType() {
        return 0;
    }

    @Override
    public String getNodeId() {
        this.checkCreateStatement();
        return this.myStatement.getNodeId();
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterTariffStructure(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveTariffStructure(this);
    }
}

