/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.statement;

import com.ericsson.ere.selectiontree.interfaces.MutableStatement;
import ericsson.ere.RatingData;
import ericsson.ere.interfaces.AbstractDAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class Statement
extends AbstractDAGNode
implements MutableStatement,
TariffStructureNode,
XMLInitializable {
    protected String myName = null;
    protected String myNodeId = null;

    public Statement() {
    }

    public Statement(String name) {
        this.setName(name);
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        Node node;
        NamedNodeMap attr = null;
        if (iterator.hasAttributes()) {
            attr = iterator.getAttributes();
        }
        if (attr != null && (node = attr.getNamedItem("id")) != null) {
            this.myNodeId = node.getNodeValue();
        }
        return this;
    }

    public abstract void rate(RatingData var1, DoubleValue var2, LongValue var3) throws Exception;

    public abstract void add(XMLInitializable var1);

    @Override
    public void setName(String theName) {
        this.myName = theName;
    }

    public String getName() {
        return this.myName;
    }

    @Override
    public int getNodeType() {
        return 1;
    }

    @Override
    public String getNodeId() {
        String id = this.myNodeId;
        if (id == null || "".equals(id.trim())) {
            id = this.getName();
        }
        id = id.replace('/', '\\');
        return id;
    }

    public void setNodeId(String id) {
        this.myNodeId = id;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLink() {
        return false;
    }

    @Override
    public void startVisit(TariffStructureVisitor v) throws Exception {
        v.enterNode(this);
    }

    @Override
    public void endVisit(TariffStructureVisitor v) throws Exception {
        v.leaveNode(this);
    }

    @Override
    protected int hashCodeImpl() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myName == null ? 0 : this.myName.hashCode());
        result = 31 * result + (this.myNodeId == null ? 0 : this.myNodeId.hashCode());
        return result;
    }

    @Override
    protected boolean equalsImpl(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Statement other = (Statement)obj;
        if (this.myName == null ? other.myName != null : !this.myName.equals(other.myName)) {
            return false;
        }
        return !(this.myNodeId == null ? other.myNodeId != null : !this.myNodeId.equals(other.myNodeId));
    }
}

