/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.statement;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.DOMUtil;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.ratingrules.nodes.TreeBuilderAssistant;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.ClassProfileV2;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NodeStatementProfile
implements ClassProfileV2,
TreeBuilderAssistant {
    public static final String LBL_ID = "Id";
    public static final String LBL_NAME = "Name";
    public static final String LBL_COMMENT = "Comment";
    public static final String LBL_DISCOUNT = "Price factor";
    public static final String LBL_INVERTED = "Inverted";
    private static final String TAG_CALLNEXTWHENFALSE = "CallNextWhenFalse";
    private static final String TAG_COMMENT = "Comment";
    private static final String TAG_DISCOUNT = "Discount";

    @Override
    public boolean needsRepository() {
        return false;
    }

    @Override
    public void setClassRepository(ClassRepository aRepository) {
    }

    @Override
    public void setTariffStructureNode(DAGNode tariffStructureNode) {
    }

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(5);
        BoolVariable var = new BoolVariable(LBL_INVERTED, false);
        l.add(var);
        DoubleVariable dis = new DoubleVariable(LBL_DISCOUNT, 100.0, 0.0, Double.MAX_VALUE);
        l.add(dis);
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(5);
        boolean callNextWhenFalse = false;
        String discount = "100.0";
        if (iterator.hasAttributes()) {
            Node d;
            String cnwfString;
            NamedNodeMap attributes = iterator.getAttributes();
            Node n = attributes.getNamedItem(TAG_CALLNEXTWHENFALSE);
            if (n != null && "true".equalsIgnoreCase(cnwfString = n.getNodeValue())) {
                callNextWhenFalse = true;
            }
            if ((d = attributes.getNamedItem(TAG_DISCOUNT)) != null) {
                discount = d.getNodeValue();
            }
        }
        l.add(new BoolVariable(LBL_INVERTED, callNextWhenFalse));
        l.add(new DoubleVariable(LBL_DISCOUNT, discount, 0.0, Double.MAX_VALUE));
        return l;
    }

    @Override
    public void printPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        for (int i = 0; i < indentLevel; ++i) {
            out.print(indentMarker);
        }
        String id = VarListUtil.getValueStringForName(variables, LBL_ID);
        Boolean cnwf = VarListUtil.getBooleanValueForName(variables, LBL_INVERTED);
        String discount = VarListUtil.getValueStringForName(variables, LBL_DISCOUNT);
        out.print("<");
        out.print("Node");
        if (id != null && !"".equals(id.trim())) {
            out.print(" id=\"" + XMLUtil.escape(id) + "\"");
        }
        if (!"Node".equals("Node")) {
            out.print(" type=\"" + XMLUtil.escape("Node") + "\"");
        }
        if (!discount.equals("100.0")) {
            out.print(" Discount=\"" + discount + "\"");
        }
        if (cnwf.booleanValue()) {
            out.print(" CallNextWhenFalse=\"" + cnwf.toString() + "\"");
        }
        out.print(">");
    }

    @Override
    public void printParameters(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String comment;
        String name = VarListUtil.getValueStringForName(variables, LBL_NAME);
        boolean commentIsUsed = RmaDefs.getInstance().useCommentNode();
        out.println(XMLUtil.escape(name));
        if (commentIsUsed && (comment = VarListUtil.getValueStringForName(variables, "Comment")).length() > 0) {
            for (int i = 0; i < indentLevel + 1; ++i) {
                out.print(indentMarker);
            }
            out.print("<");
            out.print("Comment");
            out.print(">");
            out.print(XMLUtil.escape(comment));
            out.print("</");
            out.print("Comment");
            out.println(">");
        }
    }

    @Override
    public void printPostamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        out.println("</Node>");
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public String getDescription(List<Variable> variables) {
        if (variables == null) {
            return "";
        }
        String name = VarListUtil.getValueStringForName(variables, LBL_NAME);
        Boolean inv = VarListUtil.getBooleanValueForName(variables, LBL_INVERTED);
        String discount = VarListUtil.getValueStringForName(variables, LBL_DISCOUNT);
        String extra = null;
        if (inv.booleanValue()) {
            extra = LBL_INVERTED;
        }
        if (!discount.equals("100.0")) {
            extra = extra == null ? discount.toString().toLowerCase() + "%" : extra + ", " + discount.toLowerCase() + "%";
        }
        if (extra != null) {
            return name + " (" + extra + ")";
        }
        return name;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String comment = VarListUtil.getValueStringForName(variables, "Comment");
        String name = VarListUtil.getValueStringForName(variables, LBL_NAME);
        Boolean inv = VarListUtil.getBooleanValueForName(variables, LBL_INVERTED);
        String discount = VarListUtil.getValueStringForName(variables, LBL_DISCOUNT);
        String info = "<html><b>" + name + "</b>";
        info = info + " (Discount=" + discount + "% ";
        info = inv != false ? info + LBL_INVERTED : info + "Normal";
        info = info + " logic test)";
        if (comment != null && !"".equals(comment)) {
            info = info + "<p>" + GuiUtil.replaceSubString(comment, "\n", "<p>");
        }
        info = info + "</html>";
        return info;
    }

    @Override
    public String getAdditionalInfo() {
        return null;
    }

    @Override
    public boolean handlesCachedPrint(Node xmlNode) {
        if (xmlNode.hasAttributes()) {
            String val;
            NamedNodeMap attr = xmlNode.getAttributes();
            Node disc = attr.getNamedItem(TAG_DISCOUNT);
            Node inv = attr.getNamedItem(TAG_CALLNEXTWHENFALSE);
            if (disc != null && (val = disc.getNodeValue()) != null && !"".equals(val.trim()) && Double.parseDouble(val) == 100.0) {
                attr.removeNamedItem(TAG_DISCOUNT);
            }
            if (inv != null && (val = inv.getNodeValue()) != null && "false".equals(val)) {
                attr.removeNamedItem(TAG_CALLNEXTWHENFALSE);
            }
        }
        return false;
    }

    @Override
    public void cachedPrint(PrintWriter out, int indentLevel, String indent, TariffStructureNode tsNode, Node xmlNode) {
        if (!(tsNode instanceof TariffDAGNode)) {
            throw new IllegalArgumentException("AbstractModifierProfileV2 does not know how to do cachedPrint()??? - not a TariffDAGNode...");
        }
        DOMUtil.cachedPrint((TariffDAGNode)tsNode, xmlNode, out, indentLevel, indent);
    }

    @Override
    public Map<String, Object> getDisplayValues(Node iterator, Map<String, Object> prev) {
        HashMap<String, Object> displayValues = prev != null ? prev : new HashMap<String, Object>();
        Boolean inv = Boolean.FALSE;
        String discount = "100.0";
        if (iterator.hasAttributes()) {
            Node d;
            String cnwfString;
            NamedNodeMap attributes = iterator.getAttributes();
            Node n = attributes.getNamedItem(TAG_CALLNEXTWHENFALSE);
            if (n != null && "true".equalsIgnoreCase(cnwfString = n.getNodeValue())) {
                inv = Boolean.TRUE;
            }
            if ((d = attributes.getNamedItem(TAG_DISCOUNT)) != null) {
                discount = d.getNodeValue();
            }
        }
        displayValues.put(LBL_INVERTED, inv);
        displayValues.put(LBL_DISCOUNT, discount);
        return displayValues;
    }

    @Override
    public Map<String, Object> getDisplayValues(List<Variable> variables, Map<String, Object> prev) {
        HashMap<String, Object> displayValues = prev != null ? prev : new HashMap<String, Object>();
        Boolean inv = VarListUtil.getBooleanValueForName(variables, LBL_INVERTED);
        String discount = VarListUtil.getValueStringForName(variables, LBL_DISCOUNT);
        displayValues.put(LBL_INVERTED, inv);
        displayValues.put(LBL_DISCOUNT, discount);
        return displayValues;
    }

    @Override
    public boolean allowsAddCondition(TariffDAGNode treeNode) {
        return true;
    }

    @Override
    public boolean allowsAddLink(TariffDAGNode treeNode) {
        return true;
    }

    @Override
    public boolean allowsAddModifier(TariffDAGNode treeNode) {
        return treeNode.getChildIndexWithType(treeNode, 1) < 0 && treeNode.getChildIndexWithType(treeNode, 3) < 0;
    }

    @Override
    public boolean allowsAddNode(TariffDAGNode treeNode) {
        return treeNode.getChildIndexWithType(treeNode, 3) < 0;
    }
}

