/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.statement;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.interfaces.Condition;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.statement.AbstractNodeStatement;
import ericsson.ere.statement.Statement;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.ArrayList;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.statements.NodeStatement.class)
public class NodeStatement
extends AbstractNodeStatement {
    private boolean iShallCallNextWhenFalse = false;
    private double myDiscount = 1.0;

    public NodeStatement(String name, boolean isInverted, double discount) {
        super(name);
        this.iShallCallNextWhenFalse = isInverted;
        this.myDiscount = discount / 100.0;
        this.myChildren = new ArrayList();
        this.myConditions = new ArrayList();
    }

    public NodeStatement(String name) {
        super(name);
    }

    public NodeStatement() {
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        NamedNodeMap attr = null;
        if (iterator.hasAttributes()) {
            attr = iterator.getAttributes();
        }
        if (attr != null) {
            Node node = attr.getNamedItem("Discount");
            if (node != null) {
                this.myDiscount = Double.parseDouble(node.getNodeValue()) / 100.0;
            }
            if ((node = attr.getNamedItem("CallNextWhenFalse")) != null) {
                this.iShallCallNextWhenFalse = Boolean.valueOf(node.getNodeValue());
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.iShallCallNextWhenFalse ? 1231 : 1237);
        long temp = Double.doubleToLongBits(this.myDiscount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NodeStatement other = (NodeStatement)obj;
        if (this.iShallCallNextWhenFalse != other.iShallCallNextWhenFalse) {
            return false;
        }
        return Double.doubleToLongBits(this.myDiscount) == Double.doubleToLongBits(other.myDiscount);
    }

    @Override
    public void rate(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        boolean isValid = false;
        DoubleValue thisCost = new DoubleValue(0.0);
        LongValue thisTime = new LongValue(0L);
        long prevDuration = 0L;
        long localTimeLeftWhenFinished = 0L;
        double backupDiscount = theData.currentDiscount;
        theData.currentDiscount *= this.myDiscount;
        long backupMaxDuration = theData.currentMaxDuration;
        if (theData.useTrace()) {
            if (this.iShallCallNextWhenFalse) {
                theData.getTrace().println("[" + this.getName() + "]    INVERTED NODE    ================================================ [" + this.getName() + "]");
            } else {
                theData.getTrace().println("[" + this.getName() + "] ==================================================================== [" + this.getName() + "]");
            }
            theData.getTrace().println("\tINPUT COST=" + theCost + " TIME=" + theTime);
        }
        while (true) {
            if (this.myConditions == null || this.myConditions.isEmpty()) {
                isValid = true;
            } else {
                int nCond = this.myConditions.size();
                for (int ii = 0; ii < nCond && !(isValid = ((Condition)this.myConditions.get(ii)).test(theData, theCost, theTime)); ++ii) {
                }
            }
            if (isValid && !this.iShallCallNextWhenFalse || !isValid && this.iShallCallNextWhenFalse) {
                prevDuration = theData.currentDuration;
                localTimeLeftWhenFinished = theData.timeLeft - theData.currentMaxDuration;
                if (theData.useTrace()) {
                    theData.getTrace().println("\tCHECK SUBNODES...");
                }
                int nChildren = 0;
                if (this.myChildren != null) {
                    nChildren = this.myChildren.size();
                }
                for (int i = 0; i < nChildren; ++i) {
                    Statement s = (Statement)this.myChildren.get(i);
                    s.rate(theData, thisCost, thisTime);
                    if (theData.currentMaxDuration > theData.timeLeft) {
                        theData.currentMaxDuration = theData.timeLeft;
                    }
                    if (theData.timeLeft == 0L || localTimeLeftWhenFinished >= theData.timeLeft && theData.timeLeft != -1L) break;
                }
                if (theData.timeLeft == 0L || localTimeLeftWhenFinished >= theData.timeLeft) {
                    if (!theData.useTrace()) break;
                    theData.getTrace().println("\tNO MORE TIME FOR THIS NODE...");
                    break;
                }
                if (prevDuration == theData.currentDuration) {
                    if (!theData.useTrace()) break;
                    theData.getTrace().println("\tNO PROGRESS DONE");
                    break;
                }
            } else {
                if (!theData.useTrace()) break;
                theData.getTrace().println("\tDEAD END...");
                break;
            }
            if (!theData.useTrace()) continue;
            theData.getTrace().println("\tTRY AGAIN...");
        }
        theCost.setValue(theCost.value + thisCost.value);
        theTime.setValue(theTime.value + thisTime.value);
        theData.currentMaxDuration = backupMaxDuration - thisTime.value < 0L ? 0L : backupMaxDuration - thisTime.value;
        theData.currentDiscount = backupDiscount;
        if (theData.useTrace()) {
            theData.getTrace().println("----------------------------------------------------------------------" + this.getName());
        }
    }
}

