/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.ratingrules;

import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.ratingrules.AmbiguousLinkTargetException;
import ericsson.ere.ratingrules.UnresolvableLinkException;
import ericsson.ere.ratingrules.UnresolvedLinkTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class LinkHandler {
    private static final int CACHE_UNIQUE_CHILD_LIMIT = 4;
    private TariffStructureNode myRoot;
    private Map<ChildId, TariffStructureNode> myCache = new HashMap<ChildId, TariffStructureNode>();

    public LinkHandler(TariffStructureNode root) {
        this.myRoot = root;
    }

    public boolean resolveLink(TariffStructureNode n) throws Exception {
        TariffNodeLink l = (TariffNodeLink)((Object)n);
        String path = l.getLinkPath();
        StringTokenizer tok = new StringTokenizer(path, "/");
        String firstId = tok.nextToken();
        TariffStructureNode firstChild = this.getUniqueChild(this.myRoot, firstId);
        if (firstChild == null) {
            if (firstId.equals(this.myRoot.getNodeId())) {
                firstChild = this.myRoot;
            } else {
                throw new UnresolvedLinkTargetException("Id not found: ", firstId, this.myRoot);
            }
        }
        TariffStructureNode tgt = null;
        try {
            tgt = this.getNodeForPath(firstChild, tok);
        }
        catch (IllegalArgumentException ie) {
            throw new UnresolvableLinkException("Failed fetching link node path.", ie);
        }
        if (tgt == null) {
            throw new IllegalArgumentException("Unresolved link target: " + path);
        }
        if (tgt.getNodeType() != n.getNodeType()) {
            throw new IllegalArgumentException("Type mismatch: Path \"" + path + "\" resolves to type: " + tgt.getNodeType() + ", expected " + n.getNodeType());
        }
        boolean ret = false;
        if (n.getChildCount() == 0) {
            l.setTarget(tgt);
            ret = true;
        } else if (n.getChildAt(0) == tgt) {
            DAGNode[] referers = tgt.getReferers();
            if (!Arrays.asList(referers).contains(n)) {
                tgt.addReferer(n);
            }
        } else {
            throw new AssertionError((Object)("Link has changed target... Coding error??? " + n.getNodeId()));
        }
        return ret;
    }

    private TariffStructureNode getUniqueChild(TariffStructureNode n, String id) throws IllegalArgumentException {
        ChildId data = new ChildId(n, id);
        TariffStructureNode foundChild = this.myCache.get(data);
        if (foundChild == null) {
            int cc = n.getChildCount();
            for (int i = 0; i < cc; ++i) {
                TariffStructureNode c = (TariffStructureNode)n.getChildAt(i);
                if (!this.idMatches(id, c)) continue;
                if (foundChild != null) {
                    throw new AmbiguousLinkTargetException("Ambiguous node(s) with name ", id, foundChild);
                }
                foundChild = c;
            }
            if (foundChild != null && cc > 4) {
                this.myCache.put(data, foundChild);
            }
        }
        return foundChild;
    }

    private boolean idMatches(String id, TariffStructureNode c) {
        boolean match = id.equals(c.getNodeId());
        return match;
    }

    private TariffStructureNode getNodeForPath(TariffStructureNode n, StringTokenizer tok) {
        if (tok.hasMoreTokens()) {
            String nextid = tok.nextToken();
            TariffStructureNode foundChild = this.getUniqueChild(n, nextid);
            if (foundChild == null) {
                throw new UnresolvedLinkTargetException("Id not found: ", nextid, n);
            }
            return this.getNodeForPath(foundChild, tok);
        }
        return n;
    }

    private static class ChildId {
        private TariffStructureNode myNode;
        private String myId;

        ChildId(TariffStructureNode n, String id) {
            this.myNode = n;
            this.myId = id;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.myId == null ? 0 : this.myId.hashCode());
            result = 31 * result + (this.myNode == null ? 0 : System.identityHashCode(this.myNode));
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChildId other = (ChildId)obj;
            if (this.myId == null ? other.myId != null : !this.myId.equals(other.myId)) {
                return false;
            }
            return !(this.myNode == null ? other.myNode != null : this.myNode != other.myNode);
        }
    }
}

