/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.ratingrules;

import ericsson.ere.interfaces.RatingRuleBuilderErrorHandler;
import ericsson.ere.xml.XMLUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public class BuildErrorCounter
implements RatingRuleBuilderErrorHandler {
    private List<ErrorDetails> mySavedErrors = new ArrayList<ErrorDetails>();

    @Override
    public void handleError(Throwable err, Node ctx, String method, String details) {
        ErrorDetails ed = new ErrorDetails(err, ctx, method, details);
        this.mySavedErrors.add(ed);
    }

    public int getNumberOfErrors() {
        return this.mySavedErrors.size();
    }

    public ErrorDetails getDetailForError(int i) {
        return this.mySavedErrors.get(i);
    }

    public class ErrorDetails {
        private Throwable _err = null;
        private Node _ctx = null;
        private String _method = null;
        private String _details = null;

        public ErrorDetails(Throwable t, Node c, String m, String d) {
            this._err = t;
            this._ctx = c;
            this._method = m;
            this._details = d;
        }

        public Throwable getCause() {
            return this._err;
        }

        public Node getXMLContextNode() {
            return this._ctx;
        }

        public String getXMLContext() {
            if (this._ctx == null) {
                return "???";
            }
            String ctx = XMLUtil.getStringRepresentation(this._ctx);
            if (ctx.length() > 1024) {
                ctx = ctx.substring(0, 1024) + "\n...[truncated]...";
            }
            return ctx;
        }

        public String getXMLContextFull() {
            if (this._ctx == null) {
                return "???";
            }
            return XMLUtil.getStringRepresentation(this._ctx);
        }

        public String getMethod() {
            if (this._method == null) {
                return "???";
            }
            return this._method;
        }

        public String getDetails() {
            if (this._details == null) {
                return "???";
            }
            return this._details;
        }
    }
}

