/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.progress;

import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressSlice;
import ericsson.ere.progress.ProgressVisualizer;

public class ProgressIndicatorHandler
implements ProgressVisualizer,
ProgressSlice {
    int myTotalGoal;
    ProgressVisualizer myVisualizer = null;
    ProgressSliceHandler[] mySlices = null;
    int myCurrentSliceId = -1;
    int myBaseValue = 0;

    public ProgressIndicatorHandler() {
        this.myTotalGoal = 100;
        this.myVisualizer = this;
        this.setProgressGoal(this.myTotalGoal);
    }

    public ProgressIndicatorHandler(int goal) {
        this.myTotalGoal = goal;
        this.myVisualizer = this;
        this.setProgressGoal(this.myTotalGoal);
    }

    public ProgressIndicatorHandler(ProgressVisualizer visual) {
        this.myTotalGoal = 100;
        this.myVisualizer = visual;
        this.setProgressGoal(this.myTotalGoal);
    }

    public ProgressIndicatorHandler(int goal, ProgressVisualizer visual) {
        this.myTotalGoal = goal;
        this.myVisualizer = visual;
        this.setProgressGoal(this.myTotalGoal);
    }

    public String toString() {
        return "Total: " + this.myTotalGoal + ", Base: " + this.myBaseValue + ", CurrentId: " + this.myCurrentSliceId;
    }

    public ProgressIndicator getProgressIndicator() {
        this.mySlices = new ProgressSliceHandler[1];
        this.mySlices[0] = new ProgressSliceHandler(this, this.myTotalGoal, 0);
        return this.mySlices[0];
    }

    public ProgressIndicator[] splitProgress(int slices) {
        if (slices == 0) {
            return new ProgressSliceHandler[0];
        }
        int sliceGoal = this.myTotalGoal / slices;
        int remainingGoal = this.myTotalGoal % slices;
        this.mySlices = new ProgressSliceHandler[slices];
        for (int i = 0; i < slices; ++i) {
            int goal = sliceGoal;
            if (remainingGoal > 0) {
                ++goal;
                --remainingGoal;
            }
            this.mySlices[i] = new ProgressSliceHandler(this, goal, i);
        }
        return this.mySlices;
    }

    public ProgressIndicator[] splitProgress(int[] slices) {
        int remainingGoal;
        if (slices == null || slices.length == 0) {
            return new ProgressSliceHandler[0];
        }
        int totalSlice = 0;
        for (int i = 0; i < slices.length; ++i) {
            totalSlice += slices[i];
        }
        if (totalSlice == 0) {
            return new ProgressSliceHandler[0];
        }
        int sliceGoal = this.myTotalGoal / totalSlice;
        int orgRemainingGoal = remainingGoal = this.myTotalGoal % totalSlice;
        this.mySlices = new ProgressSliceHandler[slices.length];
        for (int i = 0; i < slices.length; ++i) {
            int goal = sliceGoal * slices[i];
            if (remainingGoal > 0) {
                int part = (int)Math.round((double)slices[i] / (double)totalSlice * (double)orgRemainingGoal);
                goal += part;
                remainingGoal -= part;
            }
            if (i == slices.length - 1) {
                goal += remainingGoal;
            }
            this.mySlices[i] = new ProgressSliceHandler(this, goal, i);
        }
        return this.mySlices;
    }

    @Override
    public void setValue(int value) {
        if (this.myVisualizer != null) {
            if (this.myVisualizer == this) {
                int v = (int)((double)(value += this.myBaseValue) / (double)this.myTotalGoal * 100.0);
                System.out.println("Current progress: " + v + "%");
            } else {
                this.myVisualizer.setValue(this.myBaseValue + value);
            }
        }
    }

    @Override
    public void setProgressGoal(int goal) {
        if (this.myVisualizer != null && this.myVisualizer != this) {
            this.myVisualizer.setProgressGoal(goal);
        }
    }

    @Override
    public void setInfoText(String text) {
        if (this.myVisualizer != null) {
            if (this.myVisualizer == this) {
                System.out.println("Progress Info: " + text);
            } else {
                this.myVisualizer.setInfoText(text);
            }
        }
    }

    @Override
    public void showAdditionalInfo(String text) {
        if (this.myVisualizer != null) {
            if (this.myVisualizer == this) {
                System.out.println("Additional Progress Info: " + text);
            } else {
                this.myVisualizer.showAdditionalInfo(text);
            }
        }
    }

    @Override
    public void setConfirmBeforeExit() {
        if (this.myVisualizer != null && this.myVisualizer != this) {
            this.myVisualizer.setConfirmBeforeExit();
        }
    }

    @Override
    public boolean isCanceled() {
        if (this.myVisualizer != null && this.myVisualizer != this) {
            return this.myVisualizer.isCanceled();
        }
        return false;
    }

    @Override
    public void finishPreviousProgress(int id) {
        if (this.myCurrentSliceId == -1) {
            return;
        }
        while (this.myCurrentSliceId < id) {
            int value = this.mySlices[this.myCurrentSliceId++].getRealGoal();
            this.setValue(value);
            this.myBaseValue += value;
        }
    }

    @Override
    public void startProgress(int id) {
        if (this.myCurrentSliceId == -1) {
            this.myCurrentSliceId = 0;
        }
        while (this.myCurrentSliceId < id) {
            int value = this.mySlices[this.myCurrentSliceId++].getRealGoal();
            this.setValue(value);
            this.myBaseValue += value;
        }
    }

    @Override
    public void setInfo(String text) {
        this.setInfoText(text);
    }

    public class ProgressSliceHandler
    implements ProgressIndicator,
    ProgressSlice {
        int myRealGoal;
        int myVirtualGoal;
        int myRealValue;
        int myVirtualValue;
        ProgressSlice myParent;
        int myId;
        ProgressSliceHandler[] myProgressSlices = null;
        int myCurrentProgressSliceId = -1;
        int myBase = 0;

        public ProgressSliceHandler(ProgressSlice parent, int goal, int id) {
            this.myRealGoal = goal;
            this.myVirtualGoal = -1;
            this.myRealValue = 0;
            this.myVirtualValue = -1;
            this.myParent = parent;
            this.myId = id;
        }

        public String toString() {
            StringBuffer msg = new StringBuffer();
            msg.append(this.myParent.toString());
            if (this.myProgressSlices == null) {
                msg.append(" --- " + this.myId + ": Real: " + this.myRealGoal + "(" + this.myRealValue + "), Virtual: " + this.myVirtualGoal + "(" + this.myVirtualValue + ")");
            } else {
                msg.append(" --- " + this.myId + ": Base: " + this.myBase);
            }
            return msg.toString();
        }

        protected int getRealGoal() {
            return this.myRealGoal;
        }

        @Override
        public void finishPreviousProgress(int id) {
            this.myParent.finishPreviousProgress(this.myId);
            if (this.myCurrentProgressSliceId == -1) {
                return;
            }
            while (this.myCurrentProgressSliceId < id) {
                int value = this.myProgressSlices[this.myCurrentProgressSliceId++].getRealGoal();
                this.setValue(value);
                this.myBase += value;
            }
        }

        @Override
        public void setValue(int value) {
            this.myParent.setValue(this.myBase + value);
        }

        @Override
        public void startProgress(int id) {
            this.myParent.startProgress(this.myId);
            if (this.myCurrentProgressSliceId == -1) {
                this.myCurrentProgressSliceId = 0;
            }
            while (this.myCurrentProgressSliceId < id) {
                int value = this.myProgressSlices[this.myCurrentProgressSliceId++].getRealGoal();
                this.setValue(value);
                this.myBase += value;
            }
        }

        @Override
        public void setInfo(String text) {
            ProgressIndicatorHandler.this.setInfoText(text);
        }

        @Override
        public void showAdditionalInfo(String text) {
            this.myParent.showAdditionalInfo(text);
        }

        @Override
        public void setConfirmBeforeExit() {
            this.myParent.setConfirmBeforeExit();
        }

        @Override
        public boolean isCanceled() {
            return this.myParent.isCanceled();
        }

        @Override
        public void progressStart(int goal) {
            this.myVirtualGoal = goal;
            this.myVirtualValue = 0;
            this.myParent.startProgress(this.myId);
        }

        @Override
        public void progressStart() {
            this.myParent.startProgress(this.myId);
        }

        @Override
        public void progressFinished() {
            this.myRealValue = this.myRealGoal;
            this.setValue(this.myRealValue);
        }

        @Override
        public void progressIncrement() {
            this.progressIncrement(1);
        }

        @Override
        public void progressIncrement(int step) {
            this.myParent.startProgress(this.myId);
            if (this.myVirtualGoal != -1) {
                this.myVirtualValue += step;
                if (this.myVirtualValue > this.myVirtualGoal) {
                    this.myVirtualValue = this.myVirtualGoal;
                }
                this.myRealValue = (int)((double)this.myVirtualValue / (double)this.myVirtualGoal * (double)this.myRealGoal);
            } else {
                this.myRealValue += step;
                if (this.myRealValue > this.myRealGoal) {
                    this.myRealValue = this.myRealGoal;
                }
            }
            this.setValue(this.myRealValue);
        }

        @Override
        public int getProgressGoal() {
            return this.myVirtualGoal != -1 ? this.myVirtualGoal : this.myRealGoal;
        }

        @Override
        public ProgressIndicator[] splitProgress(int slices) {
            if (slices == 0) {
                return new ProgressSliceHandler[0];
            }
            this.myParent.startProgress(this.myId);
            int sliceGoal = this.myRealGoal / slices;
            int remainingGoal = this.myRealGoal % slices;
            this.myProgressSlices = new ProgressSliceHandler[slices];
            for (int i = 0; i < slices; ++i) {
                int goal = sliceGoal;
                if (remainingGoal > 0) {
                    ++goal;
                    --remainingGoal;
                }
                this.myProgressSlices[i] = new ProgressSliceHandler(this, goal, i);
            }
            return this.myProgressSlices;
        }

        @Override
        public ProgressIndicator[] splitProgress(int[] slices) {
            int remainingGoal;
            if (slices == null || slices.length == 0) {
                return new ProgressSliceHandler[0];
            }
            this.myParent.startProgress(this.myId);
            int totalSlice = 0;
            for (int i = 0; i < slices.length; ++i) {
                totalSlice += slices[i];
            }
            if (totalSlice == 0) {
                return new ProgressSliceHandler[0];
            }
            int sliceGoal = this.myRealGoal / totalSlice;
            int orgRemainingGoal = remainingGoal = this.myRealGoal % totalSlice;
            this.myProgressSlices = new ProgressSliceHandler[slices.length];
            for (int i = 0; i < slices.length; ++i) {
                int goal = sliceGoal * slices[i];
                if (remainingGoal > 0) {
                    int part = (int)Math.round((double)slices[i] / (double)totalSlice * (double)orgRemainingGoal);
                    goal += part;
                    remainingGoal -= part;
                }
                if (i == slices.length - 1) {
                    goal += remainingGoal;
                }
                this.myProgressSlices[i] = new ProgressSliceHandler(this, goal, i);
            }
            return this.myProgressSlices;
        }
    }
}

