/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import com.ericsson.ere.io.IOCloser;
import com.ericsson.ere.selectiontree.ProgressiveCacheSelectionTreeNodeFactory;
import com.ericsson.ere.selectiontree.SelectionTreeBuilder;
import com.ericsson.ere.selectiontree.SelectionTreeNodeFactoryImpl;
import com.ericsson.ere.selectiontree.StreamBasedSelectionTreeBuilder;
import com.ericsson.ere.selectiontree.interfaces.SelectionTreeNodeFactory;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreDefs;
import ericsson.ere.exception.EreException;
import ericsson.ere.exception.EreFileException;
import ericsson.ere.exception.RatingException;
import ericsson.ere.interfaces.TariffStructure;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.ratingrules.RatingBuilderErrorHandler;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RatingPeriod {
    public static final String USE_PROGRESSIVE_CACHE = "ERE.RPUseProgressiveCache";
    public static final String USE_STREAM_BASED_PARSER = "ERE.RPUseStreamBasedParser";
    private static final Calendar DATE_19700101 = Calendar.getInstance();
    private String TAG_NAME = "RatingPeriod";
    private String myName;
    private String myRatingPlanId;
    private String myProviderId;
    private String myServiceId;
    private String myFileName;
    private String myActiveFileName;
    private String myRevision;
    private Calendar myStartTime;
    private Calendar myLastModified;
    private RatingPlan myRatingPlan;
    private TariffStructure myRatingStructure;
    private Boolean myUseStreamBasedParserOverride;
    private Boolean myUseProgressiveCacheOverride;
    private boolean myIsStarted = false;
    private boolean myLastUpdateOk = false;

    @Deprecated
    public RatingPeriod(String name, String ratingPlanId, String serviceId, String providerId, String fileName, String revision, Calendar startTime, Calendar lastModified, InputStream data) {
        this(name, ratingPlanId, serviceId, providerId, fileName, revision, startTime, lastModified);
    }

    public RatingPeriod(String name, String ratingPlanId, String serviceId, String providerId, String fileName, String revision, Calendar startTime, Calendar lastModified) {
        this.myName = name.trim();
        this.myRatingPlanId = ratingPlanId;
        this.myServiceId = serviceId;
        this.myProviderId = providerId;
        this.myFileName = StringUtil.convertFilePathString(fileName);
        this.myStartTime = startTime != null ? startTime : (Calendar)DATE_19700101.clone();
        this.myLastModified = lastModified;
        this.myRevision = revision;
    }

    public RatingPeriod(String name, RatingPlan ratingPlan, String serviceId, String providerId, String fileName, String revision, Calendar startTime, Calendar lastModified) {
        this(name, ratingPlan.getIdentity(), serviceId, providerId, fileName, revision, startTime, lastModified);
        this.myRatingPlan = ratingPlan;
    }

    public RatingPeriod(RatingPlan aRatingPlan, String aName, String aProvider) {
        this(aName, aRatingPlan, aRatingPlan.getServiceName(), aProvider, "", null, (Calendar)DATE_19700101.clone(), Calendar.getInstance());
    }

    public void startStructure() throws Exception {
        if (this.isStreamBasedParserEnabled()) {
            this._startStructureStream(new FileInputStream(this.myFileName));
        } else {
            this._startStructure(StructureBuilder.FILE, this.myFileName);
        }
    }

    public void startStructure(InputStream data) throws Exception {
        if (this.isStreamBasedParserEnabled()) {
            this._startStructureStream(data);
        } else {
            this._startStructure(StructureBuilder.INPUTSTREAM, data);
        }
    }

    public void startStructure(Element element) throws Exception {
        this._startStructure(StructureBuilder.ELEMENT, element);
    }

    private void _startStructureStream(InputStream stream) throws EreFileException {
        this.myLastUpdateOk = false;
        try {
            this.checkRequiredMembers();
            SelectionTreeNodeFactory nodeFactory = this.createNodeFactory();
            RatingBuilderErrorHandler errorHandler = new RatingBuilderErrorHandler();
            StreamBasedSelectionTreeBuilder builder = new StreamBasedSelectionTreeBuilder(nodeFactory, errorHandler);
            this.myRatingStructure = (TariffStructure)builder.build(stream, null);
            this.myActiveFileName = this.myFileName;
            this.myIsStarted = true;
            this.myLastUpdateOk = true;
        }
        catch (Exception e) {
            this.myRatingStructure = null;
            this.myIsStarted = false;
            throw new EreFileException(this.myFileName, EreDefs.getErrorString("error.errorBuildingStructure") + e.getMessage(), e);
        }
        finally {
            IOCloser.closeIgnoringException(stream);
        }
    }

    private void _startStructure(StructureBuilder sb, Object src) throws EreFileException {
        this.myLastUpdateOk = false;
        try {
            this.checkRequiredMembers();
            SelectionTreeNodeFactory nodeFactory = this.createNodeFactory();
            RatingBuilderErrorHandler errorHandler = new RatingBuilderErrorHandler();
            SelectionTreeBuilder builder = new SelectionTreeBuilder(nodeFactory, errorHandler);
            this.myRatingStructure = sb.buildStructure(builder, src);
            this.myActiveFileName = this.myFileName;
            this.myIsStarted = true;
            this.myLastUpdateOk = true;
        }
        catch (Exception e) {
            this.myRatingStructure = null;
            this.myIsStarted = false;
            throw new EreFileException(this.myFileName, EreDefs.getErrorString("error.errorBuildingStructure") + e.getMessage(), e);
        }
    }

    protected SelectionTreeNodeFactory createNodeFactory() {
        ClassRepository repository = this.myRatingPlan.getService().getClassRepository(new FieldContext(this.myProviderId, this.myRatingPlanId));
        SelectionTreeNodeFactory nodeFactory = new SelectionTreeNodeFactoryImpl(repository, this.myRatingPlanId);
        if (this.isProgressiveCacheEnabled()) {
            nodeFactory = new ProgressiveCacheSelectionTreeNodeFactory(repository, nodeFactory);
        }
        return nodeFactory;
    }

    public boolean isStreamBasedParserEnabled() {
        if (this.myUseStreamBasedParserOverride != null) {
            return this.myUseStreamBasedParserOverride;
        }
        return RatingPeriod.isStreamBasedParserEnabledGlobally();
    }

    public static boolean isStreamBasedParserEnabledGlobally() {
        String value = System.getProperty(USE_STREAM_BASED_PARSER, "true");
        return Boolean.parseBoolean(value);
    }

    public void setStreamBasedParserEnabled(boolean use) {
        this.myUseStreamBasedParserOverride = use;
    }

    public void setProgressiveNodeCacheEnabled(boolean use) {
        this.myUseProgressiveCacheOverride = use;
    }

    public boolean isProgressiveCacheEnabled() {
        if (this.myUseProgressiveCacheOverride != null) {
            return this.myUseProgressiveCacheOverride;
        }
        return RatingPeriod.isProgressiveCacheEnabledGlobally();
    }

    public static boolean isProgressiveCacheEnabledGlobally() {
        String value = System.getProperty(USE_PROGRESSIVE_CACHE, "false");
        return Boolean.parseBoolean(value);
    }

    private void checkRequiredMembers() throws EreException {
        if (this.myRatingPlan == null) {
            throw new EreException(EreDefs.getErrorString("error.noPlanFound"));
        }
        if (this.myRatingPlan.getService() == null) {
            throw new EreException(EreDefs.getErrorString("error.noServiceDefinitionFound"));
        }
        if (this.myRatingPlan.getService().getClassRepository(new FieldContext(this.myServiceId, this.myRatingPlanId)) == null) {
            throw new EreException(EreDefs.getErrorString("error.noClassRepository"));
        }
    }

    public void replan(Calendar startTime, Calendar lastModified) throws Exception {
        RatingPeriod existing = null;
        try {
            existing = this.myRatingPlan.getActualRatingPeriod(startTime);
            if (existing != this && RatingPlan.areTimesEqualBySecond(startTime, existing.getStartTime())) {
                throw new Exception("A period with the new start time already exists: " + existing.getName());
            }
        }
        catch (RatingException ratingException) {
            // empty catch block
        }
        if (existing == this) {
            this.myStartTime = (Calendar)startTime.clone();
            this.myLastModified = (Calendar)lastModified.clone();
        } else {
            RatingPeriod removed = this.myRatingPlan.removeRatingPeriod(this.getName(), this.getStartTime());
            assert (removed == null || removed == this);
            this.myStartTime = (Calendar)startTime.clone();
            this.myLastModified = (Calendar)lastModified.clone();
            int result = this.myRatingPlan.addRatingPeriod(this);
            assert (result == 0);
        }
    }

    public void update(String fileName, String revision, Calendar lastModified, InputStream data) throws Exception {
        Document doc;
        Node node = null;
        if (data != null) {
            doc = XMLUtil.buildDocument(data);
        } else {
            File file = new File(fileName);
            doc = XMLUtil.buildDocumentFromFile(file);
        }
        NodeList children = doc.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len && node == null; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !"TariffStructure".equals(child.getNodeName())) continue;
            node = child;
        }
        if (node == null) {
            throw new EreFileException(fileName, EreDefs.getErrorString("error.errorBuildingStructure"));
        }
        this.update(fileName, revision, lastModified, node);
    }

    public void update(String fileName, String revision, Calendar lastModified, Node tsNode) throws Exception {
        this.myLastModified = (Calendar)lastModified.clone();
        this.myFileName = StringUtil.convertFilePathString(fileName);
        this._startStructure(StructureBuilder.NODE, tsNode);
        this.myRevision = revision;
    }

    public boolean isStarted() {
        return this.myIsStarted;
    }

    public boolean lastUpdateOk() {
        return this.myLastUpdateOk;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String aName) {
        this.myName = aName.trim();
    }

    public Calendar getStartTime() {
        return this.myStartTime;
    }

    public void setStartTime(Calendar time) {
        this.myStartTime = (Calendar)time.clone();
    }

    public Calendar getLastModified() {
        return (Calendar)this.myLastModified.clone();
    }

    public void setLastModified(Calendar lastModified) {
        this.myLastModified = lastModified;
    }

    public String getRevision() {
        return this.myRevision;
    }

    public String getRatingPlanId() {
        return this.myRatingPlanId;
    }

    public String getServiceId() {
        return this.myServiceId;
    }

    public String getServiceProviderName() {
        return this.myProviderId;
    }

    public String getActiveFileName() {
        return this.myActiveFileName;
    }

    public String getFileName() {
        return this.myFileName;
    }

    @Deprecated
    public void setFileName(String fileName) {
        this.myFileName = StringUtil.convertFilePathString(fileName);
    }

    @Deprecated
    public void setRatingPlan(RatingPlan aPlan) {
        this.myRatingPlan = aPlan;
        this.myRatingPlanId = aPlan.getIdentity();
    }

    public RatingPlan getRatingPlan() {
        return this.myRatingPlan;
    }

    public TariffStructure getTariffStructure() {
        return this.myRatingStructure;
    }

    public com.ericsson.ere.selectiontree.interfaces.TariffStructure getTariffStructureForDataSet() {
        return (com.ericsson.ere.selectiontree.interfaces.TariffStructure)((Object)this.myRatingStructure);
    }

    public com.ericsson.ere.selectiontree.interfaces.TariffStructure getTraceTariffStructureForDataSet() {
        return (com.ericsson.ere.selectiontree.interfaces.TariffStructure)((Object)((com.ericsson.ere.selectiontree.interfaces.TariffStructure)((Object)this.myRatingStructure)).createTraceNode(0, null));
    }

    public void setTariffStructure(TariffStructure aStructure) {
        this.myRatingStructure = aStructure;
    }

    public boolean equals(String name, Calendar startTime) {
        return this.myName.equals(name) && this.myStartTime.equals(startTime);
    }

    public boolean equals(Object anObject) {
        if (anObject == null || this.getClass() != anObject.getClass()) {
            return false;
        }
        if (this == anObject) {
            return true;
        }
        RatingPeriod aPeriod = (RatingPeriod)anObject;
        return this.equals(aPeriod.getName(), aPeriod.getStartTime()) && this.myRatingPlanId.equals(aPeriod.getRatingPlanId()) && this.myProviderId.equals(aPeriod.getServiceProviderName());
    }

    @Deprecated
    public void changeRatingPeriodName(String aName, String startDateAndTime) throws Exception {
        String newName = aName.trim();
        if (!newName.equals(this.myName)) {
            this.changeNameAndStartTime(newName, DateUtil.stringToCalendar(startDateAndTime));
        }
    }

    public void changeNameAndStartTime(String aName, Calendar startDateAndTime) throws Exception {
        String newName = aName.trim();
        if (newName.equals(this.myName) && startDateAndTime.equals(this.myStartTime)) {
            return;
        }
        this.replan(startDateAndTime, this.myLastModified);
        this.myName = newName;
    }

    public void printAll() {
        System.out.println(this.toString());
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("\n").append("Name: ").append(this.myName).append("\n");
        buffer.append("Rating Plan: ").append(this.myRatingPlanId).append("\n");
        buffer.append("Service Provider: ").append(this.myProviderId).append("\n");
        buffer.append("Revision: ").append(this.myRevision).append("\n");
        String startTime = "";
        if (this.myStartTime != null) {
            startTime = this.myStartTime.getTime().toString();
        }
        buffer.append("Start Time: ").append(startTime).append("\n");
        buffer.append("File Name: ").append(this.myFileName).append("\n");
        buffer.append("Last Modified: ").append(this.myLastModified.getTime().toString()).append("\n");
        return buffer.toString();
    }

    public String getXMLDefinition(String tabs) {
        return this.getStartTag(tabs) + "\n" + this.getEndTag(tabs) + "\n";
    }

    public String getStartTag(String tabs) {
        String startTime = "";
        if (this.myStartTime != null) {
            startTime = DateUtil.formatISODateTime(this.myStartTime, false);
        }
        return tabs + "<" + this.TAG_NAME + XMLUtil.wrapInAttribute("Name", this.myName) + XMLUtil.wrapInAttribute("StartDate", startTime) + XMLUtil.wrapInAttribute("TariffStructureFile", this.myFileName) + " >";
    }

    public String getEndTag(String tabs) {
        return tabs + "</" + this.TAG_NAME + ">";
    }

    static {
        DATE_19700101.set(1970, 1, 1, 0, 0, 0);
    }

    private static enum StructureBuilder {
        NODE{

            @Override
            public TariffStructure buildStructure(SelectionTreeBuilder builder, Object src) throws Exception {
                return (TariffStructure)builder.build((Node)src);
            }
        }
        ,
        ELEMENT{

            @Override
            public TariffStructure buildStructure(SelectionTreeBuilder builder, Object src) throws Exception {
                return (TariffStructure)builder.build((Element)src);
            }
        }
        ,
        INPUTSTREAM{

            @Override
            public TariffStructure buildStructure(SelectionTreeBuilder builder, Object src) throws Exception {
                return (TariffStructure)builder.build((InputStream)src);
            }
        }
        ,
        FILE{

            @Override
            public TariffStructure buildStructure(SelectionTreeBuilder builder, Object src) throws Exception {
                return (TariffStructure)builder.buildFromFile(new File((String)src), null);
            }
        };


        public abstract TariffStructure buildStructure(SelectionTreeBuilder var1, Object var2) throws Exception;
    }
}

