/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.management;

import ericsson.ere.defs.ClassRepository;
import ericsson.ere.management.FieldContext;
import ericsson.ere.management.Service;

public class ContextAwareServiceContainer {
    private final Service myService;
    private final FieldContext myFieldContext;

    private ContextAwareServiceContainer(Service service, FieldContext fieldContext) {
        if (service == null || fieldContext == null) {
            throw new IllegalArgumentException("Service and FieldContext parameters must NOT be null");
        }
        this.myService = service;
        this.myFieldContext = fieldContext;
    }

    public static ContextAwareServiceContainer createContainerWithoutContext(Service service) {
        return new ContextAwareServiceContainer(service, FieldContext.NO_CONTEXT);
    }

    public static ContextAwareServiceContainer createContainerWithContext(Service service, FieldContext fieldContext) {
        return new ContextAwareServiceContainer(service, fieldContext);
    }

    public Service getService() {
        return this.myService;
    }

    public FieldContext getFieldContext() {
        return this.myFieldContext;
    }

    public ClassRepository getClassRepository() {
        return this.myService.getClassRepository(this.myFieldContext);
    }
}

