/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf.bonus;

import ericsson.ere.RatingData;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BonusRate
extends AbstractModifier {
    private double myPrice;
    private long myInterval;
    private long myFactor;

    public BonusRate(double aPrice, long aInterval, long aFactor) {
        this.myPrice = aPrice;
        this.myInterval = aInterval;
        this.myFactor = aFactor;
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        double thePrice = 0.0;
        long theInterval = 1L;
        long theFactor = 0L;
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals("Price".toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    thePrice = Double.parseDouble(value.item(bb).getNodeValue());
                }
                if (children.item(aa).getNodeName().toLowerCase().equals("Interval".toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    theInterval = Long.parseLong(value.item(bb).getNodeValue());
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals("Factor".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theFactor = Long.parseLong(value.item(bb).getNodeValue());
            }
        }
        this.myPrice = thePrice;
        this.myInterval = theInterval;
        this.myFactor = theFactor;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myFactor ^ this.myFactor >>> 32);
        result = 31 * result + (int)(this.myInterval ^ this.myInterval >>> 32);
        long temp = Double.doubleToLongBits(this.myPrice);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BonusRate other = (BonusRate)obj;
        if (this.myFactor != other.myFactor) {
            return false;
        }
        if (this.myInterval != other.myInterval) {
            return false;
        }
        return Double.doubleToLongBits(this.myPrice) == Double.doubleToLongBits(other.myPrice);
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) {
        if (theData.skipTimeCharging == 1 || theData.currentMaxDuration == -1L) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tBonusRate.myPrice => " + this.myPrice + "; Do not active during UnsuccCallSetup or for some CDR.  No time to analyse");
            }
        } else {
            if (theData.useTrace()) {
                theData.getTrace().println("\tBonusRate.myPrice => " + this.myPrice);
            }
            double price = this.myPrice * theData.currentDiscount;
            long secs = theData.currentMaxDuration / this.myInterval * this.myInterval;
            if (theData.currentMaxDuration % this.myInterval > 0L) {
                secs += this.myInterval;
            }
            double cost = (double)secs * price / 60.0;
            if (theData.useTrace()) {
                theData.getTrace().println("\tBONUSRATE MD = " + theData.currentMaxDuration + " SECS " + secs + " PRICE " + price + " = " + cost);
            }
            long theIntendedChangeOfTheAccumulator = 0L;
            long maxAccumulatorDecrease = theData.getWorkingLong("maxAccumulatorDecrease");
            long maxAccumulatorIncrease = theData.getWorkingLong("maxAccumulatorIncrease");
            if ((double)this.myFactor < 0.0) {
                theIntendedChangeOfTheAccumulator = secs * this.myFactor - theIntendedChangeOfTheAccumulator;
                System.out.println("Intended decrease of the accumulator: " + theIntendedChangeOfTheAccumulator);
                if (theIntendedChangeOfTheAccumulator < maxAccumulatorDecrease) {
                    System.out.println("Consider maxAccumulatorDecrease... re-calculate the time...");
                    secs = maxAccumulatorDecrease / this.myFactor;
                    if (secs < this.myInterval) {
                        secs = this.myInterval;
                    } else if ((secs = secs / this.myInterval * this.myInterval) % this.myInterval != 0L) {
                        secs += this.myInterval;
                    }
                    if (secs * this.myFactor > maxAccumulatorDecrease) {
                        System.out.println("Adjust secs due to interval and factor...");
                        secs += this.myInterval;
                    }
                    cost = (double)secs * price / 60.0;
                    System.out.println("New time to rate: " + secs);
                }
            }
            if ((double)this.myFactor > 0.0) {
                theIntendedChangeOfTheAccumulator = secs * this.myFactor + theIntendedChangeOfTheAccumulator;
                System.out.println("Intended increase of the accumulator: " + theIntendedChangeOfTheAccumulator);
                if (theIntendedChangeOfTheAccumulator > maxAccumulatorIncrease) {
                    System.out.println("Consider maxAccumulatorIncrease... re-calculate the time...");
                    secs = maxAccumulatorIncrease / this.myFactor;
                    if (secs < this.myInterval) {
                        secs = this.myInterval;
                    } else if ((secs = secs / this.myInterval * this.myInterval) % this.myInterval != 0L) {
                        secs += this.myInterval;
                    }
                    if (secs * this.myFactor < maxAccumulatorIncrease) {
                        System.out.println("Adjust secs due to interval and factor...");
                        secs += this.myInterval;
                    }
                    cost = (double)secs * price / 60.0;
                    System.out.println("New time to rate: " + secs);
                }
            }
            if (theData.moneyLeft != -1.0 && cost > 0.0 && theData.moneyLeft - cost <= -1.0E-7) {
                if (theData.useTrace()) {
                    theData.getTrace().println("\tNO MORE MONEY TO CONTINUE CALL...");
                }
                secs = (long)(theData.moneyLeft * 60.0 / price);
                secs = secs / this.myInterval * this.myInterval;
                cost = (double)secs * price / 60.0;
            }
            if (theData.useTrace()) {
                theData.getTrace().println("\tBONUSRATE COST = (" + secs + "* (" + this.myPrice + "*" + theData.currentDiscount + ") ) /60 = " + cost);
            }
            theCost.setValue(theCost.value + theData.allocateCost(cost));
            theTime.setValue(theTime.value + theData.allocateTime(secs));
            long currentBonus = (Long)theData.getValueObject("Bonus counter");
            System.out.println("BonusFee.perform: currentBonus before is " + currentBonus);
            currentBonus = secs * this.myFactor + currentBonus;
            System.out.println("BonusFee.perform: currentBonus after is " + currentBonus);
            Long newBonus = new Long(currentBonus);
            theData.setFirstField("Bonus result", newBonus);
            theData.setFirstField("Bonus counter", newBonus);
            System.out.println("Added new value to RatingData");
            if (theData.useTrace()) {
                theData.getTrace().println("\tBONUSRATE BONUS = (" + secs + "* (" + this.myFactor + ") ) = " + currentBonus);
            }
        }
    }
}

