/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf;

import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.leaf.AbstractModifierProfile;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RateProfile
extends AbstractModifierProfile {
    static String LBL_PRICE = "Price per minute";
    static String LBL_INTERVAL = "Charging interval";

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        l.add(new DoubleVariable(LBL_PRICE, 0.0));
        l.add(new IntegerVariable(LBL_INTERVAL, 1, 1, Integer.MAX_VALUE));
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>(3);
        String thePrice = "0.0";
        String theChargingInterval = "0";
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals("Price".toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    thePrice = value.item(bb).getNodeValue();
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals("Interval".toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theChargingInterval = value.item(bb).getNodeValue();
            }
        }
        l.add(new DoubleVariable(LBL_PRICE, thePrice));
        l.add(new IntegerVariable(LBL_INTERVAL, theChargingInterval, 1, Integer.MAX_VALUE));
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        String interval = VarListUtil.getValueStringForName(variables, LBL_INTERVAL);
        out.println("<Price>" + price + "</Price>");
        out.println("<Interval>" + interval + "</Interval>");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        String interval = VarListUtil.getValueStringForName(variables, LBL_INTERVAL);
        return name + " Price=" + price + " Interval=" + interval;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String price = VarListUtil.getValueStringForName(variables, LBL_PRICE);
        String interval = VarListUtil.getValueStringForName(variables, LBL_INTERVAL);
        String info = "<b>" + name + "</b> (Price=" + price + " Interval=" + interval + ")\n" + this.getComment(variables);
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

