/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.modifiers.RateInterval.class)
public class RateInterval
extends AbstractModifier {
    private double myPrice;
    private int myPriceInterval;
    private int myChargingInterval;
    public static final String TAG_PRICE_INTERVAL = "PriceInterval";

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        double thePrice = 0.0;
        int thePriceInterval = 1;
        int theChargingInterval = 1;
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().equalsIgnoreCase("Price") && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    thePrice = Double.parseDouble(value.item(bb).getNodeValue());
                }
                if (children.item(aa).getNodeName().equalsIgnoreCase("Interval") && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    theChargingInterval = Integer.parseInt(value.item(bb).getNodeValue());
                }
                if (!children.item(aa).getNodeName().equalsIgnoreCase(TAG_PRICE_INTERVAL) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                thePriceInterval = Integer.parseInt(value.item(bb).getNodeValue());
            }
        }
        this.myPrice = thePrice;
        this.myPriceInterval = thePriceInterval;
        this.myChargingInterval = theChargingInterval;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myChargingInterval;
        long temp = Double.doubleToLongBits(this.myPrice);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.myPriceInterval;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RateInterval other = (RateInterval)obj;
        if (this.myChargingInterval != other.myChargingInterval) {
            return false;
        }
        if (Double.doubleToLongBits(this.myPrice) != Double.doubleToLongBits(other.myPrice)) {
            return false;
        }
        return this.myPriceInterval == other.myPriceInterval;
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        if (theData.useTrace()) {
            theData.getTrace().println("\tRateInterval.myPrice => " + this.myPrice + " per " + this.myPriceInterval);
        }
        double price = this.myPrice * theData.currentDiscount;
        long secs = theData.currentMaxDuration / (long)this.myChargingInterval * (long)this.myChargingInterval;
        if (theData.currentMaxDuration % (long)this.myChargingInterval > 0L) {
            secs += (long)this.myChargingInterval;
        }
        double cost = (double)secs * price / (double)this.myPriceInterval;
        if (theData.useTrace()) {
            theData.getTrace().println("\tRateInterval max duration = " + theData.currentMaxDuration + ", (time:) " + secs + " * (price:) " + price / (double)this.myPriceInterval + " = (cost:) " + cost);
        }
        if (theData.moneyLeft != -1.0 && cost > 0.0 && theData.moneyLeft - cost <= -1.0E-7) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tNO MORE MONEY TO CONTINUE CALL...");
            }
            secs = (long)(theData.moneyLeft * (double)this.myPriceInterval / price);
            secs = secs / (long)this.myChargingInterval * (long)this.myChargingInterval;
            cost = (double)secs * price / (double)this.myPriceInterval;
        }
        if (theData.useTrace()) {
            theData.getTrace().println("\tRateInterval COST = ( (time:) " + secs + " * (price:) " + this.myPrice + " / (interval:) " + this.myPriceInterval + " = " + cost);
        }
        theCost.setValue(theCost.value + theData.allocateCost(cost));
        theTime.setValue(theTime.value + theData.allocateTime(secs));
    }
}

