/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.leaf;

import ericsson.ere.RatingData;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.Modifier;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifier;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CompoundModifier
extends AbstractModifier {
    public static final short OP_SUM = 0;
    public static final short OP_MIN = 1;
    public static final short OP_MAX = 2;
    short myOperation = (short)-1;
    List<DAGNode> myModifiers;

    public CompoundModifier(String operator) {
        if ("SUM".equalsIgnoreCase(operator)) {
            this.myOperation = 0;
        } else if ("MIN".equalsIgnoreCase(operator)) {
            this.myOperation = 1;
        } else if ("MAX".equalsIgnoreCase(operator)) {
            this.myOperation = (short)2;
        } else {
            throw new IllegalArgumentException("CompoundModifier: Unknown operation: " + operator);
        }
    }

    @Override
    public void perform(RatingData theData, DoubleValue theCost, LongValue theTime) {
        switch (this.myOperation) {
            case 0: {
                this.performSUM(theData, theCost, theTime);
                break;
            }
            case 1: {
                this.performMIN(theData, theCost, theTime);
                break;
            }
            case 2: {
                this.performMAX(theData, theCost, theTime);
                break;
            }
            default: {
                throw new IllegalArgumentException("CompoundModifier: Unknown operation: " + this.myOperation);
            }
        }
    }

    public void performSUM(RatingData theData, DoubleValue theCost, LongValue theTime) {
    }

    public void performMIN(RatingData theData, DoubleValue theCost, LongValue theTime) {
    }

    public void performMAX(RatingData theData, DoubleValue theCost, LongValue theTime) {
    }

    @Override
    public void add(Modifier child) throws Exception {
        this.addChild((DAGNode)((Object)child));
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String operator = "???";
        this.myOperation = (short)-1;
        NodeList children = iterator.getChildNodes();
        int nTariffs = 0;
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeName().equalsIgnoreCase("Operation")) {
                if (!child.hasChildNodes()) continue;
                operator = child.getChildNodes().item(0).getNodeValue().trim();
                continue;
            }
            if (!child.getNodeName().equalsIgnoreCase("Tariff")) continue;
            ++nTariffs;
        }
        if ("SUM".equalsIgnoreCase(operator)) {
            this.myOperation = 0;
        } else if ("MIN".equalsIgnoreCase(operator)) {
            this.myOperation = 1;
        } else if ("MAX".equalsIgnoreCase(operator)) {
            this.myOperation = (short)2;
        } else {
            throw new IllegalArgumentException("CompoundModifier: Unknown operation: " + operator);
        }
        this.myModifiers = new ArrayList<DAGNode>(nTariffs);
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.myModifiers == null ? 0 : this.myModifiers.hashCode());
        result = 31 * result + this.myOperation;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CompoundModifier other = (CompoundModifier)obj;
        if (this.myModifiers == null ? other.myModifiers != null : !this.myModifiers.equals(other.myModifiers)) {
            return false;
        }
        return this.myOperation == other.myOperation;
    }

    @Override
    public DAGNode getChildAt(int index) {
        return this.myModifiers.get(index);
    }

    @Override
    public int getChildCount() {
        return this.myModifiers.size();
    }

    @Override
    public void insertChildAt(int index, DAGNode node) {
        if (DAGUtil.pathExists(node, this)) {
            throw new IllegalArgumentException("Cycle detected when trying to add node: " + node + " to " + this);
        }
        this.myModifiers.add(index, node);
        node.setParent(this);
    }

    @Override
    public void insertLinkAt(int index, DAGNode node) {
        if (DAGUtil.pathExists(node, this)) {
            throw new IllegalArgumentException("Cycle detected when trying to add node: " + node + " to " + this);
        }
        this.myModifiers.add(index, node);
        node.addReferer(this);
    }

    @Override
    public void replace(DAGNode child, DAGNode replacement) {
        int i = -1;
        if (this.myModifiers != null) {
            i = DAGUtil.indexOf(child, this.myModifiers);
        }
        if (i < 0) {
            throw new IllegalArgumentException("Child not found: " + child);
        }
        this.myModifiers.set(i, replacement);
    }

    @Override
    protected void removeChild(DAGNode node) {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    protected void removeLink(DAGNode node) {
        throw new IllegalArgumentException("Node not removed, structure is read-only");
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }
}

