/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.settingsmap.propertyio;

import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import java.util.Set;
import org.w3c.dom.Element;

public class XMLOutput {
    private static final String TAG_PARAMETER = "Parameter";
    private static final String TAG_PROPERTY = "Property";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_VALUE = "value";
    public static final String ATTR_TYPE = "type";
    private static final String TYPE_BOOLEAN = "Boolean";
    private static final String TYPE_INTEGER = "Integer";
    private static final String TYPE_STRING = "String";
    private static final String TYPE_TIME = "Time";
    private static final String TYPE_FILE = "File";
    private static final String ATTR_ENC = "enc";
    private static final String PAR_PASSWORD = "Password";

    @Deprecated
    public static void writeToElement(SettingsMap settingsMap, Element root) throws Exception {
        XMLOutput.appendToElement(settingsMap, root);
    }

    public static void appendToElement(SettingsMap settingsMap, Element root) {
        Set<String> keys = settingsMap.getParametersKeySet();
        for (String key : keys) {
            Parameter parameter = settingsMap.getParameter(key);
            Element parameterElement = root.getOwnerDocument().createElement(TAG_PARAMETER);
            parameterElement.setAttribute(ATTR_NAME, key);
            parameterElement.setAttribute(ATTR_TYPE, XMLOutput.getTypeAsString(parameter.getType()));
            parameterElement.setAttribute(ATTR_VALUE, parameter.getValue());
            if (key.equals(PAR_PASSWORD) && !parameter.getValue().isEmpty()) {
                parameterElement.setAttribute(ATTR_ENC, Boolean.TRUE.toString());
            }
            root.appendChild(parameterElement);
        }
        Set<Object> properties = settingsMap.getPropertiesKeySet();
        for (Object oKey : properties) {
            String key = (String)oKey;
            String value = settingsMap.getProperty(key);
            Element propertyElement = root.getOwnerDocument().createElement(TAG_PROPERTY);
            propertyElement.setAttribute(ATTR_NAME, value);
            root.appendChild(propertyElement);
        }
    }

    private static String getTypeAsString(int type) {
        String typeString;
        switch (type) {
            case 3: {
                typeString = TYPE_BOOLEAN;
                break;
            }
            case 0: {
                typeString = TYPE_INTEGER;
                break;
            }
            case 4: {
                typeString = TYPE_TIME;
                break;
            }
            case 2: {
                typeString = TYPE_FILE;
                break;
            }
            default: {
                typeString = TYPE_STRING;
            }
        }
        return typeString;
    }
}

