/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.settingsmap.propertyio;

import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.FileVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;

public class VarTableOutput {
    public static VarTableModel writeToVarTableModel(SettingsMap propertyMap) {
        VarTableModel result = new VarTableModel();
        for (String key : propertyMap.getParametersKeySet()) {
            Parameter property = propertyMap.getParameter(key);
            BaseVariable tVariable = null;
            switch (property.getType()) {
                case 2: {
                    tVariable = new FileVariable(key, property.getValue());
                    break;
                }
                case 0: {
                    tVariable = new IntegerVariable(key, property.getValue());
                    break;
                }
                case 3: {
                    tVariable = new BoolVariable(key, Boolean.parseBoolean(property.getValue()));
                    break;
                }
                case 4: {
                    tVariable = new DateAndTimeVariable(key, DateAndTimeVariable.Content.DATE_TIME, property.getValue());
                    break;
                }
                default: {
                    tVariable = new StringVariable(key, property.getValue());
                }
            }
            ((Variable)tVariable).setAllowEdit(!property.isLocked());
            result.addRow(tVariable);
        }
        return result;
    }
}

