/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.sender;

import com.ericsson.ere.io.IOUtil;
import ericsson.ere.integration.log.DefaultLog;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.sender.ServerSender;
import ericsson.ere.xml.XMLUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTTPServerSender
implements ServerSender {
    private static final String DEFAULT_CFG_FILE = "XMLRequestSender.cfg";
    private static final String TAG_HOST_NAME = "DestinationHost";
    private static final String TAG_HOST_PORT = "Port";
    private static final String TAG_LOG_DIRECTORY = "LogDirectory";
    private static final String TAG_LOG_FILE = "LogFileName";
    private static final String TAG_LOG_LEVEL = "LogLevel";
    private static final String TAG_LOGIN_REQUEST = "XMLLogin";
    private static final String TAG_LOGOUT_REQUEST = "XMLLogout";
    private static final String TAG_POST = "POST";
    private static final String TAG_VERSION = "HTTP/1.1";
    private static final String TAG_CONTENT_TYPE = "Content-Type: application/x-www-form-urlencoded";
    private static final String TAG_CONTENT_LENGTH = "Content-Length: ";
    private static final String EMPTY_ROW = "";
    private EreIntegrationLogInterface _log = null;
    private String myLogDirectory = null;
    private String myLogFile = null;
    private Socket mySocket = null;
    private BufferedReader in = null;
    private PrintWriter out = null;
    private String myHost = "";
    private int myPort = 0;
    private String mySessionId = null;
    private NodeList myConfig = null;
    private String myLoginRequest = "";
    private String myRequestURI = "/NewRequest/";
    private String myLogoutRequest = "";

    public HTTPServerSender() {
    }

    public HTTPServerSender(Document config) throws Exception {
        this.init(config.getDocumentElement().getChildNodes());
    }

    @Override
    public void init(NodeList config) throws Exception {
        this.myConfig = config;
        this.setHost(this.getConfigString(TAG_HOST_NAME));
        this.setPort(this.getConfigString(TAG_HOST_PORT));
        this.setLogDirectory(this.getConfigString(TAG_LOG_DIRECTORY));
        this.setLogFile(this.getConfigString(TAG_LOG_FILE));
        this.setLoginRequest(XMLUtil.getNamedElement(TAG_LOGIN_REQUEST, this.myConfig));
        this.setLogoutRequest(XMLUtil.getNamedElement(TAG_LOGOUT_REQUEST, this.myConfig));
        this.init();
        this.setLogLevel(this.getConfigString(TAG_LOG_LEVEL));
    }

    public void setLoginRequest(Node loginSettings) {
        Element loginRequest = XMLUtil.getNamedElement("Request", loginSettings.getChildNodes());
        this.myLoginRequest = loginRequest.toString();
    }

    private boolean useLogg() {
        return this._log != null;
    }

    public void setLoginRequest(String loginRequest) {
        this.myLoginRequest = loginRequest;
    }

    public void setLogoutRequest(Node logoutSettings) {
        Element logoutRequest = XMLUtil.getNamedElement("Request", logoutSettings.getChildNodes());
        this.myLogoutRequest = logoutRequest.toString();
    }

    public void setLogoutRequest(String logoutRequest) {
        this.myLogoutRequest = logoutRequest;
    }

    @Override
    public void setSessionId(String sessionId) {
        this.mySessionId = sessionId;
    }

    public String getSessionId(String sessionId) {
        return this.mySessionId;
    }

    private String getConfigString(String tagName) {
        String retStr = null;
        Element namedElement = XMLUtil.getNamedElement(tagName, this.myConfig);
        if (namedElement != null) {
            retStr = XMLUtil.getFirstTextContent(namedElement);
        }
        return retStr;
    }

    public void setHost(String host) throws Exception {
        if (host == null) {
            throw new Exception("ERROR: <DestinationHost> tag or value missing for HTTPServerSender");
        }
        this.myHost = host;
    }

    public void setPort(String port) throws Exception {
        if (port == null) {
            throw new Exception("ERROR: <Port> name missing for HTTPServerSender");
        }
        try {
            this.myPort = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new Exception("Port (" + port + ") value is not an int value");
        }
    }

    public void setLogDirectory(String directory) {
        if (directory != null) {
            this.myLogDirectory = directory;
        }
    }

    public void setLogFile(String logFile) {
        if (logFile != null) {
            this.myLogFile = logFile;
        }
    }

    public void setLogLevel(String level) {
        block4: {
            if (level != null) {
                try {
                    int myLogLevel = Integer.parseInt(level);
                    if (this.useLogg()) {
                        this._log.setLevel(myLogLevel);
                    }
                }
                catch (NumberFormatException nfe) {
                    int myLogLevel = Integer.MAX_VALUE;
                    if (!this.useLogg() || !this._log.isLevel(1)) break block4;
                    this._log.print(1, "Invalid argument for setLogLevel(" + level + ") ");
                }
            }
        }
    }

    public void setLogLevel(int level) {
        if (this.useLogg()) {
            this._log.setLevel(level);
        }
    }

    public void init() {
        try {
            this._log = new DefaultLog(this.myLogDirectory, this.myLogFile);
        }
        catch (Throwable x) {
            x.printStackTrace();
        }
    }

    @Override
    public void connect() {
        block4: {
            try {
                this.send(this.myLoginRequest);
                String loginResponse = this.getResponse();
                int firstPos = loginResponse.indexOf("<SessionId>");
                int lastPos = loginResponse.indexOf("</", firstPos);
                if (firstPos > -1) {
                    this.mySessionId = loginResponse.substring(firstPos + "<SessionId>".length(), lastPos);
                    return;
                }
                firstPos = loginResponse.indexOf("SessionId=\"");
                lastPos = loginResponse.indexOf("\">", firstPos);
                if (firstPos > -1) {
                    this.mySessionId = loginResponse.substring(firstPos + "SessionId=\"".length(), lastPos);
                    return;
                }
                this.mySessionId = "NOT connected";
            }
            catch (Exception e) {
                if (!this.useLogg() || !this._log.isLevel(1)) break block4;
                this._log.print(1, "Could not connect to " + this.myHost + ":" + this.myPort + " reason :\n" + e.getMessage());
            }
        }
    }

    public String getSessionId() {
        return this.mySessionId;
    }

    @Override
    public void disconnect() throws Exception {
        this.send(this.myLogoutRequest);
        this.getResponse();
    }

    @Override
    public void send(String theRequest) throws Exception {
        StringBuffer headerLines = new StringBuffer();
        try {
            this.mySocket = new Socket(this.myHost, this.myPort);
            this.out = new PrintWriter((Writer)new OutputStreamWriter(this.mySocket.getOutputStream()), true);
            if (this.useLogg() && this._log.isLevel(4)) {
                this._log.print(4, "IN  : \n" + theRequest);
            }
            String theRequestString = theRequest.replaceFirst("SessionId=\\\"*.\\\"", "SessionId=\"" + this.mySessionId + "\"");
            if (this.useLogg() && this._log.isLevel(4)) {
                this._log.print(4, "OUT  : \n" + theRequestString);
            }
            if (this.useLogg() && this._log.isLevel(4)) {
                headerLines.append("POST " + this.myRequestURI + " " + TAG_VERSION + "\r\n");
                headerLines.append("Content-Type: application/x-www-form-urlencoded\r\n");
                headerLines.append("User-Agent: Request Sender\r\n");
                headerLines.append("SOAPAction: \"ReserveAmountCharging#reserveAmount\"\r\n");
                headerLines.append("Host: " + this.myHost + ":" + this.mySocket.getPort() + "\r\n");
                headerLines.append(TAG_CONTENT_LENGTH + theRequestString.length() + "\r\n");
                headerLines.append("Connection: Keep-Alive\r\n");
                headerLines.append("Cache-Control: no-cache\r\n");
                headerLines.append("\r\n");
                headerLines.append(theRequestString);
                this._log.print(4, "Sending request : \n" + headerLines);
            }
            this.out.print("POST " + this.myRequestURI + " " + TAG_VERSION + "\r\n");
            this.out.print("Content-Type: application/x-www-form-urlencoded\r\n");
            this.out.print("User-Agent: Request Sender\r\n");
            this.out.print("SOAPAction: \"ReserveAmountCharging#reserveAmount\"\r\n");
            this.out.print("Host: " + this.myHost + ":" + this.mySocket.getPort() + "\r\n");
            this.out.print(TAG_CONTENT_LENGTH + theRequestString.length() + "\r\n");
            this.out.print("Connection: Keep-Alive\r\n");
            this.out.print("Cache-Control: no-cache\r\n");
            this.out.print("\r\n");
            this.out.print(theRequestString);
            this.out.flush();
            if (this.useLogg() && this._log.isLevel(4)) {
                this._log.print(4, "Request : \n" + theRequestString);
            }
        }
        catch (Exception e) {
            String errTxt = "Exception caught in HTTPServerSender.send(String theRequest): \n" + e.getMessage();
            if (this.useLogg() && this._log.isLevel(1)) {
                this._log.print(1, errTxt);
            }
            throw new Exception(errTxt);
        }
    }

    @Override
    public String getResponse() throws Exception {
        String myResponse = null;
        String tmpStr = EMPTY_ROW;
        StringBuffer tmpRespStr = new StringBuffer();
        StringBuffer contentSize = new StringBuffer();
        int size = 0;
        try {
            this.in = new BufferedReader(new InputStreamReader(this.mySocket.getInputStream()));
            while ((tmpStr = this.in.readLine()) != null && tmpStr.length() != 0) {
                if (this.useLogg() && this._log.isLevel(4)) {
                    this._log.print(4, "RESPONSE [NOT USED] |  " + tmpStr);
                }
                if (tmpStr.toLowerCase().indexOf("length") <= -1) continue;
                contentSize.append(tmpStr);
            }
            if (contentSize.length() > 0) {
                StringTokenizer token = new StringTokenizer(contentSize.toString(), ":");
                token.nextToken();
                size = Integer.parseInt(token.nextToken().trim());
                if (this.useLogg() && this._log.isLevel(4)) {
                    this._log.print(4, "Message size is : " + size);
                }
            }
            if (size <= 0) {
                if (this.useLogg() && this._log.isLevel(4)) {
                    this._log.print(4, "No size will read until an empty row");
                }
                while ((tmpStr = this.in.readLine()) != null && tmpStr.length() != 0) {
                    tmpRespStr.append(tmpStr + "\n");
                }
            } else {
                int ii = 0;
                do {
                    int c = this.in.read();
                    tmpRespStr.append((char)c);
                } while (++ii <= size - 1);
            }
            if (this.useLogg() && this._log.isLevel(4)) {
                this._log.print(4, "RESPONSE READ  \n" + tmpRespStr);
            }
            myResponse = tmpRespStr.toString();
            if (this.useLogg() && this._log.isLevel(4)) {
                this._log.print(4, "Response:\n" + myResponse);
            }
        }
        catch (Exception e) {
            String errTxt = "HTTPServerSender.getResponse(): " + e.getMessage();
            if (this.useLogg() && this._log.isLevel(4)) {
                this._log.print(1, errTxt);
            }
            throw new Exception(errTxt);
        }
        return myResponse;
    }

    public static void main_(String[] argv) {
        String _cfgFile = DEFAULT_CFG_FILE;
        try {
            if (argv.length == 1) {
                _cfgFile = argv[0];
            } else {
                System.err.println("Using default cfg file " + _cfgFile);
            }
        }
        catch (Exception e) {
            System.err.println("Error when reading arguments... " + e.toString());
            System.exit(1);
        }
        try {
            File cfgFile = new File(_cfgFile);
            System.out.println(cfgFile.getAbsolutePath());
            HTTPServerSender httpServerSender = new HTTPServerSender(XMLUtil.buildDocumentFromFile(cfgFile));
            File file = new File("one_rate_mms.xml");
            StringBuffer rateTest = new StringBuffer();
            IOUtil.readAllAndClose(new FileReader(file), rateTest);
            httpServerSender.connect();
            int numberOfTest = 1000;
            long start = System.currentTimeMillis();
            for (int ii = 0; ii < numberOfTest; ++ii) {
                httpServerSender.send(rateTest.toString());
                if (ii == 0) {
                    System.out.println(httpServerSender.getResponse());
                    continue;
                }
                httpServerSender.getResponse();
            }
            long stop = System.currentTimeMillis();
            double seconds = (double)(stop - start) / 1000.0;
            double reqPerSec = (double)numberOfTest / seconds;
            System.out.println("req/sec : " + reqPerSec);
            httpServerSender.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

