/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver.transport;

import com.ericsson.ere.util.HttpCommunicator;
import com.ericsson.ere.util.PasswordHelper;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.Loggable;
import ericsson.ere.integration.receiver.requesthandler.RequestHandlerInterface;
import ericsson.ere.integration.receiver.requesthandler.RequestHandlerInterfaceEx;
import ericsson.ere.integration.receiver.transport.SocketTransportInterface;
import ericsson.ere.integration.util.ObjectRepository;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HttpTransport
implements SocketTransportInterface,
Configurable,
Loggable {
    Socket mySocket;
    EreIntegrationLogInterface myLog;
    RequestHandlerInterface myRequestHandler;
    private String myCharset;

    public HttpTransport() {
    }

    public HttpTransport(Socket socket, EreIntegrationLogInterface log, RequestHandlerInterface requestHandler) {
        this(socket, log, requestHandler, null);
    }

    public HttpTransport(Socket socket, EreIntegrationLogInterface log, RequestHandlerInterface requestHandler, String charset) {
        this.mySocket = socket;
        this.myLog = log;
        this.myRequestHandler = requestHandler;
        this.myCharset = charset;
    }

    @Deprecated
    protected HttpTransport(Socket socket) {
        this(socket, null, null);
    }

    @Override
    public SocketTransportInterface getSocketTransportObject(Socket socket) {
        HttpTransport httpTransport = new HttpTransport(socket, this.myLog, this.myRequestHandler, this.myCharset);
        return httpTransport;
    }

    private boolean hasLoggerAtLevel(int level) {
        return this.myLog != null && this.myLog.isLevel(level);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try (HttpCommunicator serverCommunicator = null;){
            String method;
            serverCommunicator = new HttpCommunicator.HttpServerCommunicator(this.mySocket, this.myCharset);
            String request = ((HttpCommunicator.HttpServerCommunicator)serverCommunicator).readRequest();
            Map<String, String> headers = ((HttpCommunicator.HttpServerCommunicator)serverCommunicator).getLatestHeaders();
            String string = method = headers.containsKey("http_method") ? headers.get("http_method") : "";
            if ("POST".equals(method)) {
                this.processPostRequest((HttpCommunicator.HttpServerCommunicator)serverCommunicator, request);
            } else {
                if (this.hasLoggerAtLevel(4)) {
                    this.myLog.print(4, "Unsupported HTTP method: " + method);
                }
                this.notImplementedResponse((HttpCommunicator.HttpServerCommunicator)serverCommunicator);
            }
        }
    }

    private void processPostRequest(HttpCommunicator.HttpServerCommunicator comm, String request) throws Exception {
        StringBuffer writerBuffer = null;
        if (this.hasLoggerAtLevel(4)) {
            this.myLog.print(4, "Received command:\n" + PasswordHelper.replacePwdWithWildcardIfPresent(request));
        }
        String command = request.replaceAll("<\\?.*\\?>", "");
        String response = this.myRequestHandler instanceof RequestHandlerInterfaceEx ? ((RequestHandlerInterfaceEx)this.myRequestHandler).handleRequest(command) : new String(this.myRequestHandler.handleRequest(command.getBytes()));
        if (this.hasLoggerAtLevel(4)) {
            writerBuffer = new StringBuffer();
        }
        comm.sendResponse(writerBuffer, 200, "text/xml", response);
        if (writerBuffer != null) {
            this.myLog.print(4, "Response:\n" + writerBuffer.toString());
        }
        if (this.hasLoggerAtLevel(3) && !this.hasLoggerAtLevel(4)) {
            this.myLog.print(3, "Request:\n" + PasswordHelper.replacePwdWithWildcardIfPresent(command) + "\n\nResponse:\n" + response);
        }
    }

    private void notImplementedResponse(HttpCommunicator.HttpServerCommunicator comm) throws IOException {
        if (this.hasLoggerAtLevel(4)) {
            this.myLog.print(4, "Sending 'Not Implementented' response.");
        }
        String response = "<HTML>\n<HEAD><TITLE>Not Implemented</TITLE>\n</HEAD>\n<BODY>\n<H1>HTTP Error 501: Not Implemented</H1>\n</BODY></HTML>";
        comm.sendResponse(501, "text/html", response);
    }

    @Override
    public void setLogg(EreIntegrationLogInterface logImpl) {
        this.myLog = logImpl;
    }

    @Override
    public void init(Element root) throws ConfigurationException {
        NodeList list = root.getChildNodes();
        for (int ii = 0; ii < list.getLength(); ++ii) {
            if (list.item(ii).getNodeType() != 1 || !list.item(ii).getNodeName().equals("Argument")) continue;
            this.readArgumentElement((Element)list.item(ii));
        }
    }

    private void readArgumentElement(Element element) throws ConfigurationException {
        if (element.getAttribute("Name").equals("RequestHandler")) {
            this.instantiateRequestHandler(element);
        }
    }

    private void instantiateRequestHandler(Element element) throws ConfigurationException {
        try {
            Object obj = ObjectRepository.getInstance().getObject(element);
            if (!(obj instanceof RequestHandlerInterface)) {
                throw new Exception("Must implement RequestHandlerInterface.");
            }
            this.myRequestHandler = (RequestHandlerInterface)obj;
        }
        catch (Exception e) {
            throw new ConfigurationException("Error instantiating the request handler: " + e.getMessage(), e);
        }
    }
}

