/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver.session;

import com.ericsson.ere.util.HashUtil;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.receiver.session.Session;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SessionHandler
implements Configurable {
    private static SessionHandler INSTANCE;
    private Map<String, Session> mySessions;
    private Map<String, String> myUsers;
    private int mySleepTime = 120000;
    private int mySessionTime = 360000;
    private static final String INTERNAL_NODE = "internal";
    ScheduledThreadPoolExecutor myDaemon = new ScheduledThreadPoolExecutor(10);
    Object mySessionMonitorId = null;
    private EreIntegrationLogInterface myLog = null;

    @Deprecated
    public SessionHandler() throws Exception {
        this(0);
        this.startSessionMonitor();
    }

    private SessionHandler(int dummy) {
        this.mySessions = new Hashtable<String, Session>();
        this.myUsers = new Hashtable<String, String>();
    }

    public static SessionHandler createWithoutStartingMonitor() {
        return new SessionHandler(0);
    }

    private boolean useLogg() {
        return this.myLog != null;
    }

    public void setLogImpl(EreIntegrationLogInterface logImpl) {
        this.myLog = logImpl;
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "SessionHandler will use this log ");
        }
    }

    public void shutDown() {
        this.stopSessionMonitor();
        this.myDaemon.shutdown();
        this.removeAllUsers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllSessions() {
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "Removing all sessions ");
        }
        Map<String, Session> map = this.mySessions;
        synchronized (map) {
            Iterator<String> iterator = this.mySessions.keySet().iterator();
            while (iterator.hasNext()) {
                String session = iterator.next();
                iterator.remove();
                if (!this.useLogg() || !this.myLog.isLevel(4)) continue;
                this.myLog.print(4, "Session = '" + session + "' removed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAllUsers() {
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "Removing all users ");
        }
        Map<String, String> map = this.myUsers;
        synchronized (map) {
            Iterator<String> iterator = this.myUsers.keySet().iterator();
            while (iterator.hasNext()) {
                String user = iterator.next();
                iterator.remove();
                if (!this.useLogg() || !this.myLog.isLevel(4)) continue;
                this.myLog.print(4, "User '" + user + "' removed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUser(String user) {
        Map<String, String> map = this.myUsers;
        synchronized (map) {
            this.myUsers.remove(user);
            if (this.useLogg() && this.myLog.isLevel(3)) {
                this.myLog.print(3, "User = '" + user + "' removed.");
            }
        }
    }

    @Deprecated
    public static SessionHandler getInstance() throws Exception {
        if (INSTANCE == null) {
            INSTANCE = new SessionHandler();
        }
        return INSTANCE;
    }

    public void setSleepTime(int time) {
        this.mySleepTime = time * 1000;
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "sleep time set to " + this.mySleepTime);
        }
    }

    public int getSleepTime() {
        return this.mySleepTime;
    }

    public void setSessionTime(int time) {
        this.mySessionTime = time * 1000;
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "session time  set to " + this.mySessionTime + "ms");
        }
    }

    public int getSessionTime() {
        return this.mySessionTime;
    }

    public synchronized void addUser(String[][] usersArray) throws Exception {
        if (usersArray != null && usersArray.length > 0 && usersArray[0].length > 1) {
            for (int ii = 0; ii < usersArray.length; ++ii) {
                this.addUser(usersArray[ii][0], usersArray[ii][1]);
            }
        } else {
            throw new Exception("Users array not valid ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUser(String user, String pwd) throws Exception {
        if (user == null || pwd == null) {
            String msg = "Not allowed to have user or password equal to null.";
            if (this.useLogg() && this.myLog.isLevel(1)) {
                this.myLog.print(1, msg);
            }
            throw new Exception(msg);
        }
        if (this.myUsers.containsKey(user)) {
            if (this.useLogg() && this.myLog.isLevel(2)) {
                this.myLog.print(2, "User '" + user + "' already exists.");
            }
            return;
        }
        Map<String, String> map = this.myUsers;
        synchronized (map) {
            this.myUsers.put(user, pwd);
            if (this.useLogg() && this.myLog.isLevel(3)) {
                this.myLog.print(3, "User '" + user + "' has been added.");
            }
        }
    }

    public Session getSession(String sessionId) throws Exception {
        Session obj = this.mySessions.get(sessionId);
        if (obj == null) {
            String msg = "Session '" + sessionId + "' does not exist.";
            if (this.useLogg() && this.myLog.isLevel(3)) {
                this.myLog.print(3, msg);
            }
            throw new Exception(msg);
        }
        return obj;
    }

    public Iterator<String> getSessions() {
        return this.mySessions.keySet().iterator();
    }

    public String createSession(String user, String pwd) throws Exception {
        return this.createSession(user, pwd, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSession(String user, String pwd, String node) throws Exception {
        if (this.isUserAuthorized(user, pwd, node)) {
            Session session = new Session(user, this.mySessionTime);
            Map<String, Session> map = this.mySessions;
            synchronized (map) {
                this.mySessions.put(session.getSessionId(), session);
            }
            return session.getSessionId();
        }
        String msg = "Incorrect user name or password.";
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, msg);
        }
        throw new Exception(msg);
    }

    public void checkSession(String sessionId) throws Exception {
        Session session = this.mySessions.get(sessionId);
        if (session == null) {
            String msg = "Session '" + sessionId + "' was not found (may have timed out).";
            if (this.useLogg() && this.myLog.isLevel(3)) {
                this.myLog.print(3, msg);
            }
            throw new Exception(msg);
        }
        if (session.getEndTime() < System.currentTimeMillis()) {
            String msg = "Session '" + sessionId + "' is no longer.";
            if (this.useLogg() && this.myLog.isLevel(3)) {
                this.myLog.print(3, msg);
            }
            throw new Exception(msg);
        }
        session.setEndTime(this.mySessionTime);
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "Session '" + sessionId + "' for '" + session.getUser() + "' accepted, session endtime prolonged with " + this.mySessionTime + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSession(String sessionId) {
        Map<String, Session> map = this.mySessions;
        synchronized (map) {
            this.mySessions.remove(sessionId);
        }
        if (this.useLogg() && this.myLog.isLevel(4)) {
            this.myLog.print(4, "Session '" + sessionId + "' has been removed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scanSessions() throws Exception {
        Map<String, Session> map = this.mySessions;
        synchronized (map) {
            Iterator<String> sessions = this.mySessions.keySet().iterator();
            while (sessions.hasNext()) {
                String currentSessionId = sessions.next();
                if (System.currentTimeMillis() <= this.getSession(currentSessionId).getEndTime()) continue;
                sessions.remove();
            }
        }
    }

    public void stopSessionMonitor() {
        if (this.mySessionMonitorId != null) {
            this.myDaemon.shutdownNow();
            this.mySessionMonitorId = null;
        }
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "Session Monitor stopped");
        }
        this.removeAllSessions();
    }

    public void startSessionMonitor() {
        if (this.mySessionMonitorId != null) {
            this.stopSessionMonitor();
        }
        this.mySessionMonitorId = this.myDaemon.scheduleWithFixedDelay(new SessionMonitor(), this.mySleepTime, this.mySleepTime, TimeUnit.MILLISECONDS);
        if (this.useLogg() && this.myLog.isLevel(3)) {
            this.myLog.print(3, "Session Monitor started");
        }
    }

    @Override
    public void init(Element root) {
        NodeList list = root.getChildNodes();
        for (int ii = 0; ii < list.getLength(); ++ii) {
            if (list.item(ii).getNodeType() != 1 || !list.item(ii).getNodeName().equals("User")) continue;
            try {
                this.addUser((Element)list.item(ii));
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void addUser(Element element) throws Exception {
        String name = null;
        String pwd = null;
        name = element.getAttribute("Name");
        pwd = element.getAttribute("Password");
        if (name != null && pwd != null) {
            this.addUser(name, pwd);
        }
    }

    private boolean isUserAuthorized(String user, String pwd, String node) {
        String storedPassword = this.myUsers.get(user);
        if (Objects.isNull(storedPassword) || Objects.isNull(pwd)) {
            return false;
        }
        if (Objects.isNull(node) || !node.equals(INTERNAL_NODE)) {
            return HashUtil.verify(pwd.toCharArray(), storedPassword);
        }
        return storedPassword.equals(pwd);
    }

    class SessionMonitor
    implements Runnable {
        SessionMonitor() {
        }

        @Override
        public void run() {
            block2: {
                try {
                    SessionHandler.this.scanSessions();
                }
                catch (Exception e) {
                    if (!SessionHandler.this.useLogg() || !SessionHandler.this.myLog.isLevel(3)) break block2;
                    SessionHandler.this.myLog.print(3, "An error occurred when scanning sessions: " + e.getMessage());
                }
            }
        }
    }
}

