/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver.session;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;

public class Session {
    private static int mySessionIdLength = 10;
    private String myUser;
    private String mySessionId;
    private long myEndTime;
    private static Random[] randoms = new Random[mySessionIdLength];

    private static byte[] getSeed(long seed) {
        try {
            ByteArrayOutputStream out0 = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(out0);
            out.writeLong(seed);
            return out0.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Session(String user, long timeToLive) {
        this.myUser = user;
        this.mySessionId = Session.generateSessionId();
        this.setEndTime(timeToLive);
    }

    public void setEndTime(long timeToLive) {
        this.myEndTime = System.currentTimeMillis() + timeToLive;
    }

    public long getEndTime() {
        return this.myEndTime;
    }

    public String getSessionId() {
        return this.mySessionId;
    }

    public String getUser() {
        return this.myUser;
    }

    private static String generateSessionId() {
        StringBuffer buf = new StringBuffer(mySessionIdLength);
        for (int i = 0; i < mySessionIdLength; ++i) {
            buf.append(String.valueOf((int)(randoms[i].nextFloat() * 10.0f)));
        }
        return buf.toString();
    }

    static {
        long seed = System.currentTimeMillis();
        for (int i = 0; i < mySessionIdLength; ++i) {
            SecureRandom random = new SecureRandom();
            try {
                random = SecureRandom.getInstance("SHA1PRNG", "SUN");
            }
            catch (Exception exception) {
                // empty catch block
            }
            random.setSeed(Session.getSeed(seed + (long)i));
            Session.randoms[i] = random;
        }
    }
}

