/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver.requesthandler;

import ericsson.ere.integration.config.ArgumentHandler;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.Loggable;
import ericsson.ere.integration.management.RequestParser;
import ericsson.ere.integration.receiver.requesthandler.RequestHandlerInterfaceEx;
import ericsson.ere.integration.receiver.requesthandler.ResponseInterface;
import ericsson.ere.integration.util.ObjectRepository;
import ericsson.ere.xml.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import org.w3c.dom.Element;

public class XmlRequestHandler
implements RequestHandlerInterfaceEx,
Configurable,
Loggable {
    private static final String ARG_CHARSET = "CharacterSet";
    private static final String TAG_REQUESTPARSER = "EreRequestParser";
    RequestParser myParser;
    EreIntegrationLogInterface myLog;
    private String myCharset = null;

    public XmlRequestHandler() {
    }

    public XmlRequestHandler(RequestParser parser, EreIntegrationLogInterface logger2) {
        this(parser, logger2, null);
    }

    public XmlRequestHandler(RequestParser parser, EreIntegrationLogInterface logger2, String charset) {
        if (charset != null && !Charset.isSupported(charset)) {
            throw new IllegalArgumentException("Unsupported character set: " + charset);
        }
        this.myParser = parser;
        this.myLog = logger2;
        this.myCharset = charset;
    }

    @Override
    public String handleRequest(String request) {
        String response = "";
        try {
            Element node = XMLUtil.buildDocumentFromString(request).getDocumentElement();
            response = this.myParser.perform(node);
        }
        catch (Exception e) {
            if (this.hasLoggerAtLevel(1)) {
                this.myLog.print(1, "Request could not be handled, error is:\n" + e.getMessage());
            }
            response = "<Error>" + e.getMessage() + "</Error>\n";
        }
        return "<Response>\n" + response + "</Response>";
    }

    @Override
    public byte[] handleRequest(byte[] request) {
        try {
            String strRequest = this.myCharset != null ? new String(request, this.myCharset) : new String(request);
            String response = this.handleRequest(strRequest);
            return this.myCharset != null ? response.getBytes(this.myCharset) : response.getBytes();
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    @Override
    public void handleRequest(byte[] request, ResponseInterface callBackReference) {
        callBackReference.response(this.handleRequest(request));
    }

    @Override
    public void init(Element root) throws ConfigurationException {
        Element parser;
        ArgumentHandler handler = new ArgumentHandler(root);
        if (handler.hasArgument(ARG_CHARSET)) {
            String cs = handler.getArgumentAsString(ARG_CHARSET);
            if (!Charset.isSupported(cs)) {
                throw new ConfigurationException("Unsupported character set: " + cs);
            }
            this.myCharset = cs;
        }
        if ((parser = XMLUtil.getNamedElement(TAG_REQUESTPARSER, root.getChildNodes())) != null) {
            this.instantiateRequestParser(parser);
        }
    }

    private void instantiateRequestParser(Element element) {
        block5: {
            try {
                Object obj = ObjectRepository.getInstance().getObject(element);
                if (obj instanceof RequestParser) {
                    this.myParser = (RequestParser)obj;
                    this.myParser.init(element.getChildNodes());
                } else if (this.hasLoggerAtLevel(2)) {
                    this.myLog.print(2, "'RequestParser' expected for this RequestHandler (XmlRequestHandler)");
                }
            }
            catch (Exception e) {
                if (!this.hasLoggerAtLevel(1)) break block5;
                this.myLog.print(1, "Error instantiating a RequestParser for this RequestHandler (XmlRequestHandler); message : \n" + e.getMessage());
            }
        }
    }

    @Override
    public void setLogg(EreIntegrationLogInterface logImpl) {
        this.myLog = logImpl;
    }

    private boolean hasLoggerAtLevel(int level) {
        return this.myLog != null && this.myLog.isLevel(level);
    }
}

