/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver;

import com.ericsson.ere.io.IOCloser;
import ericsson.ere.EreLibLoader;
import ericsson.ere.EreManagerLoader;
import ericsson.ere.integration.log.DefaultLog;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.management.EreRequestTask;
import ericsson.ere.integration.receiver.Messenger;
import ericsson.ere.integration.receiver.session.SessionHandler;
import ericsson.ere.management.EreManager;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PoolHttpServer
implements Runnable {
    private Thread myRunner = null;
    private ServerSocket myServer;
    private ExecutorService myExecutor = null;
    private EreIntegrationLogInterface myLog = null;
    private SessionHandler mySessionHandler = SessionHandler.createWithoutStartingMonitor();
    private Node requestParserSettings = null;
    volatile boolean shouldStop = false;
    private EreManager myEreManager;

    public PoolHttpServer() throws IOException, Exception {
        this(new EreManager());
    }

    public PoolHttpServer(EreManager manager) throws IOException, Exception {
        this.myEreManager = manager;
    }

    public void setLogg(EreIntegrationLogInterface logImpl) {
        this.myLog = logImpl;
        if (this.mySessionHandler != null) {
            this.mySessionHandler.setLogImpl(this.myLog);
        }
    }

    public EreIntegrationLogInterface getLogg() {
        return this.myLog;
    }

    private boolean useLogg() {
        return this.myLog != null;
    }

    public SessionHandler getSessionHandler() {
        return this.mySessionHandler;
    }

    @Deprecated
    public void setEreManager(EreManager ereManager) {
        this.myEreManager = ereManager;
    }

    public void setSessionHandler(SessionHandler sessionHandler) {
        if (this.mySessionHandler != null) {
            this.mySessionHandler.shutDown();
        }
        this.mySessionHandler = sessionHandler;
        this.mySessionHandler.setLogImpl(this.myLog);
    }

    @Deprecated
    public synchronized void startServer(int port) throws IOException {
        if (this.myRunner == null) {
            this.mySessionHandler.startSessionMonitor();
            this.myExecutor = Executors.newCachedThreadPool(new PoolFactory());
            this.myRunner = new Thread(new Runner());
            this.myServer = new ServerSocket(port);
            this.myRunner.start();
            if (this.useLogg() && this.myLog.isLevel(4)) {
                this.myLog.print(4, "PoolHttpServer started on port " + port);
            }
        } else if (this.useLogg() && this.myLog.isLevel(2)) {
            this.myLog.print(2, "PoolHttpServer already started.");
        }
    }

    @Deprecated
    public synchronized void stopServer() {
        if (this.myServer != null) {
            this.shouldStop = true;
            this.myRunner.interrupt();
            this.myRunner = null;
            this.myExecutor.shutdownNow();
            try {
                this.myServer.close();
            }
            catch (IOException ioe) {
                this.myServer = null;
            }
            if (this.useLogg() && this.myLog.isLevel(4)) {
                this.myLog.print(4, "PoolHttpServer stopped ");
            }
        } else if (this.useLogg() && this.myLog.isLevel(2)) {
            this.myLog.print(2, "No PoolHttpServer to stop, already stopped");
        }
    }

    @Override
    @Deprecated
    public void run() {
        new Runner().run();
    }

    public void shutDown() {
        if (this.myRunner == null) {
            if (this.useLogg() && this.myLog.isLevel(2)) {
                this.myLog.print(2, "PoolHttpServer already shutdown.");
            }
            return;
        }
        this.mySessionHandler.shutDown();
        this.stopServer();
        if (this.useLogg() && this.myLog.isLevel(4)) {
            this.myLog.print(4, "PoolHttpServer shutdown");
        }
    }

    static void printUsageInfo() {
        System.out.println("poolHttp [-p portnumber] [-w working_directory] [-r rating_manager_file_name] [-ld logDirectory] [-lf logFile] [-l loglevel] [-u user,pwd] [-h]");
        System.out.println("");
        System.out.println("-p int value for the port number for the http server socket, default '9000'.");
        System.out.println("-w the directory where to find the rating manager file, current directory.");
        System.out.println("-r the filename for the rating manager file, default 'RatingManager.xml'");
        System.out.println("-ld log directory, default the current directory");
        System.out.println("-lf log file, default 'STDOUT', prints to screen, possible values STDOUT, STDERR, valid_fileName");
        System.out.println("-ll int value for log level default DEBUG(5) level");
        System.out.println("-c file path where to find the configuration for the request parser");
        System.out.println("-u hold the user and password to be added to the session handler.");
        System.out.println("\ta string with the following format username,password (note no space), more than one -u allowed");
        System.out.println("-h help information, this information");
    }

    public PoolHttpServer startServer(String[] args, ProgressIndicator progress, EreIntegrationLogInterface log) throws RuntimeException {
        int ii;
        int port = 9000;
        File file = new File(".");
        String workingDirectoryStr = file.getAbsolutePath();
        if (workingDirectoryStr.endsWith(".")) {
            workingDirectoryStr = workingDirectoryStr.substring(0, workingDirectoryStr.length() - 1);
        }
        String ratingManagerFileName = "RatingManager.xml";
        String[][] users = new String[][]{{"user", "wNBsmppR4w6NLBrAsMFr2eEYRkLA7I+z9qKrn8HKTxpUfVRJ5xqrzwBIfW/bGCRXPmBqk76xGuHLv63ttjRDS4aGuQuhR9jtXkC589GmtgtgTYsI57qic8RXM9ACusSvRLg9sfiPFtn2xY5BY16rH2rYsYzYnlaA8vWwazyc778=:k+d/uMrxSRqyuLFuoRKUlCXd8kqHWmjdxLMa2s/BXj1zvjRcOYy8j0A8QkWrGvNBqnBOFgll4TsiFUvdi/vNVA=="}, {"test", "zfGCo+umm5BMSU8synYednqyA4PJukxN6tVie+aNNSEPkZqZHrmllqbL8kLbf2KKgxfCYpeBh+PPfBAQG3fCT8vSs2tuBs1srxKk2Nh0VcBcIbOaTiGoN+EGw2hQv/7lksTwospRbC5MJvfwH7Q58SkXZ1RqZMxPdVyE+CAXJOE=:HVG8oniWo1PcQRMCCPxbFlM8jxbHo3iUxp3NPQNRYdXVSPzNvtB0NuuyDBeslQ4laMDbpat7feC+tYKw60AzAg=="}};
        String requestParserConfigFile = null;
        ArrayList<String> userList = new ArrayList<String>();
        int logLevel = 4;
        file = null;
        for (ii = 0; ii < args.length; ++ii) {
            if (args[ii].equalsIgnoreCase("-p")) {
                port = Integer.parseInt(args[++ii]);
                continue;
            }
            if (args[ii].equalsIgnoreCase("-w")) {
                if (!(file = new File(args[++ii])).exists()) {
                    throw new RuntimeException("Working dir '" + args[ii] + "' does not exist");
                }
                workingDirectoryStr = file.getAbsolutePath() + System.getProperty("file.separator");
                continue;
            }
            if (args[ii].equalsIgnoreCase("-r")) {
                ratingManagerFileName = args[++ii];
                continue;
            }
            if (args[ii].equalsIgnoreCase("-u")) {
                userList.add(args[++ii]);
                continue;
            }
            if (args[ii].equalsIgnoreCase("-c")) {
                requestParserConfigFile = args[++ii];
                continue;
            }
            if (args[ii].equalsIgnoreCase("-ll")) {
                logLevel = Integer.parseInt(args[++ii]);
                continue;
            }
            if (!args[ii].equalsIgnoreCase("-h")) continue;
            PoolHttpServer.printUsageInfo();
        }
        if (userList.size() > 0) {
            users = new String[userList.size()][2];
            for (ii = 0; ii < userList.size(); ++ii) {
                StringTokenizer token = new StringTokenizer((String)userList.get(ii), ",");
                if (token.countTokens() < 2) {
                    System.out.println("Invalid user information " + (String)userList.get(ii));
                    throw new RuntimeException("Invalid user information " + (String)userList.get(ii));
                }
                users[ii][0] = token.nextToken();
                users[ii][1] = token.nextToken();
            }
        }
        System.setProperty(EreLibLoader.KEY_WORKINGDIRECTORY, workingDirectoryStr);
        System.setProperty("RatingManagerFile", ratingManagerFileName);
        EreManagerLoader loader = new EreManagerLoader(this.myEreManager);
        Messenger messenger = new Messenger();
        PoolHttpServer server = null;
        log.setLevel(logLevel);
        messenger.setLogger(log);
        loader.setMessenger(messenger);
        try {
            loader.loadManagerFromXML(progress, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Could not start ERE " + e.getMessage());
            throw new RuntimeException("Could not start ERE: " + e.getMessage());
        }
        try {
            InputStream configStream;
            server = new PoolHttpServer(this.myEreManager);
            server.setLogg(log);
            if (requestParserConfigFile != null && (configStream = server.getClass().getResourceAsStream("/config/" + requestParserConfigFile)) != null) {
                Element configElement = XMLUtil.buildDocument(configStream).getDocumentElement();
                server.setRequestParserSettings(XMLUtil.getNamedElement("EreRequestParser", configElement.getChildNodes()));
            }
            try {
                server.getSessionHandler().addUser(users);
            }
            catch (Exception e) {
                log.print(2, "Could not add users to servers: " + e.getMessage());
            }
            server.startServer(port);
        }
        catch (Exception e) {
            if (log.getLevel() >= 1) {
                log.print(1, "Could not start Server due to : " + e.getMessage() + "\napplication is terminated");
            }
            throw new RuntimeException("Could not start ERE: " + e.getMessage(), e);
        }
        return server;
    }

    public PoolHttpServer startServer(String[] args, ProgressIndicator progress) throws RuntimeException {
        File file = new File(".");
        String logDir = file.getAbsolutePath();
        String logFile = "STDOUT";
        if (args.length > 0) {
            for (int ii = 0; ii < args.length; ++ii) {
                if (args[ii].equalsIgnoreCase("-ld")) {
                    logDir = args[++ii];
                    continue;
                }
                if (!args[ii].equalsIgnoreCase("-lf")) continue;
                logFile = args[++ii];
            }
        }
        DefaultLog log = logFile.equalsIgnoreCase("STDOUT") ? new DefaultLog(new PrintWriter(System.out, true)) : (logFile.equalsIgnoreCase("STDERR") ? new DefaultLog(new PrintWriter(System.err, true)) : new DefaultLog(logDir, logFile));
        return this.startServer(args, progress, log);
    }

    public EreManager getEreManager() {
        return this.myEreManager;
    }

    public void setRequestParserSettings(Node settings) {
        this.requestParserSettings = settings;
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            if (PoolHttpServer.this.myServer != null) {
                while (!PoolHttpServer.this.shouldStop) {
                    Socket request = null;
                    try {
                        request = PoolHttpServer.this.myServer.accept();
                        if (PoolHttpServer.this.useLogg() && PoolHttpServer.this.myLog.isLevel(4)) {
                            PoolHttpServer.this.myLog.print(4, "Connection from " + request.getInetAddress() + " received.");
                        }
                        EreRequestTask task = new EreRequestTask(request, PoolHttpServer.this.myEreManager, PoolHttpServer.this.mySessionHandler, PoolHttpServer.this.myLog);
                        task.init(PoolHttpServer.this.requestParserSettings);
                        PoolHttpServer.this.myExecutor.execute(task);
                    }
                    catch (IOException ioe) {
                        if (PoolHttpServer.this.shouldStop && PoolHttpServer.this.useLogg() && PoolHttpServer.this.myLog.isLevel(3)) {
                            PoolHttpServer.this.myLog.print(3, "PoolHttpServer shutting down:\n" + ioe.getMessage());
                            continue;
                        }
                        if (PoolHttpServer.this.shouldStop || !PoolHttpServer.this.useLogg() || !PoolHttpServer.this.myLog.isLevel(1)) continue;
                        PoolHttpServer.this.myLog.print(1, "I/O error in PoolHttpServer:\n" + ioe.getMessage());
                    }
                    catch (Exception e) {
                        if (PoolHttpServer.this.useLogg() && PoolHttpServer.this.myLog.isLevel(1)) {
                            PoolHttpServer.this.myLog.print(1, "An error occurred in PoolHttpServer:\n" + e.getMessage() + "\nClosing connection from " + request.getInetAddress() + ".");
                        }
                        IOCloser.closeIgnoringException(request);
                    }
                }
            }
        }
    }

    private static class PoolFactory
    implements ThreadFactory {
        final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private PoolFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultFactory.newThread(r);
            thread.setName("PoolHttpServer-" + thread.getName());
            return thread;
        }
    }
}

