/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.ratingperiod.action;

import com.ericsson.ere.util.ReadUntilDataCollector;
import com.ericsson.ere.util.ReadUntilParser;
import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.ratingperiod.action.RatingPeriodAction;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;

public class RatingPeriodGetPropertyAction
extends RatingPeriodAction
implements EreAction {
    @Override
    public String perform(NodeList config) throws Exception {
        String response = "";
        RatingPeriod ratingPeriod = null;
        Element propertyElement = XMLUtil.getNamedElement("Property", config);
        try {
            ratingPeriod = RatingPeriodAction.getRatingPeriod(config, this.getEreManager());
            if (ratingPeriod != null) {
                if (propertyElement == null) {
                    response = RatingPeriodGetPropertyAction.createErrorTag("Invalid request, properties to fetch not correctly defined.");
                } else {
                    String keyString = propertyElement.getAttribute("key");
                    String[] keys = StringUtil.splitSemiColonSeparatedString(keyString);
                    String[] properties = this.getEreManager().getPropertyContainer().getPropertyValues(keys).forPeriod(ratingPeriod.getServiceProviderName(), ratingPeriod.getRatingPlanId(), ratingPeriod.getName(), DateUtil.formatISODateTime(ratingPeriod.getStartTime(), false));
                    if (StringUtil.containsNullValue(properties)) {
                        properties = this.getPropertiesFromServerStructure(ratingPeriod, keys);
                    }
                    response = WorkingDirHelper.createPeriodPropertyResponseXML("    ", ratingPeriod, keys, properties);
                }
            }
        }
        catch (Exception e) {
            response = RatingPeriodGetPropertyAction.createErrorTag(e.getMessage());
        }
        return response;
    }

    private String[] getPropertiesFromServerStructure(RatingPeriod period, String[] keys) throws Exception {
        String[] properties = null;
        String fileName = period.getActiveFileName();
        String absoluteFilePath = WorkingDirHelper.checkFile(fileName);
        String configString = FileHandling.fileToStringBuffer(absoluteFilePath).toString();
        if (configString != null) {
            String name = period.getName();
            String serviceName = period.getServiceId();
            String startTimeISOString = DateUtil.formatISODateTime(period.getStartTime(), false);
            String modifiedDateString = DateUtil.formatISODateTime(period.getLastModified(), false);
            String versionString = "";
            String createdDateString = "";
            if (this.needsToFetchPropertiesFromFile(keys)) {
                String[] collectedProperties = this.collectPropertiesFromFile(configString);
                createdDateString = collectedProperties[0];
                versionString = collectedProperties[1];
            }
            properties = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                String key = keys[i];
                if ("RatingPeriod_Name_Property".equals(key)) {
                    properties[i] = name;
                    continue;
                }
                if ("RatingPeriod_FileName_Property".equals(key)) {
                    properties[i] = fileName;
                    continue;
                }
                if ("RatingPeriod_CreatedDate_Property".equals(key)) {
                    properties[i] = createdDateString;
                    continue;
                }
                if ("RatingPeriod_ModifiedDate_Property".equals(key)) {
                    properties[i] = modifiedDateString;
                    continue;
                }
                if ("RatingPeriod_StartTime_Property".equals(key)) {
                    properties[i] = startTimeISOString;
                    continue;
                }
                if ("RatingPeriod_Service_Property".equals(key)) {
                    properties[i] = serviceName;
                    continue;
                }
                if (!"RatingPeriod_Version_Property".equals(key)) continue;
                properties[i] = versionString;
            }
            this.setPropertiesInContainer(keys, properties, serviceName, period.getServiceProviderName(), period.getRatingPlanId(), name, startTimeISOString);
        }
        return properties;
    }

    private boolean needsToFetchPropertiesFromFile(String[] keys) {
        boolean propertyRequiresFileRead = false;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!"RatingPeriod_CreatedDate_Property".equals(key) && !"RatingPeriod_Version_Property".equals(key)) continue;
            propertyRequiresFileRead = true;
            break;
        }
        return propertyRequiresFileRead;
    }

    private void setPropertiesInContainer(String[] keys, String[] values, String serviceName, String providerName, String planName, String periodName, String startTimeInISO) {
        this.getEreManager().getPropertyContainer().setPropertyValues(keys, values).forPeriod(providerName, planName, periodName, startTimeInISO);
    }

    private String[] collectPropertiesFromFile(String config) {
        String[] propertiesToCollect = new String[2];
        PeriodDataCollector collector = new PeriodDataCollector();
        try {
            ReadUntilParser parser = new ReadUntilParser(collector);
            parser.parseString(config);
        }
        catch (Exception exception) {
            // empty catch block
        }
        propertiesToCollect[0] = collector.getCreatedDate();
        propertiesToCollect[1] = collector.getVersion();
        return propertiesToCollect;
    }

    class PeriodDataCollector
    implements ReadUntilDataCollector {
        private String myElementNameToCollect = "Version";
        private String myVersion = null;
        private String myCreatedDate = null;
        private boolean myShouldStop = false;

        PeriodDataCollector() {
        }

        @Override
        public boolean shouldCollectElement(String qName) {
            if ("Node".equals(qName)) {
                this.myShouldStop = true;
            }
            return this.myElementNameToCollect.equals(qName);
        }

        @Override
        public boolean shouldStopReading() {
            return this.myShouldStop;
        }

        @Override
        public void collectAttributes(String qName, Attributes attributes) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attrName = attributes.getQName(i);
                if ("version".equals(attrName)) {
                    this.myVersion = attributes.getValue(i);
                    continue;
                }
                if (!"created".equals(attrName)) continue;
                this.myCreatedDate = attributes.getValue(i);
            }
            if (this.myVersion != null && this.myCreatedDate != null) {
                this.myShouldStop = true;
            }
        }

        String getVersion() {
            return this.myVersion != null ? this.myVersion : "";
        }

        String getCreatedDate() {
            return this.myCreatedDate != null ? this.myCreatedDate : "";
        }

        @Override
        public void collectElementTextValue(String qName, String elementValue) {
        }
    }
}

