/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.ratingperiod.action;

import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.FileVersionHandler;
import ericsson.ere.integration.management.ratingplan.action.RatingPlanAction;
import ericsson.ere.integration.management.serviceprovider.action.ServiceProviderAction;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.xml.XMLUtil;
import java.util.Calendar;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RatingPeriodAction
extends AbstractAction {
    public static final String ATTR_VERSION = "version";
    public static final String ATTR_MODIFIED = "modified";

    static String createRatingPeriod(ServiceProvider serviceProvider, RatingPlan ratingPlan, Node ratingPeriodNode) throws Exception {
        String ratingPeriodName = RatingPeriodAction.getRatingPeriodName(ratingPeriodNode);
        String startDateStr = RatingPeriodAction.getStartDate(ratingPeriodNode);
        Calendar startTimeCalendar = DateUtil.stringToCalendar(startDateStr);
        for (RatingPeriod currentRatingPeriod : ratingPlan.getAllRatingPeriods()) {
            if (currentRatingPeriod.getStartTime().getTimeInMillis() != startTimeCalendar.getTime().getTime()) continue;
            throw new Exception("RatingPeriod '" + currentRatingPeriod.getName() + "' with the same start date already exist " + DataType.TIME.makeDisplayString(new Time(startTimeCalendar)));
        }
        String ratingStructureFileName = RatingPeriodAction.createRatingStructureFile(ratingPlan, ratingPeriodNode, true);
        RatingPeriod ratingPeriod = new RatingPeriod(ratingPeriodName, ratingPlan, ratingPlan.getService().getId(), serviceProvider.getName(), ratingStructureFileName, "revision", startTimeCalendar, startTimeCalendar);
        ratingPeriod.startStructure();
        ratingPeriod.replan(startTimeCalendar, startTimeCalendar);
        return WorkingDirHelper.createRatingPeriodXML("", ratingPeriod, false);
    }

    static RatingPeriod getRatingPeriod(ServiceProvider serviceProvider, RatingPlan ratingPlan, Node ratingPeriodNode) throws Exception {
        String startDateAndTime;
        String ratingPeriodName = RatingPeriodAction.getRatingPeriodName(ratingPeriodNode);
        RatingPeriod ratingPeriod = ratingPlan.getRatingPeriod(ratingPeriodName, startDateAndTime = RatingPeriodAction.getStartDate(ratingPeriodNode));
        if (ratingPeriod == null) {
            throw new Exception("RatingPeriod '" + ratingPeriod + "' does NOT exists for '" + ratingPlan.getName() + "' for '" + serviceProvider.getName() + "'");
        }
        return ratingPeriod;
    }

    static void deleteRatingPeriod(ServiceProvider serviceProvider, RatingPlan ratingPlan, Node ratingPeriodNode) throws Exception {
        RatingPeriod ratingPeriod = RatingPeriodAction.getRatingPeriod(serviceProvider, ratingPlan, ratingPeriodNode);
        ratingPlan.removeRatingPeriod(ratingPeriod.getName(), ratingPeriod.getStartTime());
    }

    static String setRatingPeriod(ServiceProvider serviceProvider, RatingPlan ratingPlan, Node ratingPeriodNode) throws Exception {
        boolean completeRequest = true;
        RatingPeriod ratingPeriod = RatingPeriodAction.getRatingPeriod(serviceProvider, ratingPlan, ratingPeriodNode);
        if (ratingPeriodNode.getAttributes().getLength() == 2 && ratingPeriodNode.getAttributes().item(0).getNodeName().equals("Name") && ratingPeriodNode.getAttributes().item(1).getNodeName().equals("StartDate")) {
            completeRequest = false;
        }
        if (!completeRequest) {
            String ratingStructureFileName = RatingPeriodAction.createRatingStructureFile(ratingPeriod.getFileName(), ratingPeriodNode, false);
            Element ratingRuleTreeNode = XMLUtil.getNamedElement("RatingRuleTree", ratingPeriodNode.getChildNodes());
            NodeList l = ratingRuleTreeNode.getChildNodes();
            Node e = null;
            int len = l.getLength();
            for (int i = 0; i < len && e == null; ++i) {
                if (l.item(i).getNodeType() != 1) continue;
                e = l.item(i);
            }
            ratingPeriod.update(ratingStructureFileName, "2", Calendar.getInstance(), e);
        } else {
            String startDateStr = RatingPeriodAction.getStartDate(ratingPeriodNode);
            if (((Element)ratingPeriodNode).hasAttribute("NewStartDate")) {
                startDateStr = RatingPeriodAction.getRatingPeriodNewStartDate(ratingPeriodNode);
            }
            Calendar startTimeCalendar = DateUtil.stringToCalendar(startDateStr);
            RatingPeriodAction.verifyStartTimeUniqueWithinPlan(ratingPeriod, startTimeCalendar, ratingPlan);
            ratingPeriod.setStartTime(startTimeCalendar);
            RatingPeriodAction.changeName(ratingPeriod, ratingPeriodNode);
            ratingPeriod.replan(startTimeCalendar, startTimeCalendar);
            RatingPeriodAction.createRatingStructureFile(ratingPlan, ratingPeriodNode, false);
        }
        return WorkingDirHelper.createRatingPeriodXML("", ratingPeriod, false);
    }

    protected static void verifyStartTimeUniqueWithinPlan(RatingPeriod period, Calendar newStartTime, RatingPlan plan) throws Exception {
        if (period.getStartTime().getTime().getTime() != newStartTime.getTime().getTime()) {
            for (RatingPeriod currentRatingPeriod : plan.getAllRatingPeriods()) {
                if (currentRatingPeriod == period || currentRatingPeriod.getStartTime().getTimeInMillis() != newStartTime.getTime().getTime()) continue;
                throw new Exception("RatingPeriod '" + currentRatingPeriod.getName() + "' with the same start date already exist " + DataType.TIME.makeDisplayString(new Time(newStartTime)));
            }
        }
    }

    public static void changeName(RatingPeriod ratingPeriod, Node ratingPeriodNode) throws Exception {
        String newName = RatingPeriodAction.getRatingPeriodNewName(ratingPeriodNode);
        String newStartDateAndTime = RatingPeriodAction.getRatingPeriodNewStartDate(ratingPeriodNode);
        if (!ratingPeriod.getName().equals(newName)) {
            ratingPeriod.changeNameAndStartTime(newName, DateUtil.stringToCalendar(newStartDateAndTime));
        }
    }

    public static String getRatingPeriodNewName(Node ratingPeriodNode) throws Exception {
        return RatingPeriodAction.getAttribute("NewName", ratingPeriodNode);
    }

    public static String getRatingPeriodNewStartDate(Node ratingPeriodNode) throws Exception {
        return RatingPeriodAction.getAttribute("NewStartDate", ratingPeriodNode);
    }

    public static String getRatingPeriodName(Node ratingPeriodNode) throws Exception {
        return RatingPeriodAction.getAttribute("Name", ratingPeriodNode);
    }

    protected static String getStartDate(Node ratingPeriodNode) throws Exception {
        return RatingPeriodAction.getAttribute("StartDate", ratingPeriodNode);
    }

    protected static String createRatingStructureFile(RatingPlan plan, Node ratingPeriodNode, boolean throwIfMissing) throws Exception {
        String fileNameToUse = RatingPeriodAction.createRatingStructureFileName(plan.getServiceProviderName().getName(), plan.getIdentity(), RatingPeriodAction.getAttribute("Name", ratingPeriodNode), RatingPeriodAction.getAttribute("StartDate", ratingPeriodNode));
        if (((Element)ratingPeriodNode).hasAttribute("RatingStructureFile")) {
            ((Element)ratingPeriodNode).setAttribute("RatingStructureFile", fileNameToUse);
        }
        String ratingStructureFileName = WorkingDirHelper.getWorkingDirectoryString() + "/Provider/" + fileNameToUse;
        return RatingPeriodAction.createRatingStructureFile(ratingStructureFileName, ratingPeriodNode, throwIfMissing);
    }

    protected static String writeRatingPeriodConfigToFile(RatingPeriod period, Node ratingPeriodConfig) throws Exception {
        String startDateString = DateUtil.formatISODateTime(period.getStartTime(), false);
        String baseFileName = RatingPeriodAction.createRatingStructureFileName(period.getServiceProviderName(), period.getRatingPlanId(), period.getName(), startDateString);
        String ratingStructureFileName = WorkingDirHelper.getWorkingDirectoryString() + "/Provider/" + baseFileName;
        return FileVersionHandler.createNewVersionedFileIncludingAllConfig(4, ratingStructureFileName, ratingPeriodConfig);
    }

    private static String createRatingStructureFileName(String providerName, String planId, String periodName, String startDate) {
        StringBuilder builder = new StringBuilder();
        builder.append(providerName);
        builder.append("/");
        builder.append(planId);
        builder.append("/");
        builder.append(periodName);
        builder.append("_");
        builder.append(startDate);
        return builder.toString();
    }

    private static String createRatingStructureFile(String ratingStructureFileName, Node ratingPeriodNode, boolean throwIfMissing) throws Exception {
        Element ratingRuleTreeNode = XMLUtil.getNamedElement("RatingRuleTree", ratingPeriodNode.getChildNodes());
        if (ratingRuleTreeNode == null) {
            if (throwIfMissing) {
                throw new Exception("RatingRuleTree xml is missing");
            }
            return "";
        }
        return FileVersionHandler.createNewVersionedFile(4, ratingStructureFileName, ratingRuleTreeNode);
    }

    public static RatingPeriod getRatingPeriod(NodeList requestConfig, EreManager manager) throws Exception {
        RatingPeriod ratingPeriod = null;
        Element serviceProviderElement = XMLUtil.getNamedElement(ServiceProviderAction.TAG_SERVICEPROVIDER, requestConfig);
        if (serviceProviderElement == null) {
            throw new IllegalArgumentException("Invalid request, service provider not found.");
        }
        ServiceProvider serviceProvider = ServiceProviderAction.getServiceProvider(serviceProviderElement, manager);
        Element planElement = XMLUtil.getNamedElement(RatingPlanAction.TAG_RATINGPLAN, serviceProviderElement.getChildNodes());
        if (planElement == null) {
            throw new IllegalArgumentException("Invalid request, rating plan not found.");
        }
        RatingPlan plan = RatingPlanAction.getRatingPlan(serviceProvider, planElement);
        Element periodElement = XMLUtil.getNamedElement("RatingPeriod", planElement.getChildNodes());
        if (periodElement == null) {
            throw new IllegalArgumentException("Invalid request, rating period not found.");
        }
        String ratingPeriodName = RatingPeriodAction.getRatingPeriodName(periodElement);
        String startDateAndTime = RatingPeriodAction.getStartDate(periodElement);
        ratingPeriod = plan.getRatingPeriod(ratingPeriodName, startDateAndTime);
        return ratingPeriod;
    }

    public static void updatePeriodNameInStructure(Element config, String newName) {
        Element structureElement = config.getTagName().equals("TariffStructure") ? config : XMLUtil.getFirstElementNamed("TariffStructure", config);
        structureElement.setAttribute("Name", newName);
    }

    public static void removePeriodFromPropertyContainer(EreManager manager, RatingPeriod period) {
        manager.getPropertyContainer().forgetPeriod(period);
    }

    public static void updateVersion(Element versionElement, Calendar modifiedDate, String newVersion) {
        if (!RatingPeriodAction.isValidVersionTag(versionElement)) {
            throw new IllegalArgumentException("Provided element is not a valid rating period version tag.");
        }
        versionElement.setAttribute(ATTR_MODIFIED, DateUtil.formatISODateTime(modifiedDate, false));
        versionElement.setAttribute(ATTR_VERSION, newVersion);
    }

    private static boolean isValidVersionTag(Element versionElement) {
        if (versionElement != null && versionElement.getTagName().equals("Version")) {
            return versionElement.hasAttribute(ATTR_MODIFIED) && versionElement.hasAttribute(ATTR_VERSION);
        }
        return false;
    }
}

