/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.ratingmanager.action;

import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import java.util.Iterator;
import org.w3c.dom.Node;

public class RatingManagerAction
extends AbstractAction {
    public String createRatingManagerXML() {
        StringBuffer buffer = new StringBuffer("");
        EreManager manager = this.getEreManager();
        buffer.append("<Manager Name=\"" + manager.getName() + "\">\n");
        buffer.append("<ServiceList>\n");
        buffer.append(RatingManagerAction.getAllServicesXML(manager, "   "));
        buffer.append("</ServiceList>\n");
        buffer.append("<ServiceProviderList>\n");
        buffer.append(RatingManagerAction.getAllServiceProvidersXML(manager, "   "));
        buffer.append("</ServiceProviderList>\n");
        buffer.append("</Manager>");
        return buffer.toString();
    }

    public static String createRatingManagerXML(EreManager ereManager) {
        StringBuffer buffer = new StringBuffer("");
        EreManager manager = ereManager;
        buffer.append("<Manager Name=\"" + manager.getName() + "\">\n");
        buffer.append("<ServiceList>\n");
        buffer.append(RatingManagerAction.getAllServicesXML(manager, "   "));
        buffer.append("</ServiceList>\n");
        buffer.append("<ServiceProviderList>\n");
        buffer.append(RatingManagerAction.getAllServiceProvidersXML(manager, "   "));
        buffer.append("</ServiceProviderList>\n");
        buffer.append("</Manager>");
        return buffer.toString();
    }

    private static String getAllServicesXML(EreManager manager, String indent) {
        StringBuffer buffer = new StringBuffer("");
        Iterator<Service> serviceIterator = manager.getAllServices().iterator();
        while (serviceIterator.hasNext()) {
            String xml = WorkingDirHelper.createServiceXML(indent, serviceIterator.next(), false, false);
            buffer.append(xml);
        }
        return buffer.toString();
    }

    private static String getAllServiceProvidersXML(EreManager manager, String indent) {
        StringBuffer buffer = new StringBuffer("");
        Iterator<ServiceProvider> serviceProviderIterator = manager.getAllServiceProviders().iterator();
        while (serviceProviderIterator.hasNext()) {
            buffer.append(WorkingDirHelper.createServiceProviderXML(indent, serviceProviderIterator.next(), false));
        }
        return buffer.toString();
    }

    public void setRatingManager(Node command) throws Exception {
        String ratingManagerName = RatingManagerAction.getRatingManagerName(command);
        EreManager ratingManager = this.getEreManager();
        if (ratingManager == null || !ratingManagerName.equals(ratingManager.getName())) {
            throw new Exception("Rating Manager  '" + ratingManagerName + "' does NOT exist in Rating Manager");
        }
        RatingManagerAction.changeName(ratingManager, command);
    }

    private static String getRatingManagerName(Node ratingManagerNode) throws Exception {
        return RatingManagerAction.getAttribute("Name", ratingManagerNode);
    }

    private static String getRatingManagerNewName(Node ratingManagerNode) throws Exception {
        return RatingManagerAction.getAttribute("NewName", ratingManagerNode);
    }

    private static void changeName(EreManager ratingManager, Node ratingManagerNode) throws Exception {
        String newName = RatingManagerAction.getRatingManagerNewName(ratingManagerNode);
        if (newName.equals(ratingManager.getName())) {
            return;
        }
        ratingManager.setName(newName);
    }
}

