/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management;

import ericsson.ere.EreLibLoader;
import ericsson.ere.integration.defs.EreXmlCommand;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.xml.DomWriter;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FileVersionHandler {
    private static final SimpleDateFormat myDateFormatter = new SimpleDateFormat("yyyyMMdd'T'HHmmssSSS");
    private static final String REV_STR = "_rev_";

    public static void versionRatingManagerFile(int numberOfFilesToLeave, String contentXml) throws Exception {
        if (numberOfFilesToLeave > 0) {
            File usedFile = new File(EreLibLoader.getAbsoluteRatingManagerFile());
            String newFileNameStr = FileVersionHandler.getFileNameWithoutExtension(EreLibLoader.getRatingManagerFileName()) + REV_STR + FileVersionHandler.getDateStringNow() + FileVersionHandler.getFileNameExtension(EreLibLoader.getRatingManagerFileName());
            File newFileName = new File(EreLibLoader.getFullFilename(newFileNameStr));
            usedFile.renameTo(newFileName);
        }
        File ratingManagerFile = new File(EreLibLoader.getAbsoluteRatingManagerFile());
        String fileContents = EreXmlCommand.createProcessInstructionTag() + "\n" + contentXml;
        FileHandling.writeToFile(fileContents, ratingManagerFile, "UTF-8");
        if (numberOfFilesToLeave > 0) {
            File workingDir = new File(EreLibLoader.getWorkingDirectoryString());
            File[] dirList = workingDir.listFiles();
            TreeMap<CompareFileName, File> fileSort = new TreeMap<CompareFileName, File>();
            int numberOfAlreadyVersionedFiles = 0;
            int max = dirList.length;
            for (int ii = 0; ii < max; ++ii) {
                if (dirList[ii].getName().indexOf(FileVersionHandler.getFileNameWithoutExtension(EreLibLoader.getRatingManagerFileName())) < 0 || dirList[ii].getName().equals(EreLibLoader.getRatingManagerFileName())) continue;
                fileSort.put(new CompareFileName(dirList[ii]), dirList[ii]);
                ++numberOfAlreadyVersionedFiles;
            }
            int filesToRemove = 0;
            if (numberOfAlreadyVersionedFiles > numberOfFilesToLeave) {
                filesToRemove = numberOfAlreadyVersionedFiles - numberOfFilesToLeave;
            }
            for (File currentFile : fileSort.values()) {
                if (filesToRemove <= 0) break;
                currentFile.delete();
                --filesToRemove;
            }
        }
    }

    public static String createNewVersionedFile(int numberOfFilesToLeave, String fileName, Node xmlToSave) throws Exception {
        NodeList nodeList = xmlToSave.getChildNodes();
        for (int ii = 0; ii < nodeList.getLength(); ++ii) {
            if (nodeList.item(ii).getNodeType() != 1) continue;
            xmlToSave = nodeList.item(ii);
            break;
        }
        return FileVersionHandler.createNewVersionedFileIncludingAllConfig(numberOfFilesToLeave, fileName, xmlToSave);
    }

    public static String createNewVersionedFileIncludingAllConfig(int numberOfFilesToLeave, String fileName, Node config) throws Exception {
        int revNo = 0;
        if (config == null) {
            throw new Exception("Nothing to save to file '" + fileName + "' the xml is null");
        }
        revNo = FileVersionHandler.getNextRevisionNumber(fileName);
        String revision = REV_STR + FileVersionHandler.getDateStringNow() + ".xml";
        File structureFile = new File(FileVersionHandler.removeRevisionFromFileName(fileName) + revision);
        new File(structureFile.getParent()).mkdirs();
        while (structureFile.exists()) {
            ++revNo;
            revision = REV_STR + FileVersionHandler.getDateStringNow() + ".xml";
            structureFile = new File(FileVersionHandler.removeRevisionFromFileName(fileName) + revision);
        }
        structureFile.createNewFile();
        String xmlString = DomWriter.elementToString((Element)config);
        String fileContents = EreXmlCommand.createProcessInstructionTag() + "\n" + xmlString;
        FileHandling.writeToFile(fileContents, structureFile, "UTF-8");
        if (numberOfFilesToLeave > 0) {
            File workingDir = new File(structureFile.getParent());
            File[] dirList = workingDir.listFiles();
            TreeMap<CompareFileName, File> fileSort = new TreeMap<CompareFileName, File>();
            int numberOfAlreadyVersionedFiles = 0;
            int max = dirList.length;
            for (int ii = 0; ii < max; ++ii) {
                if (dirList[ii].getName().indexOf(FileVersionHandler.getFileNameWithoutRevisionNumber(structureFile.getName())) < 0) continue;
                fileSort.put(new CompareFileName(dirList[ii]), dirList[ii]);
                ++numberOfAlreadyVersionedFiles;
            }
            int filesToRemove = 0;
            if (numberOfAlreadyVersionedFiles > numberOfFilesToLeave) {
                filesToRemove = numberOfAlreadyVersionedFiles - numberOfFilesToLeave;
            }
            for (File currentFile : fileSort.values()) {
                if (filesToRemove <= 0) break;
                currentFile.delete();
                --filesToRemove;
            }
        }
        return structureFile.getAbsolutePath();
    }

    private static String getFileNameWithoutExtension(String fileName) {
        if (fileName.lastIndexOf(46) >= 0) {
            return fileName.substring(0, fileName.lastIndexOf(46));
        }
        return fileName;
    }

    private static String getFileNameWithoutRevisionNumber(String fileName) {
        if (fileName.lastIndexOf(REV_STR) >= 0) {
            return fileName.substring(0, fileName.lastIndexOf(REV_STR) + REV_STR.length() - 1);
        }
        return fileName;
    }

    private static String getFileNameExtension(String fileName) {
        if (fileName.lastIndexOf(46) >= 0) {
            return fileName.substring(fileName.lastIndexOf(46));
        }
        return "";
    }

    private static String removeRevisionFromFileName(String fileName) {
        int startIndex = fileName.toLowerCase().indexOf(REV_STR);
        if (startIndex >= 0) {
            return fileName.substring(0, startIndex);
        }
        return fileName;
    }

    private static int getNextRevisionNumber(String fileName) {
        int revision = 0;
        int startIndex = fileName.toLowerCase().indexOf(REV_STR);
        int stopIndex = fileName.toLowerCase().lastIndexOf(".");
        if (startIndex >= 0 && stopIndex >= 0 && stopIndex > startIndex) {
            String rev = fileName.substring(startIndex + REV_STR.length(), stopIndex);
            try {
                revision = Integer.parseInt(rev) + 1;
            }
            catch (NumberFormatException e) {
                revision = 0;
            }
        }
        return revision;
    }

    private static String getDateStringNow() {
        return myDateFormatter.format(Calendar.getInstance().getTime());
    }

    static class CompareFileName
    implements Comparable<CompareFileName> {
        File myFile;

        public CompareFileName(File theFile) {
            this.myFile = theFile;
        }

        private String getFileName() {
            return this.myFile.getName();
        }

        @Override
        public int compareTo(CompareFileName o) {
            return o.getFileName().compareTo(this.getFileName()) * -1;
        }
    }
}

