/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.EreRequestParser;
import ericsson.ere.integration.management.RequestParser;
import ericsson.ere.integration.receiver.session.SessionHandler;
import ericsson.ere.management.EreManager;
import ericsson.ere.xml.XMLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EreTrafficTask
implements Runnable {
    private static RequestParser parser = null;
    Socket connection;
    private static EreIntegrationLogInterface myLog = null;
    private EreManager myEreManager = null;
    private SessionHandler mySessionHandler = null;

    public EreTrafficTask(Socket theConnection, EreManager ereManager, SessionHandler sessionHandler) {
        this.myEreManager = ereManager;
        this.mySessionHandler = sessionHandler;
        this.connection = theConnection;
    }

    public EreTrafficTask(Socket theConnection, EreIntegrationLogInterface log, EreManager ereManager, SessionHandler sessionHandler) {
        this.myEreManager = ereManager;
        this.mySessionHandler = sessionHandler;
        this.connection = theConnection;
        EreTrafficTask.setLog(log);
    }

    public void init(Node setting) throws Exception {
        if (setting == null) {
            parser = new EreRequestParser();
            ((AbstractAction)((Object)parser)).setSessionHandler(this.mySessionHandler);
            ((AbstractAction)((Object)parser)).setEreManager(this.myEreManager);
            parser.init();
        } else {
            Element parserElement = (Element)setting;
            String className = "";
            try {
                className = parserElement.getAttribute("Class");
                parser = (RequestParser)EreClassLoader.createInstance(className);
                if (parserElement.hasChildNodes()) {
                    parser.init(parserElement.getChildNodes());
                } else {
                    parser.init(null);
                }
            }
            catch (InstantiationException e) {
                throw new InstantiationException("InstantiationException.Failed Instantiate from  class " + className + "  reason : \n" + e.getMessage());
            }
            catch (IllegalAccessException e) {
                throw new InstantiationException("IllegalAccessException. Failed Instantiate from  class " + className + "  reason : \n" + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                throw new InstantiationException("ClassNotFoundException. Failed Instantiate from  class " + className + "  reason : \n" + e.getMessage());
            }
            catch (Exception e) {
                throw new InstantiationException("Exception : Failed Instantiate  from  class " + className + "  reason : \n" + e.getMessage());
            }
        }
    }

    private static boolean useLogg() {
        return myLog != null;
    }

    public static void setLog(EreIntegrationLogInterface log) {
        myLog = log;
        if (EreTrafficTask.useLogg() && myLog.isLevel(3)) {
            myLog.print(3, "XmlCommand will use this log");
        }
    }

    private static int getUnsignedByte(byte theByte) {
        int retValue = 0;
        retValue = theByte < 0 ? theByte + 256 : theByte;
        return retValue;
    }

    private int sizeToInt(byte[] size) {
        int retValue = EreTrafficTask.getUnsignedByte(size[0]) * 256 * 256 * 256;
        retValue += EreTrafficTask.getUnsignedByte(size[1]) * 256 * 256;
        retValue += EreTrafficTask.getUnsignedByte(size[2]) * 256;
        if ((retValue += EreTrafficTask.getUnsignedByte(size[3])) < 0) {
            return retValue + Integer.MAX_VALUE;
        }
        return retValue;
    }

    @Override
    public void run() {
        String requestLine = null;
        String response = null;
        try {
            BufferedOutputStream out = new BufferedOutputStream(this.connection.getOutputStream());
            BufferedInputStream in = new BufferedInputStream(this.connection.getInputStream());
            while (true) {
                requestLine = null;
                response = null;
                byte[] sizeBytes = new byte[4];
                this.readDataFromStream(in, sizeBytes);
                int dataSize = this.sizeToInt(sizeBytes);
                if (dataSize > 0x100000) {
                    if (EreTrafficTask.useLogg() && myLog.isLevel(2)) {
                        myLog.print(2, "Size for request (" + dataSize + ") is to large max allowed zize is : (" + 1024000 + ")");
                    }
                    return;
                }
                byte[] data = new byte[dataSize];
                this.readDataFromStream(in, data);
                requestLine = new String(data);
                if (EreTrafficTask.useLogg() && myLog.isLevel(4)) {
                    myLog.print(4, "recieved request \n" + requestLine);
                }
                try {
                    Element node = XMLUtil.buildDocumentFromString(requestLine).getDocumentElement();
                    response = "<Response>\n" + parser.perform(node) + "</Response>";
                }
                catch (Exception e) {
                    if (EreTrafficTask.useLogg() && myLog.isLevel(3)) {
                        myLog.print(3, "Not valid Request, message:\n" + e.getMessage());
                    }
                    response = "<Response>\n<Error>" + e.getMessage() + "</Error>\n</Response>";
                }
                this.sendString(response, out);
                if (EreTrafficTask.useLogg() && myLog.isLevel(4)) {
                    myLog.print(4, "Response : \n" + response);
                }
                if (!EreTrafficTask.useLogg() || !myLog.isLevel(3)) continue;
                myLog.print(3, "Reguest  : \n" + requestLine + "\n- Response : \n" + response);
            }
        }
        catch (Exception e) {
            if (EreTrafficTask.useLogg() && myLog.isLevel(1)) {
                String msg = "Exception when parsing request message: " + e.getMessage() + "\n";
                if (requestLine != null) {
                    msg = "Request recieved : \n" + requestLine;
                }
                if (response != null) {
                    msg = "Response produced : \n" + response;
                }
                myLog.print(1, msg);
            } else {
                System.err.println("Error Exception when parsing request, message: " + e.getMessage());
            }
            return;
        }
    }

    private void readDataFromStream(InputStream in, byte[] data) throws Exception {
        int left = data.length;
        int offset = 0;
        while (left > 0) {
            int readBytes = in.read(data, offset, left);
            left -= readBytes;
            offset += readBytes;
        }
    }

    public void sendString(String theString, OutputStream out) throws IOException {
        byte[] data = theString.getBytes();
        byte[] dataSize = new byte[]{(byte)(data.length >> 24), (byte)(data.length >> 16), (byte)(data.length >> 8), (byte)(data.length >> 0)};
        out.write(dataSize);
        out.write(data);
        out.flush();
    }
}

