/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management;

import ericsson.ere.integration.management.AbstractRequestParser;
import ericsson.ere.integration.management.ManagerAction;
import ericsson.ere.integration.management.audit.AuditManagement;
import ericsson.ere.integration.management.echo.EchoManagement;
import ericsson.ere.integration.management.file.FileManagement;
import ericsson.ere.integration.management.rate.RateManagement;
import ericsson.ere.integration.management.ratingmanager.RatingManagerManagement;
import ericsson.ere.integration.management.ratingperiod.RatingPeriodManagement;
import ericsson.ere.integration.management.ratingplan.RatingPlanManagement;
import ericsson.ere.integration.management.service.ServiceManagement;
import ericsson.ere.integration.management.serviceprovider.ServiceProviderManagement;
import ericsson.ere.integration.management.session.SessionManagement;
import ericsson.ere.integration.management.time.TimeManagement;
import ericsson.ere.integration.util.ObjectRepository;
import ericsson.ere.management.EreManager;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EreRequestParser
extends AbstractRequestParser {
    private String ATTR_MO = "MO";
    private String ATTR_OPERATION = "Operation";
    private static final String TAG_REQUEST = "Request";
    private static final String ATTR_RATE = "Rate";
    private static final String ATTR_SERVICE = "Service";
    private static final String ATTR_SERVICEPROVIDER = "ServiceProvider";
    private static final String ATTR_RATINGPLAN = "RatingPlan";
    private static final String ATTR_RATINGPERIOD = "RatingPeriod";
    private static final String ATTR_RATINGMANAGER = "RatingManager";
    private static final String ATTR_FILE = "File";
    private static final String ATTR_TIME = "Time";
    private static final String ATTR_SESSION = "Session";
    private static final String ATTR_AUDIT = "Audit";
    private static final String ATTR_ECHO = "Echo";
    public static final String ATTR_SESSIONID = "SessionId";

    @Override
    public synchronized String perform(Node request) throws Exception {
        if (!request.getNodeName().equals(TAG_REQUEST)) {
            throw new Exception("'" + request.getNodeName() + "' is not supported use <" + TAG_REQUEST + "/>");
        }
        String mo = EreRequestParser.getAttribute(this.ATTR_MO, request);
        ManagerAction manager = (ManagerAction)this.myManagers.get(mo);
        if (manager == null) {
            throw new Exception(this.ATTR_MO + "=\"" + mo + "\"  Not supported ");
        }
        String operation = EreRequestParser.getAttribute(this.ATTR_OPERATION, request);
        if (!(mo.equalsIgnoreCase(ATTR_SESSION) && (operation.equalsIgnoreCase("Create") || operation.equalsIgnoreCase("Login")) || mo.equalsIgnoreCase(ATTR_ECHO) && operation.equalsIgnoreCase("Get"))) {
            this.checkRequestId(request);
        }
        return manager.perform(request);
    }

    private void checkRequestId(Node request) throws Exception {
        if (this.mySessionHandler == null) {
            throw new Exception("No SessionHandler set for EreRequestParser");
        }
        this.mySessionHandler.checkSession(EreRequestParser.getAttribute(ATTR_SESSIONID, request));
    }

    @Override
    public void init(NodeList settings) throws Exception {
        if (settings == null) {
            this.init();
        } else {
            this.myEreManager = (EreManager)ObjectRepository.getInstance().getObject("EreManager");
            super.init(settings);
        }
    }

    @Override
    public void init() {
        RateManagement rateManagement = new RateManagement();
        rateManagement.init();
        rateManagement.setEreManager(this.getEreManager());
        rateManagement.setSessionHandler(this.getSessionHandler());
        rateManagement.init();
        this.myManagers.put(ATTR_RATE, rateManagement);
        ServiceManagement serviceManagement = new ServiceManagement();
        serviceManagement.setEreManager(this.getEreManager());
        serviceManagement.setSessionHandler(this.getSessionHandler());
        serviceManagement.init();
        this.myManagers.put(ATTR_SERVICE, serviceManagement);
        ServiceProviderManagement serviceProviderManagement = new ServiceProviderManagement();
        serviceProviderManagement.setEreManager(this.getEreManager());
        serviceProviderManagement.setSessionHandler(this.getSessionHandler());
        serviceProviderManagement.init();
        this.myManagers.put(ATTR_SERVICEPROVIDER, serviceProviderManagement);
        RatingPlanManagement ratingPlanManagement = new RatingPlanManagement();
        ratingPlanManagement.setEreManager(this.getEreManager());
        ratingPlanManagement.setSessionHandler(this.getSessionHandler());
        ratingPlanManagement.init();
        this.myManagers.put(ATTR_RATINGPLAN, ratingPlanManagement);
        RatingPeriodManagement ratingPeriodManagement = new RatingPeriodManagement();
        ratingPeriodManagement.setEreManager(this.getEreManager());
        ratingPeriodManagement.setSessionHandler(this.getSessionHandler());
        ratingPeriodManagement.init();
        this.myManagers.put(ATTR_RATINGPERIOD, ratingPeriodManagement);
        RatingManagerManagement ratingManagerManagement = new RatingManagerManagement();
        ratingManagerManagement.setEreManager(this.myEreManager);
        ratingManagerManagement.setSessionHandler(this.getSessionHandler());
        ratingManagerManagement.init();
        this.myManagers.put(ATTR_RATINGMANAGER, ratingManagerManagement);
        FileManagement fileManagement = new FileManagement();
        fileManagement.setEreManager(this.getEreManager());
        fileManagement.setSessionHandler(this.getSessionHandler());
        fileManagement.init();
        this.myManagers.put(ATTR_FILE, fileManagement);
        TimeManagement timeManagement = new TimeManagement();
        timeManagement.setEreManager(this.getEreManager());
        timeManagement.setSessionHandler(this.getSessionHandler());
        timeManagement.init();
        this.myManagers.put(ATTR_TIME, timeManagement);
        SessionManagement sessionManagement = new SessionManagement();
        sessionManagement.setEreManager(this.myEreManager);
        sessionManagement.setSessionHandler(this.mySessionHandler);
        sessionManagement.init();
        this.myManagers.put(ATTR_SESSION, sessionManagement);
        AuditManagement auditManagement = new AuditManagement();
        auditManagement.setEreManager(this.myEreManager);
        auditManagement.setSessionHandler(this.mySessionHandler);
        auditManagement.init();
        this.myManagers.put(ATTR_AUDIT, auditManagement);
        EchoManagement echoManagement = new EchoManagement();
        echoManagement.setEreManager(this.myEreManager);
        echoManagement.setSessionHandler(this.mySessionHandler);
        this.myManagers.put(ATTR_ECHO, echoManagement);
    }
}

