/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.EreAction;
import ericsson.ere.integration.management.FileVersionHandler;
import ericsson.ere.integration.management.ManagerAction;
import ericsson.ere.integration.management.ratingmanager.action.RatingManagerAction;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractManagement
extends AbstractAction
implements ManagerAction {
    private static final String ATTR_CLASS = "Class";
    private static final String ATTR_NAME = "Name";
    private int myNumberOfVersionedFiles = 3;
    private Map<String, EreAction> myActions = new HashMap<String, EreAction>();
    public static final String ATTR_OPERATION = "Operation";
    public static final String ATTR_OPERATION_CREATE = "Create";
    public static final String ATTR_OPERATION_SET = "Set";
    public static final String ATTR_OPERATION_GET = "Get";
    public static final String ATTR_OPERATION_GET_PROP = "GetProperty";
    public static final String ATTR_OPERATION_SET_PROP = "SetProperty";
    public static final String ATTR_OPERATION_DELETE = "Delete";
    public static final String ATTR_OPERATION_ACTION = "Action";
    public static final String ATTR_OPERATION_LOGIN = "Login";
    public static final String ATTR_OPERATION_LOGOUT = "Logout";

    protected static String getAction(Node commandNode) throws Exception {
        return AbstractManagement.getAttribute(ATTR_OPERATION, commandNode);
    }

    protected void registerAction(String actionKey, AbstractAction action, boolean modifies) {
        action.setCommandModified(modifies);
        this.myActions.put(actionKey, action);
    }

    protected EreAction getActionObject(String actionKey) throws Exception {
        EreAction action = this.myActions.get(actionKey);
        if (action == null) {
            throw new Exception("Operation=\"" + actionKey + "\" is not supported");
        }
        return action;
    }

    public void setNumberOfVersionedFiles(int numberOfVersionedFiles) {
        this.myNumberOfVersionedFiles = numberOfVersionedFiles;
    }

    @Override
    public String perform(Node serviceCommandNode) throws Exception {
        EreAction action = this.getActionObject(AbstractManagement.getAction(serviceCommandNode));
        if (action == null) {
            throw new Exception("Operation='" + AbstractManagement.getAction(serviceCommandNode) + "' not supported");
        }
        String retMessage = "";
        try {
            retMessage = action.perform(serviceCommandNode.getChildNodes());
            if (action.commandModified()) {
                FileVersionHandler.versionRatingManagerFile(this.myNumberOfVersionedFiles, RatingManagerAction.createRatingManagerXML(this.getEreManager()));
            }
        }
        catch (Exception e) {
            return AbstractAction.createErrorTag("Operation=\"" + AbstractManagement.getAction(serviceCommandNode) + "\" \nMessage :" + e.getMessage());
        }
        return retMessage;
    }

    @Override
    public void init(NodeList settings) throws Exception {
        for (int ii = 0; ii < settings.getLength(); ++ii) {
            if (settings.item(ii).getNodeType() != 1) continue;
            String ereActionClassName = ((Element)settings.item(ii)).getAttribute(ATTR_CLASS);
            String ereActionName = ((Element)settings.item(ii)).getAttribute(ATTR_NAME);
            String modifyStr = ((Element)settings.item(ii)).getAttribute("Modify");
            try {
                EreAction ereAction = (EreAction)EreClassLoader.createInstance(ereActionClassName);
                if (ereAction instanceof AbstractAction) {
                    ((AbstractAction)ereAction).setEreManager(this.getEreManager());
                    ((AbstractAction)ereAction).setSessionHandler(this.getSessionHandler());
                }
                if (settings.item(ii).hasChildNodes()) {
                    ereAction.init(settings.item(ii).getChildNodes());
                }
                ereAction.setCommandModified(Boolean.parseBoolean(modifyStr));
                this.myActions.put(ereActionName, ereAction);
                continue;
            }
            catch (Exception e) {
                throw new InstantiationException(String.format("%s: Failed to instantiate %s from class %s; reason: \n%s", e.getClass().getSimpleName(), ereActionName, ereActionClassName, e.getMessage()));
            }
        }
    }
}

