/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.log;

import ericsson.ere.integration.config.ArgumentHandler;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.LogLevels;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

public class DefaultLog
implements EreIntegrationLogInterface,
Configurable {
    private PrintWriter myLogFile = null;
    private String myLogDir = null;
    SimpleDateFormat myFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private String myLine = "------------------------------------------------------------------------";
    private int myLevel = 3;

    public DefaultLog() {
        File file = new File(".");
        this.myLogDir = file.getAbsolutePath();
        this.myLogFile = new PrintWriter(System.out, true);
        this.myLevel = 4;
    }

    public DefaultLog(String logDir, String logFileName) {
        this.setLogDir(logDir);
        if (this.getLogDir() == null) {
            this.myLogFile = new PrintWriter(System.out, true);
            return;
        }
        try {
            this.myLogFile = new PrintWriter(new FileOutputStream(this.getLogDir() + logFileName + ".log", true), true);
            this.myLogFile.println("\n--" + logFileName + "--" + new Date().toString() + "--");
        }
        catch (Exception e) {
            this.myLogFile = new PrintWriter(System.err, true);
            this.print(1, "Exception when creating log file \n" + e.getMessage());
        }
    }

    public DefaultLog(PrintWriter writer) {
        this.myLogFile = writer;
    }

    public void setLogDir(String newDir) {
        this.myLogDir = newDir;
        if (this.myLogDir != null && !this.myLogDir.equals("null")) {
            if (!this.myLogDir.endsWith("/") || !this.myLogDir.endsWith("\\")) {
                this.myLogDir = this.myLogDir + "/";
            }
        } else {
            this.myLogDir = null;
        }
    }

    public String getLogDir() {
        return this.myLogDir;
    }

    @Override
    public void print(int level, String msg) {
        if (this.isLevel(level)) {
            if (msg == null) {
                msg = "null";
            }
            this.myLogFile.println("Time: " + this.myFormatter.format(new Date()) + ", Level: " + LogLevels.getLevelString(level));
            if (this.myLevel >= 4) {
                this.myLogFile.println("Stack information: " + this.getCallingClass());
            }
            this.myLogFile.println("- " + msg);
            this.myLogFile.println(this.myLine);
        }
    }

    @Override
    public int getLevel() {
        return this.myLevel;
    }

    @Override
    public boolean isLevel(int level) {
        return this.myLevel >= level;
    }

    @Override
    public void setLevel(int level) {
        this.print(3, "Changed log level from " + LogLevels.getLevelString(this.myLevel) + "(" + this.myLevel + ")  to " + LogLevels.getLevelString(level) + "(" + level + ")");
        this.myLevel = level;
    }

    private String getCallingClass() {
        StringWriter sw = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(sw));
        String stacktrace = sw.toString();
        StringTokenizer st = new StringTokenizer(stacktrace, "\n");
        st.nextToken();
        st.nextToken();
        st.nextToken();
        String classname = st.nextToken();
        classname = classname.substring(classname.indexOf("at ") + 3);
        return classname;
    }

    @Override
    public void init(Element root) throws ConfigurationException {
        File file = new File(".");
        String logDir = file.getAbsolutePath();
        String logFile = "STDOUT";
        int logLevel = 4;
        ArgumentHandler handler = new ArgumentHandler(root);
        if (handler.hasArgument("File")) {
            logFile = handler.getArgumentAsString("File");
        }
        if (handler.hasArgument("Directory")) {
            logDir = handler.getArgumentAsString("Directory");
        }
        if (handler.isArgumentAnInt("Level")) {
            logLevel = handler.getArgumentAsInt("Level");
        }
        this.setLevel(logLevel);
        this.setLogDir(logDir);
        if (logFile.equalsIgnoreCase("STDOUT")) {
            PrintWriter log = new PrintWriter(System.out, true);
        } else if (logFile.equalsIgnoreCase("STDERR")) {
            PrintWriter log = new PrintWriter(System.err, true);
        } else {
            try {
                PrintWriter log = new PrintWriter(new FileOutputStream(this.getLogDir() + logFile + ".log", true), true);
                this.setLogFile(log);
            }
            catch (Exception e) {
                System.out.println("Can not log ...");
            }
        }
    }

    public void setLogFile(PrintWriter writer) {
        this.myLogFile = writer;
    }
}

