/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.gui;

import com.ericsson.ere.io.IOUtil;
import ericsson.ere.integration.util.FileHandling;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public class FileLoader {
    private static FileLoader myInstance = new FileLoader();
    private ClassLoader myClassLoader = this.getClass().getClassLoader();

    private FileLoader() {
    }

    public static FileLoader getInstance() {
        return myInstance;
    }

    public static String fileToStringAsResource(String theFilename, String location) throws Exception {
        InputStream in = Class.forName(location).getResourceAsStream(theFilename);
        if (in == null) {
            throw new FileNotFoundException(theFilename);
        }
        StringBuffer loaded = new StringBuffer();
        InputStreamReader stream = new InputStreamReader(in);
        IOUtil.readAllAndClose(stream, loaded);
        return loaded.toString();
    }

    public static String getJarForClass(String className) {
        int beginClassFile = className.lastIndexOf(".");
        String fileToLocate = className + ".class";
        if (beginClassFile != -1) {
            fileToLocate = className.substring(beginClassFile + 1, className.length()) + ".class";
        }
        URL url = null;
        try {
            url = Class.forName(className).getResource(fileToLocate);
        }
        catch (ClassNotFoundException e) {
            return "";
        }
        String jarFile = url.getFile();
        if (jarFile != null) {
            int index;
            if (jarFile.indexOf("file:/") == 0) {
                jarFile = jarFile.substring("file:/".length() - 1, jarFile.length());
            }
            if ((index = jarFile.indexOf(".jar!")) != -1) {
                jarFile = jarFile.substring(0, index + (".jar!".length() - 1));
            } else {
                return "";
            }
        }
        return jarFile;
    }

    public static void saveFile(Object contents, String theFileName) throws Exception {
        try {
            FileHandling.writeToFile(contents.toString(), new File(theFileName));
        }
        catch (MalformedURLException e) {
            System.out.println("Cant " + e);
        }
        catch (IOException e) {
            System.out.println("Cant write " + e);
            throw e;
        }
    }

    public String loadFile(String file) throws IOException, FileNotFoundException {
        StringBuffer loaded = new StringBuffer();
        try {
            IOUtil.readAllAndClose(new FileReader(file), loaded);
            return loaded.toString();
        }
        catch (IOException e) {
            try {
                loaded.setLength(0);
                InputStreamReader reader = new InputStreamReader(this.myClassLoader.getResourceAsStream(file), "UTF-8");
                IOUtil.readAllAndClose(reader, loaded);
                return loaded.toString();
            }
            catch (Exception n) {
                throw e;
            }
        }
        catch (OutOfMemoryError me) {
            System.err.println("Memory problem...\n" + me);
            me.printStackTrace();
            throw me;
        }
    }

    public InputStream loadStream(String fileToStream) {
        return this.myClassLoader.getResourceAsStream(fileToStream);
    }

    public ImageIcon getImage(String path) {
        ImageIcon theImage = null;
        try {
            theImage = new ImageIcon(this.myClassLoader.getResource(path));
        }
        catch (Exception e) {
            System.out.println("Exception while retrieving image '" + path + "' - " + e.toString());
        }
        return theImage;
    }
}

