/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.connector;

import com.ericsson.ere.functioncontrol.FunctionControllerProvider;
import com.ericsson.ere.functioncontrol.FunctionManager;
import com.ericsson.ere.functioncontrol.FunctionManagerImpl;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.gui.Config;
import ericsson.ere.integration.connector.EreConnector;
import ericsson.ere.integration.settingsmap.propertyio.XMLInput;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConnectorFactory {
    public static final String CONNECTOR_LIST_TAG = "Connectors";
    public static final String CONNECTOR_TAG = "Connector";
    public static final String NODE_LIST_TAG = "NodeTypes";
    public static final String NODE_TAG = "NodeType";
    private static ConnectorFactory INSTANCE;
    private Hashtable<String, Object> myConnectorTypes = new Hashtable();
    private Hashtable<String, Object> myNodeTypes = new Hashtable();
    private List<String> myCreatableTypes = new ArrayList<String>();
    private Handler myHandler = new Handler();

    private ConnectorFactory() {
        Config.getInstance().addConfigChangeListener(NODE_LIST_TAG, this.myHandler);
        Config.getInstance().addConfigChangeListener(CONNECTOR_LIST_TAG, this.myHandler);
    }

    public static synchronized ConnectorFactory getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ConnectorFactory();
        }
        return INSTANCE;
    }

    private void initConnectorTypes() {
        if (!this.myConnectorTypes.isEmpty()) {
            return;
        }
        Vector<Node> types = Config.getInstance().getConfigFor(CONNECTOR_LIST_TAG);
        for (int ii = 0; types != null && ii < types.size(); ++ii) {
            Element connector = (Element)types.get(ii);
            if (!connector.getTagName().equals(CONNECTOR_TAG)) continue;
            String type = connector.getAttribute("type");
            String ref = connector.getAttribute("ref");
            if (ref != null && ref.length() > 0) {
                Object refObj = this.myConnectorTypes.get(ref);
                if (refObj == null) continue;
                this.myConnectorTypes.put(type, refObj);
                continue;
            }
            this.myConnectorTypes.put(type, connector);
        }
    }

    private void initNodeTypes() {
        if (!this.myNodeTypes.isEmpty()) {
            return;
        }
        this.myCreatableTypes.clear();
        Vector<Node> types = Config.getInstance().getConfigFor(NODE_LIST_TAG);
        for (int ii = 0; types != null && ii < types.size(); ++ii) {
            Element node = (Element)types.get(ii);
            if (!node.getTagName().equals(NODE_TAG)) continue;
            String type = node.getAttribute("type");
            String connector = node.getAttribute("connector");
            String creatable = node.getAttribute("creatable");
            this.myNodeTypes.put(type, connector);
            if (creatable.equals("false")) continue;
            this.myCreatableTypes.add(type);
        }
    }

    public EreConnector createConnector(String ntype) throws InstantiationException {
        EreConnector connector = this.createTemporaryConnector(ntype);
        this.registerFunctionController(connector);
        return connector;
    }

    public EreConnector createTemporaryConnector(String ntype) throws InstantiationException {
        this.initNodeTypes();
        String type = (String)this.myNodeTypes.get(ntype);
        if (type == null) {
            throw new InstantiationException("InstantiationException. Node type " + ntype + " could not be found!");
        }
        this.initConnectorTypes();
        Element settingElement = (Element)this.myConnectorTypes.get(type);
        if (settingElement == null) {
            throw new InstantiationException("InstantiationException. Connector type " + type + " could not be found!");
        }
        EreConnector connector = null;
        String className = settingElement.getAttribute("class");
        try {
            connector = (EreConnector)EreClassLoader.createInstance(className);
            connector.init(type, XMLInput.readFromElement(settingElement));
        }
        catch (Exception e) {
            InstantiationException x = new InstantiationException(e.getClass().getSimpleName() + ". Connector " + className + " could not be instantiated!");
            x.initCause(e);
            throw x;
        }
        return connector;
    }

    private void registerFunctionController(EreConnector connector) {
        if (connector instanceof FunctionControllerProvider) {
            FunctionManager mgr = FunctionManagerImpl.getInstance();
            mgr.registerFunctionController(connector, ((FunctionControllerProvider)((Object)connector)).getFunctionController());
        }
    }

    public String[] getTypes() {
        this.initNodeTypes();
        if (this.myCreatableTypes.size() > 0) {
            return this.myCreatableTypes.toArray(new String[this.myCreatableTypes.size()]);
        }
        return null;
    }

    private class Handler
    implements PropertyChangeListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            if (ConnectorFactory.CONNECTOR_LIST_TAG.equals(prop)) {
                ConnectorFactory.this.myConnectorTypes.clear();
            } else if (ConnectorFactory.NODE_LIST_TAG.equals(prop)) {
                ConnectorFactory.this.myNodeTypes.clear();
            }
        }
    }
}

