/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.FileVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLTableModel
extends VarTableModel {
    static final String TAG_PROPERTY = "Property";
    static final String TAG_PARAMETER = "Parameter";
    static final String ATTR_NAME = "name";
    static final String ATTR_VALUE = "value";
    static final String ATTR_TYPE = "type";
    static final String ATTR_READONLY = "readonly";
    Hashtable<String, Variable> myVariables = new Hashtable();
    Properties myProperties = null;

    public XMLTableModel() {
    }

    private XMLTableModel(Properties props) {
        this.myProperties = (Properties)props.clone();
    }

    public XMLTableModel(Element root) {
        this.parseXML(root);
    }

    @Override
    public Object clone() {
        XMLTableModel tm = new XMLTableModel(this.myProperties);
        for (Variable org : this.dataVector) {
            Variable clone = (Variable)org.clone();
            tm.dataVector.add(clone);
            tm.myVariables.put(clone.getLabel(), clone);
        }
        return tm;
    }

    public boolean equals(Object c) {
        if (!(c instanceof XMLTableModel)) {
            return false;
        }
        XMLTableModel xc = (XMLTableModel)c;
        if (this.dataVector.size() != xc.dataVector.size()) {
            return false;
        }
        Enumeration<String> keys = this.myVariables.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            Variable otherVar = xc.myVariables.get(key);
            Variable ownVar = this.myVariables.get(key);
            if (otherVar == null) {
                return false;
            }
            if (!otherVar.getValueClass().equals(ownVar.getValueClass())) {
                return false;
            }
            if (otherVar.getValueObject().toString().equals(ownVar.getValueObject().toString())) continue;
            return false;
        }
        return true;
    }

    private void parseXML(Element root) {
        this.readParameters(root);
        this.readProperties(root);
    }

    private void readParameters(Element root) {
        NodeList aList = root.getElementsByTagName(TAG_PARAMETER);
        for (int i = 0; i < aList.getLength(); ++i) {
            if (!(aList.item(i) instanceof Element)) continue;
            Element e = (Element)aList.item(i);
            String name = e.getAttribute(ATTR_NAME);
            String value = e.getAttribute(ATTR_VALUE);
            String type = e.getAttribute(ATTR_TYPE);
            String readonly = e.getAttribute(ATTR_READONLY);
            Variable var = this.createVariable(name, value, type);
            if (var == null) continue;
            if (readonly != null && readonly.equalsIgnoreCase("true")) {
                var.setAllowEdit(false);
            }
            this.dataVector.add(var);
            this.myVariables.put(name, var);
        }
    }

    private void readProperties(Element root) {
        this.myProperties = new Properties();
        NodeList aList = root.getElementsByTagName(TAG_PROPERTY);
        for (int i = 0; i < aList.getLength(); ++i) {
            Element e;
            if (!(aList.item(i) instanceof Element) || !(e = (Element)aList.item(i)).hasAttribute(ATTR_NAME) || !e.hasAttribute(ATTR_VALUE)) continue;
            String name = e.getAttribute(ATTR_NAME);
            String value = e.getAttribute(ATTR_VALUE);
            this.myProperties.setProperty(name, value);
        }
    }

    public void update(XMLTableModel values) {
        Enumeration<String> keys = this.myVariables.keys();
        while (keys.hasMoreElements()) {
            Variable ownVar;
            String k = keys.nextElement();
            Variable newVar = values.myVariables.get(k);
            if (newVar == null || !(ownVar = this.myVariables.get(k)).getValueClass().equals(newVar.getValueClass())) continue;
            ownVar.setValue(newVar.getValueObject());
        }
    }

    public String getValueFor(String parameter) {
        Variable v = this.myVariables.get(parameter);
        return v == null || v.getValueObject() == null ? null : v.getValueObject().toString();
    }

    public void setValueFor(String parameter, String value) {
        Variable v = this.myVariables.get(parameter);
        if (v != null) {
            v.setValue(value);
        }
    }

    public void setValue(String parameter, String value) {
        Variable v = this.myVariables.get(parameter);
        if (v != null) {
            v.setValue(value);
        }
    }

    public String getXML(String indent) {
        StringBuffer xml = new StringBuffer();
        for (Variable v : this.dataVector) {
            if (this.getType(v).equals("Unknown")) continue;
            xml.append(indent);
            xml.append("<Parameter name=\"");
            xml.append(v.getLabel());
            xml.append("\" value=\"");
            xml.append(v.getValueObject().toString());
            xml.append("\" type=\"");
            xml.append(this.getType(v));
            if (!v.isAllowEdit()) {
                xml.append("\" readonly=\"true");
            }
            xml.append("\"/>\n");
        }
        return xml.toString();
    }

    public String toString() {
        return this.getXML("");
    }

    private Variable createVariable(String name, String value, String type) {
        if (type.equalsIgnoreCase("String")) {
            return this.createStringVariable(name, value);
        }
        if (type.equalsIgnoreCase("Integer")) {
            return this.createIntegerVariable(name, value);
        }
        if (type.equalsIgnoreCase("Bool") || type.equalsIgnoreCase("Boolean")) {
            return this.createBooleanVariable(name, value);
        }
        if (type.equalsIgnoreCase("File")) {
            return this.createFileVariable(name, value);
        }
        return null;
    }

    private Variable createStringVariable(String name, String value) {
        return new StringVariable(name, value);
    }

    private Variable createIntegerVariable(String name, String value) {
        try {
            int v = Integer.parseInt(value);
            return new IntegerVariable(name, v);
        }
        catch (Exception e) {
            System.out.println("Failed to parse parameter value to integer: " + value);
            return null;
        }
    }

    private Variable createBooleanVariable(String name, String value) {
        boolean v = false;
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on")) {
            v = true;
        }
        return new BoolVariable(name, v);
    }

    private Variable createFileVariable(String name, String value) {
        return new FileVariable(name, value);
    }

    private String getType(Variable v) {
        switch (v.getFormat()) {
            case 6: {
                return "File";
            }
            case 0: {
                return "String";
            }
            case 5: {
                return "Integer";
            }
            case 1: {
                return "Boolean";
            }
        }
        return "Unknown";
    }

    public String getProperty(String key) {
        if (this.myProperties != null) {
            return this.myProperties.getProperty(key);
        }
        return null;
    }

    @Override
    public void addRow(Variable variable) {
        this.myVariables.put(variable.getLabel(), variable);
        super.addRow(variable);
    }
}

