/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.defs.RmaDefs;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

public final class RmaAction
extends AbstractAction {
    public static final Class<?>[] PARAMETERS = new Class[]{ActionEvent.class};
    Object myTarget = null;
    Method myMethod = null;

    public void setTarget(Object target) {
        this.myTarget = target;
    }

    public RmaAction(Object target, String method, String actionCommand) {
        super(actionCommand);
        this.myTarget = target;
        Class<?> tgtClass = this.myTarget.getClass();
        try {
            this.myMethod = tgtClass.getDeclaredMethod(method, PARAMETERS);
        }
        catch (NoSuchMethodException x) {
            throw new IllegalArgumentException("Method not found: " + method + "(ActionEvent) in class " + tgtClass, x);
        }
        catch (SecurityException x) {
            throw new RuntimeException(x);
        }
        this.putValue("ActionCommandKey", actionCommand);
    }

    public RmaAction(Object target, String method, String actionCommand, String icon, String toolTip) {
        this(target, method, actionCommand);
        if (icon != null) {
            this.putValue("SmallIcon", RmaDefs.getImageIcon(icon));
        }
        if (toolTip != null) {
            this.putValue("ShortDescription", toolTip);
        }
    }

    public RmaAction(Object target, String method, String actionCommand, String largeIcon, String smallIcon, String toolTip, KeyStroke accelerator) {
        this(target, method, actionCommand);
        if (largeIcon != null) {
            this.putValue("SwingLargeIconKey", RmaDefs.getImageIcon(largeIcon));
        }
        if (smallIcon != null) {
            this.putValue("SmallIcon", RmaDefs.getImageIcon(smallIcon));
        }
        if (toolTip != null) {
            this.putValue("ShortDescription", toolTip);
        }
        if (accelerator != null) {
            this.putValue("AcceleratorKey", accelerator);
        }
    }

    public RmaAction(Object target, String method, String actionCommand, String icon, String toolTip, KeyStroke accelerator) {
        this(target, method, actionCommand, icon, toolTip);
        if (accelerator != null) {
            this.putValue("AcceleratorKey", accelerator);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] args = new Object[]{e};
        try {
            this.myMethod.invoke(this.myTarget, args);
        }
        catch (IllegalAccessException x) {
            throw new RuntimeException(x);
        }
        catch (InvocationTargetException x) {
            throw new RuntimeException(x);
        }
    }

    public KeyStroke getAcceleratorKey() {
        return (KeyStroke)this.getValue("AcceleratorKey");
    }
}

