/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import com.ericsson.ere.swing.EDT;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.InformationPane;
import ericsson.ere.progress.ProgressIndicator;
import ericsson.ere.progress.ProgressIndicatorHandler;
import ericsson.ere.progress.ProgressVisualizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;

public class ProgressDialog
extends JDialog
implements ProgressVisualizer {
    JLabel myInfoLabel = null;
    JProgressBar myProgress = null;
    InformationPane myAdditionalInfo = null;
    JButton myButton = null;
    boolean isCanceled = false;
    boolean confirmBeforeExit = false;
    Vector<ActionListener> listenerList = new Vector();

    public ProgressDialog(String title, String message) {
        this(title, message, true);
    }

    public ProgressDialog(String title, String message, boolean canCancel) {
        this(title, message, false, canCancel);
    }

    public ProgressDialog(String title, String message, boolean useAdditionalInfo, boolean canCancel) {
        super((Frame)GuiServiceCenter.getInstance().getMainWindow(), true);
        this.setTitle(title);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        int y = 0;
        this.myInfoLabel = new JLabel();
        JTextArea txtMessage = new JTextArea();
        txtMessage.setBackground(this.myInfoLabel.getBackground());
        txtMessage.setEditable(false);
        txtMessage.setFont(txtMessage.getFont().deriveFont(1));
        txtMessage.setText(message);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(12, 12, 0, 11);
        gridBagConstraints.weighty = useAdditionalInfo ? 0.0 : 1.0;
        mainPanel.add((Component)txtMessage, gridBagConstraints);
        if (useAdditionalInfo) {
            this.myAdditionalInfo = new InformationPane();
            this.myAdditionalInfo.setLineWrap(true);
            JScrollPane scroll = new JScrollPane(this.myAdditionalInfo);
            scroll.setPreferredSize(new Dimension(320, 240));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = y++;
            gridBagConstraints.insets = new Insets(11, 12, 0, 11);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            mainPanel.add((Component)scroll, gridBagConstraints);
        }
        this.myProgress = new JProgressBar();
        this.myProgress.setBorderPainted(true);
        this.myProgress.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = new Insets(11, 12, 0, 11);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add((Component)this.myProgress, gridBagConstraints);
        this.myInfoLabel.setText(" ");
        this.myInfoLabel.setFont(this.myInfoLabel.getFont().deriveFont(0, 11.0f));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = new Insets(0, 12, 0, 11);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        mainPanel.add((Component)this.myInfoLabel, gridBagConstraints);
        this.myButton = new JButton();
        this.myButton.setText("Cancel");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.insets = new Insets(17, 12, 0, 11);
        mainPanel.add((Component)this.myButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = y++;
        gridBagConstraints.weighty = 1.0;
        mainPanel.add(Box.createVerticalStrut(12), gridBagConstraints);
        if (canCancel) {
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ProgressDialog.this.isCanceled = true;
                    ProgressDialog.this.notifyActionListeners();
                }
            };
            this.myButton.addActionListener(action);
            mainPanel.getInputMap(2).put(KeyStroke.getKeyStroke("ESCAPE"), "cancel");
            mainPanel.getActionMap().put("cancel", action);
        }
        this.myButton.setVisible(canCancel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressDialog.this.isCanceled = true;
                ProgressDialog.this.notifyActionListeners();
            }
        });
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
        if (canCancel) {
            this.myButton.requestFocusInWindow();
        }
    }

    public ProgressIndicator getProgressIndicator() {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(this);
        return handler.getProgressIndicator();
    }

    public ProgressIndicator getProgressIndicator(int goal) {
        ProgressIndicatorHandler handler = new ProgressIndicatorHandler(goal, this);
        return handler.getProgressIndicator();
    }

    @Override
    public boolean isCanceled() {
        return this.isCanceled;
    }

    @Override
    public void showAdditionalInfo(String text) {
        if (this.myAdditionalInfo != null) {
            this.myAdditionalInfo.addInformation(text, Color.RED, 0);
        }
    }

    @Override
    public void setConfirmBeforeExit() {
        this.confirmBeforeExit = true;
    }

    public boolean confirmBeforeExit() {
        return this.myAdditionalInfo == null ? false : this.confirmBeforeExit;
    }

    public synchronized void waitForConfirmation() {
        this.isCanceled = false;
        this.myButton.setText("OK");
        while (!this.isCanceled) {
            try {
                this.wait(100L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    @Override
    public void setProgressGoal(int goal) {
        this.myProgress.setMinimum(0);
        this.myProgress.setMaximum(goal);
    }

    @Override
    public void setValue(final int value) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.myProgress.setValue(value);
            }
        });
    }

    public void setIndeterminate(boolean newValue) {
        this.myProgress.setIndeterminate(newValue);
    }

    public void setStringPainted(boolean b) {
        this.myProgress.setStringPainted(b);
    }

    @Override
    public void setInfoText(final String info) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                ProgressDialog.this.myInfoLabel.setText(info);
            }
        });
        if (this.myAdditionalInfo != null) {
            this.myAdditionalInfo.addText(info, Color.BLACK, 2, false);
        }
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    private void notifyActionListeners() {
        for (ActionListener listener : this.listenerList) {
            listener.actionPerformed(new ActionEvent(this, 1, "UNDEFINED"));
        }
    }
}

