/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.gui.interfaces.SimulationEditor;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.Variable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NumberRangeEditor
implements XMLInitializable,
SimulationEditor {
    private FieldDefinition myField = null;
    private BigDecimal myMinValue = new BigDecimal(Long.valueOf(Long.MIN_VALUE).toString());
    private BigDecimal myMaxValue = new BigDecimal(Long.valueOf(Long.MAX_VALUE).toString());
    private String myMinValueString = "-9223372036854775808";
    private String myMaxValueString = "9223372036854775807";

    @Override
    public XMLInitializable init(Node defs) {
        NamedNodeMap attr;
        Element n = XMLUtil.getNamedElement("Range", defs.getChildNodes());
        if (n != null && (attr = n.getAttributes()) != null) {
            Node a = attr.getNamedItem("min");
            if (a == null) {
                a = attr.getNamedItem("Min");
            }
            if (a != null) {
                this.myMinValueString = a.getNodeValue();
                this.myMinValue = new BigDecimal(this.myMinValueString);
            }
            if ((a = attr.getNamedItem("max")) == null) {
                a = attr.getNamedItem("Max");
            }
            if (a != null) {
                this.myMaxValueString = a.getNodeValue();
                this.myMaxValue = new BigDecimal(this.myMaxValueString);
            }
        }
        return this;
    }

    @Override
    public String getEditStringForValue(String v) {
        return v;
    }

    @Override
    public String getValueForEditString(String editString) {
        return editString;
    }

    @Override
    public boolean isValidEditString(String editString) {
        return this.isValidValueString(editString);
    }

    @Override
    public boolean isValidValueString(String value) {
        try {
            BigDecimal val = new BigDecimal(value);
            if (val.compareTo(this.myMinValue) >= 0 && val.compareTo(this.myMaxValue) <= 0) {
                return true;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void setFieldDefinition(FieldDefinition f) {
        this.myField = f;
    }

    @Override
    public Variable createVariable() {
        Variable theVar;
        String name = this.myField.getFieldName();
        String dfltStr = null;
        DataType theType = this.myField.getTypedDataType();
        if (this.myField.hasDefaultValue()) {
            dfltStr = this.myField.getDefaultValue();
            if (dfltStr.isEmpty()) {
                dfltStr = theType.makeValueString(theType.createDefaultInstance());
            }
        } else {
            dfltStr = this.myMinValue.toString();
        }
        switch (theType) {
            case INTEGER: 
            case UNSIGNEDINT: 
            case LONG: 
            case UNSIGNEDLONG: 
            case SHORT: 
            case UNSIGNEDSHORT: 
            case UNSIGNEDINT32: 
            case UNSIGNEDINT16: 
            case UNSIGNEDINT8: 
            case RATINGDECIMAL: {
                theVar = VariableFactory.getVariableOfDataType(theType.getTypeName(), name, null, this.myMinValueString, this.myMaxValueString, dfltStr);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field definition is not of a supported type!");
            }
        }
        return theVar;
    }

    public BigInteger getMinValue() {
        return this.myMinValue.toBigInteger();
    }

    public BigInteger getMaxValue() {
        return this.myMaxValue.toBigInteger();
    }

    public long getLongMinValue() {
        return this.myMinValue.longValue();
    }

    public long getLongMaxValue() {
        return this.myMaxValue.longValue();
    }

    public String getMinValueString() {
        return this.myMinValueString;
    }

    public String getMaxValueString() {
        return this.myMaxValueString;
    }
}

