/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.RmaFrameSupport;
import ericsson.ere.interfaces.DAGNode;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyVetoException;
import java.util.Stack;
import javax.swing.JDesktopPane;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;

public final class GuiUtil {
    static int SCROLLPANE_BREAK_WIDTH = 130;
    static int SCROLLPANE_BREAK_HEIGHT = 90;

    public static String replaceSubString(String s, String oldToken, String newToken) {
        if (s == null || oldToken == null || newToken == null) {
            return s;
        }
        int tokenPos = s.indexOf(oldToken);
        if (tokenPos == -1) {
            return s;
        }
        String start = s.substring(0, tokenPos);
        String end = s.substring(tokenPos + oldToken.length());
        return GuiUtil.replaceSubString(start + newToken + end, oldToken, newToken);
    }

    public static String multilineTooltipWrapper(String s) {
        String returnString = "<html>" + GuiUtil.replaceSubString(s, "\n", "<p>") + "</html>";
        return returnString;
    }

    public static String descriptionToTooltip(String description, String name, String comment) {
        String cmt;
        String[] parts = GuiUtil.splitDescriptionIntoNameAndRemainder(description, name);
        String leadingName = parts[0];
        String remainingDescription = parts[1];
        boolean hasName = leadingName.length() > 0;
        boolean hasDescription = remainingDescription.length() > 0;
        StringBuilder builder = new StringBuilder();
        if (hasName) {
            builder.append("<b>").append(HTMLUtil.escape(leadingName)).append("</b>");
        }
        if (hasDescription) {
            if (hasName) {
                builder.append(" ");
            }
            builder.append(HTMLUtil.escape(remainingDescription));
        }
        if (comment != null && (cmt = comment.trim()).length() > 0) {
            builder.append("\n").append(cmt);
        }
        return GuiUtil.multilineTooltipWrapper(builder.toString());
    }

    private static String[] splitDescriptionIntoNameAndRemainder(String description, String name) {
        String leadingName = "";
        String remainingDescription = description;
        if (name != null) {
            if (description.equals(name)) {
                leadingName = name;
                remainingDescription = "";
            } else if (description.startsWith(name + " ")) {
                leadingName = name;
                remainingDescription = description.substring(name.length() + 1);
            }
        }
        return new String[]{leadingName, remainingDescription};
    }

    public static Window getClosestWindowParent(Component c) {
        Window window = GuiUtil.getClosestParentOfClass(c, Window.class);
        return window != null ? window : GuiServiceCenter.getInstance().getMainWindow();
    }

    public static <T extends Component> T getClosestParentOfClass(Component c, Class<T> cls) {
        return (T)SwingUtilities.getAncestorOfClass(cls, c);
    }

    public static JLayeredPane getInternalFrameOwner(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JInternalFrame) {
            return ((JInternalFrame)c).getLayeredPane();
        }
        if (c instanceof JFrame) {
            return ((JFrame)c).getLayeredPane();
        }
        if (c instanceof JDesktopPane) {
            return (JDesktopPane)c;
        }
        return GuiUtil.getInternalFrameOwner(c.getParent());
    }

    public static void setDefaultCursor(Component c) {
        if (c != null) {
            c.setCursor(Cursor.getDefaultCursor());
        }
    }

    public static void setBusyCursor(Component c) {
        if (c != null) {
            c.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    public static void addMouseListenerToComponents(Container c, MouseListener l) {
        c.addMouseListener(l);
        Component[] children = c.getComponents();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (child == null) continue;
            if (child instanceof Container) {
                GuiUtil.addMouseListenerToComponents((Container)child, l);
                continue;
            }
            child.addMouseListener(l);
        }
    }

    public static int getMaxPreferredHeight(JTable table, int row) {
        int height = 0;
        for (int col = 0; col < table.getColumnCount(); ++col) {
            TableCellRenderer renderer = table.getCellRenderer(row, col);
            Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col);
            height = Math.max(height, comp.getPreferredSize().height);
        }
        return height;
    }

    public static int getMaxPreferredWidth(JTable table, int col) {
        TableColumn column = table.getColumnModel().getColumn(col);
        TableCellRenderer renderer = column.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, col);
        int width = 0;
        width = comp.getPreferredSize().width;
        for (int row = 0; row < table.getRowCount(); ++row) {
            renderer = table.getCellRenderer(row, col);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        return width;
    }

    public static void getMaxPreferredDimensions(JTable table, int[] rowdata, int[] coldata) {
        Component comp;
        TableCellRenderer renderer;
        int i;
        int nRows = table.getRowCount();
        int nCol = table.getColumnCount();
        for (i = 0; i < rowdata.length; ++i) {
            rowdata[i] = 0;
        }
        for (i = 0; i < coldata.length; ++i) {
            coldata[i] = 0;
        }
        for (int col = 0; col < nCol; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            renderer = column.getHeaderRenderer();
            if (renderer == null) {
                renderer = table.getTableHeader().getDefaultRenderer();
            }
            comp = renderer.getTableCellRendererComponent(table, column.getHeaderValue(), false, false, 0, col);
            int width = comp.getPreferredSize().width;
            if (coldata[col] >= width) continue;
            coldata[col] = width;
        }
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCol; ++col) {
                renderer = table.getCellRenderer(row, col);
                comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, col), false, false, row, col);
                Dimension prefSize = comp.getPreferredSize();
                int width = prefSize.width;
                int height = prefSize.height;
                if (comp instanceof JScrollPane) {
                    int dx = width - SCROLLPANE_BREAK_WIDTH;
                    int dy = height - SCROLLPANE_BREAK_HEIGHT;
                    if (dx > 0) {
                        width -= dx / 2;
                    }
                    if (dy > 0) {
                        height -= dy / 2;
                    }
                }
                coldata[col] = Math.max(coldata[col], width);
                rowdata[row] = Math.max(rowdata[row], height);
            }
        }
    }

    public static void setContainerEnabled(Container container, boolean enabled) {
        Stack<Component> components = new Stack<Component>();
        components.push(container);
        while (!components.isEmpty()) {
            Component c = (Component)components.pop();
            if (c instanceof Container) {
                for (Component comp : ((Container)c).getComponents()) {
                    components.push(comp);
                }
            }
            c.setEnabled(enabled);
        }
    }

    public static String trimStringLength(String string, int maxLength) {
        if (string.length() < maxLength) {
            return string;
        }
        String divider = "..";
        int amble = maxLength / 2 - divider.length() / 2;
        String preamble = string.substring(0, amble);
        String postamble = string.substring(string.length() - amble, string.length());
        while (preamble.length() + divider.length() + postamble.length() < maxLength) {
            divider = divider + ".";
        }
        return preamble + divider + postamble;
    }

    public static RmaFrameSupport getRmaFrameOwner(Component c) {
        return GuiUtil.getClosestParentOfClass(c, RmaFrameSupport.class);
    }

    public static void setIconIgnoringException(JInternalFrame frame, boolean icon) {
        try {
            frame.setIcon(icon);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static void setSelectedIgnoringException(JInternalFrame frame, boolean selected) {
        try {
            frame.setSelected(selected);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static void setMaximumIgnoringException(JInternalFrame frame, boolean maximum) {
        try {
            frame.setMaximum(maximum);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public static void enableSelectionOnRightClick(final JTree tree) {
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                tree.requestFocusInWindow();
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    TreePath selPath = tree.getPathForRow(selRow);
                    tree.setSelectionPath(selPath);
                }
            }
        });
    }

    public static void disableRootCollapse(JTree tree) {
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                Object node = event.getPath().getLastPathComponent();
                boolean isRoot = false;
                if (node instanceof DefaultMutableTreeNode) {
                    isRoot = ((DefaultMutableTreeNode)node).isRoot();
                } else if (node instanceof DAGNode) {
                    boolean bl = isRoot = ((DAGNode)node).getParent() == null;
                }
                if (isRoot) {
                    throw new ExpandVetoException(event);
                }
            }
        });
    }

    static {
        try {
            int w = Integer.parseInt(RmaDefs.getStringResource("guiutil.scrollpane.break.width"));
            int h = Integer.parseInt(RmaDefs.getStringResource("guiutil.scrollpane.break.height"));
            SCROLLPANE_BREAK_WIDTH = w;
            SCROLLPANE_BREAK_HEIGHT = h;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }
}

