/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class ErrorDialog
extends JDialog {
    JTextArea myExtendedInfo;
    JScrollPane scrollPane;
    JButton btnMore;

    public ErrorDialog(String title, String message, String extendedMessage) {
        this((Window)GuiServiceCenter.getInstance().getMainWindow(), title, message, extendedMessage);
    }

    public ErrorDialog(String title, String message) {
        this((Window)GuiServiceCenter.getInstance().getMainWindow(), title, message);
    }

    public ErrorDialog(Window owner, String title, String message, String extendedMessage) {
        super(owner, Dialog.DEFAULT_MODALITY_TYPE);
        this.createDialog(title, message, extendedMessage);
    }

    public ErrorDialog(Window owner, String title, String message) {
        super(owner, Dialog.DEFAULT_MODALITY_TYPE);
        String extendedMessage = "";
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        for (int i = 2; i < elements.length; ++i) {
            extendedMessage = extendedMessage + elements[i].toString() + "\n";
        }
        this.createDialog(title, message, extendedMessage);
    }

    private void createDialog(String title, String message, String extendedMessage) {
        this.setTitle(title);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridBagLayout());
        JTextArea txtMessage = new JTextArea();
        txtMessage.setName("ErrorDialog.JTextArea.Message");
        txtMessage.setBackground(mainPanel.getBackground());
        txtMessage.setEditable(false);
        txtMessage.setText(message);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 15, 10, 15);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weighty = 1.0;
        mainPanel.add((Component)txtMessage, gridBagConstraints);
        JButton btnOk = new JButton();
        btnOk.setName("ErrorDialog.JButton.OK");
        btnOk.setText("OK");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        mainPanel.add((Component)btnOk, gridBagConstraints);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ErrorDialog.this.dispose();
            }
        });
        this.btnMore = new JButton();
        this.btnMore.setName("ErrorDialog.JButton.LessMore");
        this.btnMore.setText("More >>>");
        if (RmaDefs.getInstance().getDebugProperty().equalsIgnoreCase("off")) {
            this.btnMore.setVisible(false);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 0, 0, 5);
        mainPanel.add((Component)this.btnMore, gridBagConstraints);
        this.btnMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ErrorDialog.this.scrollPane.isVisible()) {
                    ErrorDialog.this.scrollPane.setVisible(false);
                    ErrorDialog.this.btnMore.setText("More >>>");
                } else {
                    ErrorDialog.this.scrollPane.setVisible(true);
                    ErrorDialog.this.btnMore.setText("Less <<<");
                }
                ErrorDialog.this.pack();
                ErrorDialog.this.repaint();
            }
        });
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVisible(false);
        this.scrollPane.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.myExtendedInfo = new JTextArea();
        this.myExtendedInfo.setName("ErrorDialog.JTextArea.ExtendedInfo");
        this.myExtendedInfo.setBackground(mainPanel.getBackground());
        this.myExtendedInfo.setEditable(false);
        this.myExtendedInfo.setText(extendedMessage);
        this.scrollPane.setViewportView(this.myExtendedInfo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(10, 15, 10, 15);
        gridBagConstraints.weighty = 1.0;
        mainPanel.add((Component)this.scrollPane, gridBagConstraints);
        this.getContentPane().add((Component)mainPanel, "Center");
        this.pack();
        this.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
    }
}

