/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.UtilMenuItem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.ByteArrayOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.w3c.dom.Node;

public class ConsoleFrame
extends JPanel
implements UtilMenuItem {
    static String CMD_CAPTURE_OUT = "capture.out";
    static String CMD_CAPTURE_ERR = "capture.err";
    static String CMD_CLEAR = "clear";
    private boolean myCatchErrors = true;
    private boolean myLogFile = false;
    private String myFileName = "NoFile";
    private int myCloseOperation = 2;
    JTextArea aTextArea = new JTextArea(20, 20);
    PrintStream outPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream(), ""));
    PrintStream errPrintStream = new PrintStream(new FilteredStream(new ByteArrayOutputStream(), "[ERR] "));
    JInternalFrame myOwnerFrame;

    public ConsoleFrame(JInternalFrame aOwnerFrame, Node aConfig) {
        this.myOwnerFrame = aOwnerFrame;
        this.init();
        this.myOwnerFrame.setDefaultCloseOperation(this.myCloseOperation);
        this.myOwnerFrame.addInternalFrameListener(new InternalFrameListener(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                ConsoleFrame.this.stopCaptureOut();
                ConsoleFrame.this.stopCaptureErr();
            }

            @Override
            public void internalFrameDeactivated(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameDeiconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameIconified(InternalFrameEvent e) {
            }

            @Override
            public void internalFrameOpened(InternalFrameEvent e) {
            }
        });
    }

    public ConsoleFrame() {
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.aTextArea), "Center");
        this.add((Component)this.controlPanel(new ControlListener()), "South");
        System.setOut(this.outPrintStream);
        if (this.myCatchErrors) {
            System.setErr(this.errPrintStream);
        }
    }

    public void captureOut() {
        System.setOut(this.outPrintStream);
    }

    public void stopCaptureOut() {
        System.setOut(GuiServiceCenter.stdOut);
    }

    public void captureErr() {
        System.setOut(this.errPrintStream);
    }

    public void stopCaptureErr() {
        System.setErr(GuiServiceCenter.stdOut);
    }

    private JPanel controlPanel(ActionListener controlListener) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JCheckBox captureStdOut = new JCheckBox("Capture out", true);
        captureStdOut.setActionCommand(CMD_CAPTURE_OUT);
        captureStdOut.addActionListener(controlListener);
        JCheckBox captureStdErr = new JCheckBox("Capture err", true);
        captureStdErr.setActionCommand(CMD_CAPTURE_ERR);
        captureStdErr.addActionListener(controlListener);
        JButton clearButton = new JButton("Clear");
        clearButton.setActionCommand(CMD_CLEAR);
        clearButton.addActionListener(controlListener);
        panel.add(captureStdOut);
        panel.add(captureStdErr);
        panel.add(clearButton);
        return panel;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    @Override
    public String getTitle() {
        return "Console";
    }

    @Override
    public boolean isClosable() {
        return true;
    }

    @Override
    public boolean isIconifiable() {
        return true;
    }

    @Override
    public boolean isMaximizable() {
        return true;
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public static void main(String[] args) {
        ConsoleFrame thePanel = new ConsoleFrame();
        final JFrame frame = new JFrame();
        frame.getContentPane().add(thePanel.getComponent(), "Center");
        frame.setTitle(thePanel.getTitle());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                frame.dispose();
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    class ControlListener
    implements ActionListener {
        ControlListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals(CMD_CAPTURE_ERR)) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ConsoleFrame.this.captureErr();
                } else {
                    ConsoleFrame.this.stopCaptureErr();
                }
            } else if (cmd.equals(CMD_CAPTURE_OUT)) {
                if (((JCheckBox)e.getSource()).isSelected()) {
                    ConsoleFrame.this.captureOut();
                } else {
                    ConsoleFrame.this.stopCaptureOut();
                }
            } else if (cmd.equals(CMD_CLEAR)) {
                ConsoleFrame.this.aTextArea.setText("");
            }
        }
    }

    class FilteredStream
    extends FilterOutputStream {
        String myPrefix;

        public FilteredStream(OutputStream aStream, String prefix) {
            super(aStream);
            this.myPrefix = prefix;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            String aString = new String(b, off, len);
            ConsoleFrame.this.aTextArea.append(this.myPrefix + aString);
            ConsoleFrame.this.aTextArea.setCaretPosition(ConsoleFrame.this.aTextArea.getText().length());
            if (ConsoleFrame.this.myLogFile) {
                FileWriter aWriter = new FileWriter(ConsoleFrame.this.myFileName, true);
                aWriter.write(aString);
                aWriter.close();
            }
        }
    }
}

