/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.simulation.sdp;

import com.ericsson.ere.gui.util.SystemPropertyUtil;
import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.gui.interfaces.RatingResultEvaluator;
import ericsson.ere.gui.simulation.RatingDataPanel;
import ericsson.ere.interfaces.XMLInitializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTextArea;
import org.w3c.dom.Node;

public class SDPCallResultEvaluator
implements XMLInitializable,
RatingResultEvaluator {
    public static final String NO_OF_DECIMAL_PROP = "sdp.sim.noOfDecimals";

    @Override
    public XMLInitializable init(Node node) throws Exception {
        return this;
    }

    @Override
    public boolean check(RatingData theData, Map expected, JTextArea trace) throws Exception {
        boolean isValid = true;
        Iterator keys = expected.keySet().iterator();
        trace.append("\n");
        String noOfDecimalString = SystemPropertyUtil.getPropertyWithOptionalJnlpPrefix(NO_OF_DECIMAL_PROP, "3");
        double EPSILON = 1.0;
        int nDec = 3;
        try {
            nDec = Integer.parseInt(noOfDecimalString);
            if (nDec < 0 || nDec > 10) {
                nDec = 3;
                trace.append("Valid number of decimals out of range. Using default: " + nDec);
            }
        }
        catch (NumberFormatException x) {
            trace.append("Failed determining valid number of decimals. Using default: " + nDec);
        }
        EPSILON = 5.0 * StrictMath.pow(10.0, -1 * (nDec + 1));
        while (keys.hasNext()) {
            Number exp;
            String key = (String)keys.next();
            if (RatingDataPanel.TAG_EXPECTED_DURATION.equals(key)) {
                exp = (Long)expected.get(key);
                if (exp != null) {
                    if ((Long)exp == theData.currentDuration) continue;
                    trace.append("Duration mismatch: Calculated: " + theData.currentDuration + " seconds, but expected: " + exp + "\n");
                    isValid = false;
                    continue;
                }
                trace.append("Expected duration missing, nothing to compare with.\n");
                isValid = false;
                continue;
            }
            if (RatingDataPanel.TAG_EXPECTED_COST.equals(key)) {
                exp = (Double)expected.get(key);
                if (exp != null) {
                    if (!(Math.abs((Double)exp - theData.totalCost) >= EPSILON)) continue;
                    trace.append("Cost mismatch: Calculated total: " + theData.totalCost + " but expected: " + exp + "\n");
                    isValid = false;
                    continue;
                }
                trace.append("Expected cost missing, nothing to compare with.\n");
                isValid = false;
                continue;
            }
            if (theData.containsKey(key)) {
                RatingDataField dataField = theData.getRatingDataFieldByName(key);
                RatingDataField expField = (RatingDataField)expected.get(key);
                Object[] data = dataField.getObjectArray();
                Object[] exp2 = expField.getObjectArray();
                if (data == null) {
                    if (exp2 == null) continue;
                    trace.append("Field value missing: \"" + key + "\". Expected value: \"" + this.arrayToString(exp2) + "\"\n");
                    isValid = false;
                    continue;
                }
                if (data.length > 0 && exp2.length > 0 && data[0] instanceof Double && exp2[0] instanceof Double) {
                    Double dataVal = (Double)data[0];
                    Double expVal = (Double)exp2[0];
                    if (!(StrictMath.abs(dataVal - expVal) >= EPSILON)) continue;
                    trace.append("Result mismatch: \"" + key + "\" has value: " + dataVal + ". Expected value: " + expVal + "\n");
                    isValid = false;
                    continue;
                }
                if (Arrays.equals(data, exp2)) continue;
                trace.append("Result mismatch: \"" + key + "\" has value \"" + this.arrayToString(data) + "\". Expected value: \"" + this.arrayToString(exp2) + "\"\n");
                isValid = false;
                continue;
            }
            trace.append("Field missing: \"" + key + "\".\n");
            isValid = false;
        }
        trace.append("\n");
        return isValid;
    }

    private String arrayToString(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (arr.length == 1) {
            if (arr[0] == null) {
                return "null";
            }
            return arr[0].toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(";");
            }
            if (arr[i] == null) {
                buf.append("null");
                continue;
            }
            buf.append(arr[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

