/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.simulation;

import com.ericsson.ere.gui.simulator.SimulationFactory;
import com.ericsson.ere.gui.simulator.SimulatorPanelInterface;
import ericsson.ere.RatingData;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.help.HelpSystem;
import ericsson.ere.gui.interfaces.DocumentBuilder;
import ericsson.ere.gui.interfaces.RatingExecutor;
import ericsson.ere.gui.ratingrules.RatingRuleFrame;
import ericsson.ere.gui.simulation.RatingDataPanel;
import ericsson.ere.gui.util.DefaultDocumentBuilder;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.gui.util.RmaAction;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.ContextAwareServiceContainer;
import ericsson.ere.management.Service;
import ericsson.ere.trace.RatingTraceRma;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimulatorPanel
extends JPanel
implements SimulatorPanelInterface {
    private JToolBar myToolbar = new JToolBar();
    private JPopupMenu myPopupMenu = new JPopupMenu();
    static final Color BG_COLOR_FAILED = Color.RED;
    static final Color BG_COLOR_ERROR = Color.RED.darker();
    static final Color FG_COLOR_FAILED = Color.RED.brighter();
    static final Color FG_COLOR_ERROR = Color.RED;
    static final String ACTION_NEW = "New";
    static final String ACTION_DELETE = "Delete";
    static final String ACTION_OPEN = "Open";
    static final String ACTION_SAVE = "Save";
    static final String ACTION_SAVE_AS = "Save As";
    static final String ACTION_EXECUTE = "Execute";
    static final String ACTION_RUN_ALL = "Run All";
    private JCheckBox isTerse = new JCheckBox("Summary");
    private JTabbedPane myRatingDataTabs;
    private Service myService;
    private ClassRepository myClassRepository;
    private JTextArea myTraceDestination;
    private RatingExecutor myRatingExecutor;
    private PopupAdapter myPopupListener;
    private TabTitleAdapter myTitleListener;
    private String myFileName = null;
    private Action myNewAction;
    private Action myDeleteAction;
    private Action myOpenAction;
    private Action mySaveAction;
    private Action mySaveAsAction;
    private Action myExecuteAction;
    private Action myRunAllAction;
    private Action[] myActions;
    private DefaultDocumentBuilder myDocBuilder = new DefaultDocumentBuilder();

    public SimulatorPanel(ContextAwareServiceContainer serviceContainer, JTextArea trace, RatingExecutor theExecutor) {
        this.myService = serviceContainer.getService();
        this.myClassRepository = serviceContainer.getClassRepository();
        this.myTraceDestination = trace;
        this.myRatingExecutor = theExecutor;
        this.myRatingDataTabs = new JTabbedPane();
        this.myRatingDataTabs.setTabLayoutPolicy(1);
        this.myNewAction = new RmaAction(this, "createAction", ACTION_NEW, "NewCall24.gif", "Create a new call case");
        this.myDeleteAction = new RmaAction(this, "deleteAction", ACTION_DELETE, "RemoveCall24.gif", "Delete the selected call case");
        this.myOpenAction = new RmaAction(this, "loadAction", ACTION_OPEN, "Open24.gif", "Open a new set of call cases");
        this.mySaveAction = new RmaAction(this, "saveAction", ACTION_SAVE, "Save24.gif", "Save the current set of call cases");
        this.mySaveAsAction = new RmaAction(this, "saveAsAction", ACTION_SAVE_AS, "SaveAs24.gif", "Save the current set of call cases as another file");
        this.myExecuteAction = new RmaAction(this, "executeAction", ACTION_EXECUTE, "Edit24.gif", "Execute the current call case");
        this.myRunAllAction = new RmaAction(this, "runAllAction", ACTION_RUN_ALL, "History24.gif", "Execute all the call cases currently loaded");
        this.myActions = new Action[]{this.myNewAction, this.myDeleteAction, this.myOpenAction, this.mySaveAction, this.mySaveAsAction, this.myExecuteAction, this.myRunAllAction};
        this.setLayout(new BorderLayout());
        this.initMenuAndToolbar();
        this.add((Component)this.myToolbar, "North");
        this.add((Component)this.myRatingDataTabs, "Center");
        this.myTitleListener = new TabTitleAdapter();
        try {
            XMLInitializable x = this.myClassRepository.createUtil("Simulator", "DocumentBuilder");
            if (x != null && x instanceof DocumentBuilder) {
                this.myDocBuilder = new DefaultDocumentBuilder((DocumentBuilder)((Object)x));
            }
        }
        catch (Exception x) {
            // empty catch block
        }
        try {
            RatingDataPanel p = new RatingDataPanel(serviceContainer.getService());
            p.addPropertyChangeListener(this.myTitleListener);
            this.myRatingDataTabs.add(p);
        }
        catch (Exception x) {
            DialogFactory.getErrorDialog("Error creating simulator data", "Could not create simulator data for " + serviceContainer.getService().getId() + " due to :\n" + x.getMessage());
        }
        this.resetModified();
        this.myPopupListener = new PopupAdapter();
        Component[] children = this.myRatingDataTabs.getComponents();
        if (children == null) {
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            Component child = children[i];
            if (child == null || !(child instanceof RatingDataPanel)) continue;
            GuiUtil.addMouseListenerToComponents((Container)child, this.myPopupListener);
        }
        HelpSystem.getInstance().enableHelpKey(this, this.getClass().toString());
    }

    private JFileChooser getFileChooser() {
        JFileChooser c = GuiServiceCenter.getInstance().getSimFileChooser();
        GuiServiceCenter.getInstance().setFileFilter("sim");
        return c;
    }

    public void createAction(ActionEvent e) {
        try {
            RatingDataPanel panel = new RatingDataPanel(this.myService);
            panel.addPropertyChangeListener(this.myTitleListener);
            GuiUtil.addMouseListenerToComponents(panel, this.myPopupListener);
            this.myRatingDataTabs.add(panel);
            this.myRatingDataTabs.setSelectedComponent(panel);
        }
        catch (Exception x) {
            DialogFactory.getErrorDialog("Error creating simulator data", "Could not create simulator data for " + this.myService.getId() + " due to :\n" + x.getMessage());
        }
    }

    public void deleteAction(ActionEvent e) {
        RatingDataPanel selected = (RatingDataPanel)this.myRatingDataTabs.getSelectedComponent();
        if (selected != null) {
            if (this.myRatingDataTabs.getTabCount() > 1) {
                selected.removePropertyChangeListener(this.myTitleListener);
                this.myRatingDataTabs.remove(selected);
            } else {
                DialogFactory.getInformationDialog(this, "Delete not possible", "Not allowed to delete the last call case. \nA set of call cases must hold at least one call case.");
            }
        }
    }

    public void saveAsAction(ActionEvent e) {
        int dialogAnswer = 2;
        do {
            int retVal;
            if (this.myFileName != null) {
                this.getFileChooser().setSelectedFile(new File(this.myFileName));
            }
            if ((retVal = this.getFileChooser().showSaveDialog(this)) != 0) break;
            File dest = this.getFileChooser().getSelectedFile();
            if (!dest.exists() && dest.getName().indexOf(46) == -1) {
                String extension = ".sim";
                if (this.getFileChooser().getFileFilter().getDescription().indexOf("xml") >= 0) {
                    extension = ".xml";
                }
                this.getFileChooser().setSelectedFile(new File(dest.getPath() + extension));
                dest = this.getFileChooser().getSelectedFile();
            }
            dialogAnswer = 0;
            if (dest.exists()) {
                dialogAnswer = DialogFactory.getQuestionDialogWithCancel(this, "File exists", "The file '" + dest.getPath() + "' exists, overwrite existing file?");
            }
            if (dialogAnswer == 2) continue;
            try {
                if (dialogAnswer != 0) continue;
                this.myFileName = this.getFileChooser().getSelectedFile().getPath();
                this.saveAction(e);
            }
            catch (Exception excep) {
                DialogFactory.getErrorDialog("Error saving file ", "Could not save " + dest.getPath() + " due to :\n" + excep.getMessage());
                RmaDefs.loggerRatingManager.warning("Error when exporting Simulator settings " + excep.getMessage());
            }
        } while (dialogAnswer == 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void saveAction(ActionEvent e) {
        File file = null;
        GuiUtil.setBusyCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        try {
            if (this.myFileName == null) {
                file = new File("default.sim");
                this.myFileName = file.getAbsolutePath();
            } else {
                file = new File(this.myFileName);
            }
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            PrintWriter writer = new PrintWriter(out);
            writer.println("<SimulationSuite>");
            int len = this.myRatingDataTabs.getTabCount();
            for (int i = 0; i < len; ++i) {
                RatingDataPanel tab = (RatingDataPanel)this.myRatingDataTabs.getComponentAt(i);
                tab.save(writer);
            }
            writer.println("</SimulationSuite>");
            writer.flush();
            writer.close();
            this.myRatingExecutor.setSessionName(file.getName());
            this.resetModified();
        }
        catch (Exception x) {
            DialogFactory.getErrorDialog("Error while saving Rating Data", "Could not save " + file.getPath() + " due to :\n" + x.getMessage());
        }
        finally {
            GuiUtil.setDefaultCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAction(ActionEvent e) {
        int result = -1;
        File file = this.getFileChooser().getSelectedFile();
        if (this.myFileName == null) {
            file = new File("default.sim");
            this.myFileName = file.getAbsolutePath();
        } else {
            file = new File(this.myFileName);
        }
        this.getFileChooser().setSelectedFile(new File(this.myFileName));
        if (this.isModified()) {
            result = DialogFactory.getQuestionDialogWithCancel(this, "Save " + file.getName(), "Save Changes ?\n" + file.getName());
            if (result == 2) {
                return;
            }
            if (result == 0) {
                this.saveAction(new ActionEvent(this, 0, "change file"));
            }
        }
        GuiUtil.setBusyCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        try {
            int i;
            int retVal = this.getFileChooser().showOpenDialog(this);
            if (retVal != 0) {
                return;
            }
            file = this.getFileChooser().getSelectedFile();
            this.myFileName = this.getFileChooser().getSelectedFile().getPath();
            Document doc = this.myDocBuilder.buildDocumentFromFile(file);
            Element root = doc.getDocumentElement();
            NodeList nodes = root.getChildNodes();
            ArrayList<RatingDataPanel> l = new ArrayList<RatingDataPanel>(nodes.getLength());
            for (i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node.getNodeType() != 1) continue;
                try {
                    RatingDataPanel panel = new RatingDataPanel(this.myService);
                    panel.init(node);
                    l.add(panel);
                    GuiUtil.addMouseListenerToComponents(panel, this.myPopupListener);
                    continue;
                }
                catch (IllegalArgumentException x) {
                    DialogFactory.getErrorDialog("Error while loading Rating Data", "Error at node: " + node.getNodeName() + "\nDetails: " + x.toString());
                    continue;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    DialogFactory.getErrorDialog("Error creating simulator data", "Could not create simulator data for " + this.myService.getId() + " due to :\n" + x.getMessage());
                }
            }
            if (l.size() == 0) {
                return;
            }
            this.myRatingDataTabs.removeAll();
            for (i = 0; i < l.size(); ++i) {
                RatingDataPanel panel = (RatingDataPanel)l.get(i);
                panel.addPropertyChangeListener(this.myTitleListener);
                this.myRatingDataTabs.add(panel);
            }
            this.myRatingExecutor.setSessionName(file.getName());
            this.resetModified();
        }
        catch (Exception x) {
            x.printStackTrace();
            DialogFactory.getErrorDialog("Error while loading Rating Data", x.toString());
        }
        finally {
            GuiUtil.setDefaultCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeAction(ActionEvent e) {
        RatingDataPanel selected = (RatingDataPanel)this.myRatingDataTabs.getSelectedComponent();
        int selectedIndex = this.myRatingDataTabs.getSelectedIndex();
        boolean success = true;
        boolean isError = false;
        int MAX_PROGRESS = 50;
        int progress = 0;
        GuiUtil.setBusyCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        try {
            this.myRatingExecutor.setUp();
            progress += 10;
            RatingData data = selected.createRatingData();
            if (!this.isTerse.isSelected()) {
                data.setTrace(new RatingTraceRma(this.myTraceDestination));
                this.myTraceDestination.setText("");
            }
            Map<String, Object> expected = selected.createExpectedResults();
            if (this.myRatingExecutor instanceof RatingRuleFrame) {
                data.printRatingInfo(((RatingRuleFrame)((Object)this.myRatingExecutor)).getRatingPeriod());
                data.printAllData();
            }
            progress += 10;
            success = this.myRatingExecutor.execute(data, expected);
            progress += 10;
            if (this.myRatingExecutor instanceof RatingRuleFrame) {
                data.printUsedAndResultData();
            }
            this.myRatingExecutor.tearDown();
            progress += 10;
        }
        catch (Exception x) {
            isError = true;
            x.printStackTrace();
            DialogFactory.getErrorDialog("Error while executing rate", x.toString());
            this.myTraceDestination.append("\nERROR: " + selected.getName() + "\n");
        }
        finally {
            GuiUtil.setDefaultCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        }
        progress = 50;
        if (isError) {
            this.myRatingDataTabs.setForegroundAt(selectedIndex, FG_COLOR_ERROR);
            return;
        }
        if (success) {
            this.myRatingDataTabs.setForegroundAt(selectedIndex, null);
            this.myTraceDestination.append("\nSUCCESS: " + selected.getName() + "\n");
        } else {
            this.myRatingDataTabs.setForegroundAt(selectedIndex, FG_COLOR_FAILED);
            this.myTraceDestination.append("\nFAILED: " + selected.getName() + "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runAllAction(ActionEvent e) {
        int i;
        int nTabs = this.myRatingDataTabs.getTabCount();
        int nSuccess = 0;
        ArrayList<String> failedRuns = new ArrayList<String>();
        ArrayList<String> errorRuns = new ArrayList<String>();
        int MAX_PROGRESS = 20 * nTabs + 20;
        int progress = 0;
        GuiUtil.setBusyCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        try {
            this.myRatingExecutor.setUp();
            this.myTraceDestination.setText("");
            progress += 10;
            for (i = 0; i < nTabs; ++i) {
                RatingDataPanel tab = (RatingDataPanel)this.myRatingDataTabs.getComponentAt(i);
                try {
                    RatingData data = tab.createRatingData();
                    if (!this.isTerse.isSelected()) {
                        data.setTrace(new RatingTraceRma(this.myTraceDestination));
                    }
                    Map<String, Object> expected = tab.createExpectedResults();
                    if (this.myRatingExecutor instanceof RatingRuleFrame) {
                        data.printRatingInfo(((RatingRuleFrame)((Object)this.myRatingExecutor)).getRatingPeriod());
                        data.printAllData();
                    }
                    progress += 10;
                    if (this.myRatingExecutor.execute(data, expected)) {
                        ++nSuccess;
                        this.myRatingDataTabs.setForegroundAt(i, null);
                    } else {
                        failedRuns.add(tab.getName());
                        this.myRatingDataTabs.setForegroundAt(i, FG_COLOR_FAILED);
                    }
                    progress += 10;
                    if (!(this.myRatingExecutor instanceof RatingRuleFrame)) continue;
                    data.printUsedAndResultData();
                    continue;
                }
                catch (Exception x) {
                    this.myRatingDataTabs.setForegroundAt(i, FG_COLOR_ERROR);
                    errorRuns.add(tab.getName());
                    x.printStackTrace();
                    DialogFactory.getErrorDialog("Error while executing rate", x.toString());
                }
            }
            this.myRatingExecutor.tearDown();
            progress += 10;
        }
        catch (Exception x) {
            DialogFactory.getErrorDialog("Error while setting up rate", x.toString());
        }
        finally {
            GuiUtil.setDefaultCursor(GuiUtil.getClosestParentOfClass(this, JInternalFrame.class));
        }
        progress = MAX_PROGRESS;
        this.myTraceDestination.append("\n[Success, Failed, Error] : [" + nSuccess + ", " + failedRuns.size() + ", " + errorRuns.size() + "]\n");
        if (errorRuns.size() > 0) {
            this.myTraceDestination.append("Error run:\n");
            for (i = 0; i < errorRuns.size(); ++i) {
                this.myTraceDestination.append((String)errorRuns.get(i) + "\n");
            }
        }
        if (failedRuns.size() > 0) {
            this.myTraceDestination.append("Failed run:\n");
            for (i = 0; i < failedRuns.size(); ++i) {
                this.myTraceDestination.append((String)failedRuns.get(i) + "\n");
            }
        }
    }

    private void initMenuAndToolbar() {
        int i;
        for (i = 0; i < this.myActions.length; ++i) {
            JMenuItem newMenuItem = new JMenuItem(this.myActions[i]);
            String txt = newMenuItem.getText();
            if (txt != null && txt.length() > 0) {
                newMenuItem.setIcon(null);
            }
            this.myPopupMenu.add(newMenuItem);
        }
        for (i = 0; i < this.myActions.length; ++i) {
            JButton newButton = new JButton(this.myActions[i]);
            Icon icon = newButton.getIcon();
            if (icon != null) {
                newButton.setText(null);
            }
            this.myToolbar.add(newButton);
        }
        this.isTerse = new JCheckBox("Summary");
        this.myToolbar.add(this.isTerse);
    }

    @Override
    public boolean isModified() {
        for (int ii = 0; ii < this.myRatingDataTabs.getTabCount(); ++ii) {
            Component comp = this.myRatingDataTabs.getComponentAt(ii);
            if (!(comp instanceof RatingDataPanel) || !((RatingDataPanel)comp).isModified()) continue;
            return true;
        }
        return false;
    }

    public void resetModified() {
        for (int ii = 0; ii < this.myRatingDataTabs.getTabCount(); ++ii) {
            Component comp = this.myRatingDataTabs.getComponentAt(ii);
            if (!(comp instanceof RatingDataPanel)) continue;
            ((RatingDataPanel)comp).resetModified();
        }
    }

    @Override
    public void focusGained() {
    }

    @Override
    public SimulationFactory getSimulationFactory() {
        return null;
    }

    class TabTitleAdapter
    implements PropertyChangeListener {
        TabTitleAdapter() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            Object src = e.getSource();
            String name = e.getPropertyName();
            String newVal = (String)e.getNewValue();
            if (src instanceof RatingDataPanel) {
                RatingDataPanel p = (RatingDataPanel)src;
                int i = SimulatorPanel.this.myRatingDataTabs.indexOfComponent(p);
                if (i >= 0) {
                    if ("Description".equals(name)) {
                        SimulatorPanel.this.myRatingDataTabs.setTitleAt(i, newVal);
                    }
                } else {
                    System.err.println("Listened-to-RatingDataPanel is not found amongst tabs! - CODING ERROR");
                }
            } else {
                System.err.println("SimulatorPanel.propertyChange - not listening to RatingDataPanel - CODING ERROR");
            }
        }
    }

    class PopupAdapter
    extends MouseAdapter {
        PopupAdapter() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                SimulatorPanel.this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

