/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.simulation;

import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.gui.interfaces.RatingResultEvaluator;
import ericsson.ere.gui.simulation.RatingDataPanel;
import ericsson.ere.interfaces.XMLInitializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTextArea;
import org.w3c.dom.Node;

public class RatingDataValidator
implements XMLInitializable,
RatingResultEvaluator {
    public static final double EPSILON = 1.0E-9;

    @Override
    public XMLInitializable init(Node node) throws Exception {
        return this;
    }

    @Override
    public boolean check(RatingData theData, Map expected, JTextArea trace) throws Exception {
        boolean isValid = true;
        Iterator keys = expected.keySet().iterator();
        trace.append("\n");
        while (keys.hasNext()) {
            Number exp;
            String key;
            Object next = keys.next();
            String string = key = next != null ? next.toString() : null;
            if (RatingDataPanel.TAG_EXPECTED_DURATION.equals(key)) {
                exp = (Long)expected.get(key);
                if (exp != null) {
                    if ((Long)exp == theData.currentDuration) continue;
                    trace.append("Duration mismatch: Calculated: " + theData.currentDuration + " seconds, but expected: " + exp + "\n");
                    isValid = false;
                    continue;
                }
                trace.append("Expected duration missing, nothing to compare with.\n");
                isValid = false;
                continue;
            }
            if (RatingDataPanel.TAG_EXPECTED_COST.equals(key)) {
                exp = (Double)expected.get(key);
                if (exp != null) {
                    if (!(Math.abs((Double)exp - theData.totalCost) > 1.0E-9)) continue;
                    trace.append("Cost mismatch: Calculated total: " + theData.totalCost + " but expected: " + exp + "\n");
                    isValid = false;
                    continue;
                }
                trace.append("Expected cost missing, nothing to compare with.\n");
                isValid = false;
                continue;
            }
            if (theData.containsKey(key)) {
                RatingDataField dataField = theData.getRatingDataFieldByName(key);
                RatingDataField expField = (RatingDataField)expected.get(key);
                Object[] data = dataField.getObjectArray();
                Object[] exp2 = expField.getObjectArray();
                if (data == null) {
                    if (exp2 == null) continue;
                    trace.append("Field value missing: \"" + key + "\". Expected value: \"" + this.arrayToString(exp2) + "\"\n");
                    isValid = false;
                    continue;
                }
                if (Arrays.equals(data, exp2)) continue;
                trace.append("Result mismatch: \"" + key + "\" has value \"" + this.arrayToString(data) + "\". Expected value: \"" + this.arrayToString(exp2) + "\"\n");
                isValid = false;
                continue;
            }
            trace.append("Field missing: \"" + key + "\".\n");
            isValid = false;
        }
        trace.append("\n");
        return isValid;
    }

    private String arrayToString(Object[] arr) {
        if (arr == null || arr.length == 0) {
            return "";
        }
        if (arr.length == 1) {
            if (arr[0] == null) {
                return "null";
            }
            return arr[0].toString();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[");
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                buf.append(";");
            }
            if (arr[i] == null) {
                buf.append("null");
                continue;
            }
            buf.append(arr[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

