/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.charging.common.dataitem.DataItem;
import com.ericsson.ere.exception.UncheckedInterruptedException;
import com.ericsson.ere.gui.undoredo.DeleteNodeEdit;
import com.ericsson.ere.gui.undoredo.EditNodeEdit;
import com.ericsson.ere.gui.undoredo.QueryableCompoundEdit;
import com.ericsson.ere.gui.undoredo.UndoVetoController;
import com.ericsson.ere.gui.undoredo.UndoableTree;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.interfaces.DynamicClassProfile;
import com.ericsson.ere.interfaces.NamedClassProfile;
import com.ericsson.ere.interfaces.ProfileVariableQueryListener;
import com.ericsson.ere.selectiontree.conditions.ErrorConditionProfile;
import com.ericsson.ere.selectiontree.modifiers.ErrorModifierProfile;
import com.ericsson.ere.swing.EDT;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.DefaultRMAObjectCloner;
import com.ericsson.ere.util.ObjectCloner;
import com.ericsson.ere.util.Predicate;
import com.ericsson.ere.util.Predicates;
import com.ericsson.vareditor.document.LimitLeadingAndTrailingSpacesStringDocument;
import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.ContextAwareValidator;
import ericsson.ere.gui.ratingrules.nodes.DOMUtil;
import ericsson.ere.gui.ratingrules.nodes.DevNullWriter;
import ericsson.ere.gui.ratingrules.nodes.TDFChangeEvent;
import ericsson.ere.gui.ratingrules.nodes.TSElementHelper;
import ericsson.ere.gui.ratingrules.nodes.TSElementProductTagSupport;
import ericsson.ere.gui.ratingrules.nodes.TSNotificationReceiver;
import ericsson.ere.gui.ratingrules.nodes.TSState;
import ericsson.ere.gui.ratingrules.nodes.TSTariffStructure;
import ericsson.ere.gui.ratingrules.nodes.TSTreeElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.ratingrules.nodes.TreeBuilderAssistant;
import ericsson.ere.gui.ratingrules.nodes.ValidityCache;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.ClassProfileV2;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.leaf.AbstractModifierProfile;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldUser;
import ericsson.vareditor.variable.treedefinedfields.TreeDefinedFieldUser2;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class TSElement
extends TariffDAGNode
implements DataItem,
TreeDefinedFieldUser,
TSTreeElement,
TSNotificationReceiver {
    private static final boolean TEMPORARY = true;
    private static final boolean PERMANENT = false;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Predicate<Variable> NOT_NULL_VARIABLE = Predicates.notNull();
    protected ValidityCache<TSElement> myChildValidCache = new ValidityCache();
    private final TSState myState = new TSState();
    private String[] myTDFsUsedCache;
    private ClassProfile myProfile;
    private boolean myIsModified = false;
    private PropertyChangeSupport myChangeListeners;
    private boolean myIsInvalid = false;
    private String myCachedDescription;
    private String myCachedAdditionalInfo;
    private Boolean myCachedProfileValidationResult;
    private final Map<String, Object> myOldValueCache = new HashMap<String, Object>();
    private boolean myPreviousContextValidState = true;
    private TSElementProductTagSupport myProductTagSupport;
    private static ObjectCloner myCloner = new DefaultRMAObjectCloner();
    private VarTableModel myTableModel = null;
    private WeakReference<List<Variable>> myTemporaryVariables;
    private boolean myIgnoreDataItemEvents = false;

    public TSElement(ClassRepository rep) {
        super(rep);
    }

    public String toString() {
        String nodeName = this.getNodeName();
        return nodeName.trim().equals("") ? "[" + this.getNodeId() + "]" : nodeName;
    }

    protected abstract Variable createNameVariable(Node var1, String var2);

    protected abstract boolean shouldUseCommentParameter();

    protected abstract boolean isTypeChangingReference(String var1);

    protected abstract void initForNewElement(String var1, String var2) throws Exception;

    protected abstract void initForLoadedElement(Node var1, boolean var2) throws Exception;

    protected String getDefaultId() {
        return "";
    }

    protected boolean usesProfile() {
        return true;
    }

    protected String extractNameFromXml(Node xml) {
        return XMLUtil.getFirstTextContent(xml);
    }

    protected String extractCommentFromXml(Node xml) {
        Element n;
        String comment = null;
        if (xml != null && (n = XMLUtil.getNamedElement("Comment", xml.getChildNodes())) != null) {
            comment = XMLUtil.getFirstTextContent(n);
        }
        return comment;
    }

    protected String extractIdFromXml(Node xml) {
        String id = this.getDefaultId();
        Element exml = (Element)xml;
        if (exml.hasAttribute("id")) {
            id = exml.getAttribute("id");
        }
        return id;
    }

    protected final void unregisterAndClearVariables() {
        this.unregisterVariables(this.getOrCreateStateVariables(), true);
        this.myState.clearVariables();
    }

    protected final void clearTemporaryVariableList() {
        if (this.myTemporaryVariables != null) {
            this.myTemporaryVariables.clear();
        }
    }

    protected void setDataItemImpl(Object reference, Variable var, CompoundEdit cedit) {
    }

    public void init(String name) throws Exception {
        this.init(name, name);
    }

    public final void init(String name, String type) throws Exception {
        boolean typesAreDifferent;
        String oldType = this.getTypename();
        boolean isFirstTimeInit = oldType == null;
        boolean bl = typesAreDifferent = !type.equals(oldType);
        if (isFirstTimeInit || typesAreDifferent) {
            this.setModified();
            this.setTypename(type);
            this.myState.name = name;
            this.myProfile = null;
            this.initForNewElement(name, type);
            assert (this.myProfile != null || !this.usesProfile()) : "Profile wasn't created in " + this.getClass().getName() + ".newInitImpl.";
            if (!isFirstTimeInit) {
                this.createNewStateVariables();
                this.clearCachedDescriptionAndInfo();
                this.triggerTreeUpdate(false);
            }
        }
    }

    @Override
    public void setTreeModel(TariffDAGModel model) {
        boolean newModelIsDifferent;
        TariffDAGModel oldModel = this.getTreeModel();
        boolean bl = newModelIsDifferent = model != oldModel;
        if (oldModel != null && newModelIsDifferent) {
            throw new IllegalStateException("This element already has a model.");
        }
        super.setTreeModel(model);
        if (newModelIsDifferent && !this.isInLightState()) {
            this.myProductTagSupport = new TSElementProductTagSupport(this, this.myClassRep, model);
            this.registerAsTDFUserIfNecessary();
        }
        this.provideTariffStructureNodeToProfileIfPossible();
        if (newModelIsDifferent && !this.isInLightState()) {
            this.initializeProfile();
        }
    }

    private void initializeProfile() {
        this.getOrCreateStateVariablesTemporarily();
    }

    @Override
    public final XMLInitializable init(Node elementNode, boolean fullInit) throws Exception {
        if (this.myState.hasVariables()) {
            this.unregisterAndClearVariables();
        }
        this.myState.setInitData(elementNode);
        this.myState.name = this.extractNameFromXml(elementNode);
        this.myState.id = this.extractIdFromXml(elementNode);
        this.myProfile = null;
        this.initForLoadedElement(elementNode, fullInit);
        assert (this.myProfile != null || !this.usesProfile()) : "Profile wasn't created in " + this.getClass().getName() + ".loadInitImpl.";
        this.clearCachedDescriptionAndInfo();
        return this;
    }

    protected void createProfile(String name, String profileClass) throws ClassNotFoundException {
        try {
            this.myProfile = (ClassProfile)EreClassLoader.createInstance(profileClass);
            this.provideNameToProfileIfNecessary(name);
            this.provideClassRepositoryToProfileIfNecessary();
            this.provideTariffStructureNodeToProfileIfPossible();
        }
        catch (ClassNotFoundException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to create the profile from class " + profileClass, ex);
        }
    }

    private void provideTariffStructureNodeToProfileIfPossible() {
        TariffDAGModel model = this.getTreeModel();
        if (model != null && this.myProfile != null) {
            this.myProfile.setTariffStructureNode((DAGNode)model.getRoot());
        }
    }

    private void provideNameToProfileIfNecessary(String name) {
        if (this.myProfile instanceof NamedClassProfile) {
            ((NamedClassProfile)((Object)this.myProfile)).setName(name);
        }
    }

    private void provideClassRepositoryToProfileIfNecessary() {
        this.myProfile.setClassRepository(this.myClassRep);
    }

    private void clearCachedDescriptionAndInfo() {
        this.myCachedAdditionalInfo = null;
        this.myCachedDescription = null;
    }

    @Override
    public final void print(PrintWriter out, int indentLevel, String indentMarker) {
        this.print(out, indentLevel, indentMarker, true);
    }

    protected final void print(PrintWriter out, int indentLevel, String indentMarker, boolean visitChildren) {
        if (!this.usesProfile()) {
            this.noProfilePrint(out, indentLevel, indentMarker);
            return;
        }
        if (this.myState.isConfiguredByXML()) {
            ClassProfile profile = this.getClassProfile();
            ClassProfileV2 prof = null;
            if (profile instanceof ClassProfileV2) {
                prof = (ClassProfileV2)profile;
            }
            Node config = this.myState.getXMLConfig();
            if (prof != null && prof.handlesCachedPrint(config)) {
                prof.cachedPrint(out, indentLevel, indentMarker, this, config);
            } else {
                DOMUtil.cachedPrint(this, config, out, indentLevel, indentMarker);
            }
        } else {
            ClassProfile profile = this.getClassProfile();
            List<Variable> vars = this.getOrCreateStateVariablesTemporarily();
            profile.printPreamble(out, indentLevel, indentMarker, vars);
            profile.printParameters(out, indentLevel, indentMarker, vars);
            this.printCustom(out, indentLevel, indentMarker);
            if (visitChildren) {
                int len = this.getChildCount();
                for (int i = 0; i < len; ++i) {
                    TariffDAGNode child = (TariffDAGNode)this.getChildAt(i);
                    child.print(out, indentLevel + 1, indentMarker);
                }
            }
            profile.printPostamble(out, indentLevel, indentMarker, vars);
        }
    }

    protected void noProfilePrint(PrintWriter out, int indentLevel, String indentMarker) {
    }

    protected void printCustom(PrintWriter out, int indentLevel, String indentMarker) {
    }

    @Override
    public String getDescription() {
        if (this.myCachedDescription == null) {
            String description = null;
            ClassProfile profile = this.getClassProfile();
            String idString = this.getId();
            if (idString != null) {
                idString = idString.trim();
            }
            if (profile != null) {
                if (!this.myState.hasVariables()) {
                    description = profile.getDescription();
                }
                if (description == null) {
                    List<Variable> vars = this.getOrCreateStateVariablesTemporarily();
                    description = profile.getDescription(vars);
                }
            }
            if (description != null) {
                description = this.replaceNameWithAlias(description);
            } else {
                String string = description = this.hasAlias() ? this.getAlias() : this.getName();
            }
            if (TSElementHelper.hasText(idString) && TSElementHelper.areDifferent(description, idString)) {
                description = description.trim().equals("") ? description + "[" + idString + "]" : description + " [" + idString + "]";
            }
            this.myCachedDescription = description;
        }
        return this.myCachedDescription;
    }

    @Override
    public String getAdditionalInfo() {
        if (this.myCachedAdditionalInfo == null) {
            String addInfo = null;
            ClassProfile profile = this.getClassProfile();
            String productTag = null;
            boolean readProductTagFromXML = true;
            if (profile != null) {
                if (!this.myState.hasVariables()) {
                    addInfo = profile.getAdditionalInfo();
                }
                if (addInfo == null) {
                    List<Variable> vars = this.getOrCreateStateVariablesTemporarily();
                    addInfo = profile.getAdditionalInfo(vars);
                    Variable tagVar = TSElementProductTagSupport.getProductTagVariable(vars);
                    if (tagVar != null) {
                        productTag = tagVar.getValueString();
                    }
                    readProductTagFromXML = false;
                }
            }
            if (addInfo != null) {
                addInfo = this.replaceNameWithAlias(addInfo);
            } else {
                addInfo = this.hasAlias() ? this.getAlias() : this.getName();
                String comment = this.getComment();
                if (comment != null && this.shouldUseCommentParameter()) {
                    addInfo = addInfo + "\n" + comment;
                }
            }
            if (readProductTagFromXML) {
                productTag = this.myProductTagSupport.extractProductTagFromXML();
            }
            if (productTag != null) {
                addInfo = this.myProductTagSupport.insertProductTagInAdditionalInfo(addInfo, productTag);
            }
            this.myCachedAdditionalInfo = addInfo;
        }
        return this.myCachedAdditionalInfo;
    }

    private String replaceNameWithAlias(String str) {
        String ret = str;
        if (this.hasAlias()) {
            ret = ret.replaceAll("\\b" + this.getName() + "\\b", this.getAlias());
        }
        return ret;
    }

    public String getComment() {
        String comment = null;
        comment = this.myState.isConfiguredByXML() ? this.getCommentFromXml(this.myState.getXMLConfig()) : this.getCommentFromVariables();
        return comment;
    }

    private String getCommentFromVariables() {
        String comment = this.getVariableValueForKey("Comment");
        if (comment != null) {
            comment = XMLUtil.unEscape(comment);
        }
        return comment;
    }

    private String getCommentFromXml(Node xml) {
        String comment = this.extractCommentFromXml(xml);
        if (comment != null) {
            comment = XMLUtil.unEscape(comment);
        }
        return comment;
    }

    private String getVariableValueForKey(String key) {
        List<Variable> vars = this.getOrCreateStateVariables();
        Variable var = VarListUtil.getVariableForKey(vars, key);
        return var.getValueString();
    }

    private void setVariableValueForKey(String key, String value) {
        List<Variable> vars = this.getOrCreateStateVariables();
        Variable var = VarListUtil.getVariableForKey(vars, key);
        var.setValue(value);
    }

    protected void setComment(String comment) {
        this.setVariableValueForKey("Comment", comment);
    }

    protected String getName() {
        String name = "";
        if (this.myState.hasVariables()) {
            name = this.getVariableValueForKey("Name");
        } else if (this.myState.name != null) {
            name = this.myState.name;
        } else if (this.myState.hasXMLConfig()) {
            name = this.extractNameFromXml(this.myState.getXMLConfig());
        }
        return name;
    }

    protected void setName(String name) {
        this.setVariableValueForKey("Name", name);
    }

    protected String getId() {
        String id = null;
        if (this.myState.hasVariables()) {
            id = this.getVariableValueForKey("Id");
        } else if (this.myState.id != null) {
            id = this.myState.id;
        } else if (this.myState.hasXMLConfig()) {
            id = this.extractIdFromXml(this.myState.getXMLConfig());
        }
        return id != null ? id : this.getDefaultId();
    }

    protected void setId(String id) {
        this.setVariableValueForKey("Id", id);
    }

    protected String getAlias() {
        return this.myState.alias;
    }

    protected boolean hasAlias() {
        return this.myState.alias != null && this.myState.alias.trim().length() > 0;
    }

    protected void setAlias(String alias) {
        this.myState.alias = alias;
    }

    @Override
    public String getNodeName() {
        return this.getName();
    }

    @Override
    public String getNodeId() {
        String id = this.getId().trim();
        if ("".equals(id)) {
            id = this.hasAlias() ? this.getAlias() : this.getName();
        }
        id = id.replace('/', '\\');
        return id;
    }

    public String getProductTag() {
        String tag = null;
        if (this.state().isConfiguredByXML()) {
            tag = this.myProductTagSupport.extractProductTagFromXML();
        } else {
            List<Variable> vars = this.getOrCreateStateVariables();
            Variable var = TSElementProductTagSupport.getProductTagVariable(vars);
            if (var != null) {
                tag = var.toString();
            }
        }
        return tag;
    }

    @Override
    public final List<Variable> getVariablesForEditing(VarTableModel model) {
        if (model != null) {
            this.myTableModel = model;
        }
        boolean wasInvalid = this.isInvalid();
        List<Variable> vars = this.getOrCreateStateVariables();
        boolean isInvalid = this.isInvalid();
        if (wasInvalid != isInvalid) {
            this.triggerTreeUpdate(true);
        }
        return vars;
    }

    @Override
    public void editingFinished(List<Variable> vars, boolean isDeletion) {
        this.unregisterVariables(vars, isDeletion);
        this.myTableModel = null;
    }

    public void updateGui() {
        if (this.myTableModel != null) {
            this.unregisterVariables(this.myTableModel.getData(), false);
            this.myTableModel.setData(new ArrayList<Variable>(this.getOrCreateStateVariables()));
        } else {
            this.getOrCreateStateVariables();
        }
    }

    private void createNewStateVariables() {
        this.unregisterAndClearVariables();
        TSElementHelper.removeDOMFromParent(this);
        this.myState.clearXMLConfig();
        this.getOrCreateStateVariables();
    }

    protected final List<Variable> getOrCreateStateVariables() {
        List<Variable> vars = this.getOrCreateStateVariablesImpl(false);
        this.registerVariables(vars);
        return vars;
    }

    protected final List<Variable> getOrCreateStateVariablesTemporarily() {
        return this.getOrCreateStateVariablesImpl(true);
    }

    private List<Variable> getOrCreateStateVariablesImpl(boolean isTemporaryRequest) {
        List<Variable> vars;
        boolean needToUpdateVariables;
        boolean isPermanentRequest = !isTemporaryRequest;
        boolean bl = needToUpdateVariables = !this.myState.hasVariables();
        if (needToUpdateVariables) {
            vars = this.getTemporaryVariablesIfSet();
            if (vars == null || isPermanentRequest) {
                if (vars != null) {
                    this.clearTemporaryVariableList();
                    this.notifyProfileOfVariableQuery(vars);
                } else {
                    vars = this.getUpdatedVariableList(this.myState.getXMLConfig());
                }
                if (isPermanentRequest) {
                    this.setStateVariables(vars);
                    vars = this.myState.stateVariables();
                } else {
                    vars = new ArrayList<Variable>(vars);
                    this.myTemporaryVariables = new WeakReference<List<Variable>>(vars);
                }
            }
        } else {
            vars = this.myState.stateVariables();
            this.notifyProfileOfVariableQuery(vars);
        }
        return vars;
    }

    private boolean updateProductTagVariablePresence(List<Variable> vars) {
        if (this.myProductTagSupport != null) {
            return this.myProductTagSupport.updateProductTagVariablePresence(vars);
        }
        return false;
    }

    private void notifyProfileOfVariableQuery(List<Variable> vars) {
        if (this.myProfile instanceof ProfileVariableQueryListener) {
            try {
                this.myIgnoreDataItemEvents = true;
                ((ProfileVariableQueryListener)((Object)this.myProfile)).variablesQueried(Collections.unmodifiableList(vars));
            }
            finally {
                this.myIgnoreDataItemEvents = false;
            }
        }
    }

    private List<Variable> getTemporaryVariablesIfSet() {
        List vars = null;
        if (this.myTemporaryVariables != null) {
            vars = (List)this.myTemporaryVariables.get();
        }
        return vars;
    }

    @Override
    public final Object getDataItem(Object reference) {
        return null;
    }

    @Override
    public final Object getDataItem() {
        return null;
    }

    @Override
    public final void setDataItem(Object object) {
    }

    @Override
    public final void setDataItem(Object key, Object variable) {
        this.handleVariableChange(key, (Variable)variable);
    }

    protected final boolean isUndoSupported() {
        TariffDAGModel model = this.getTreeModel();
        return model != null && model.getOwnerTree() instanceof UndoableTree;
    }

    private void handleVariableChange(Object key, Variable var) {
        boolean wasInvalid;
        boolean bl = wasInvalid = this.isInvalid() || !this.wasContextValid();
        if (this.shouldIgnoreChangeEvent(var, wasInvalid)) {
            return;
        }
        this.setModified();
        this.clearCachedDescriptionAndInfo();
        QueryableCompoundEdit cedit = null;
        if (this.isUndoSupported()) {
            cedit = this.handleUndo(var);
        }
        if (!var.isValueValid()) {
            this.setInvalid(true);
        } else if ("__PROD_TAG".equals(key)) {
            this.clearCachedDescriptionAndInfo();
        } else if (this.isTypeChangingReference(String.valueOf(key))) {
            this.changeType(var.getValueString(), cedit);
        } else {
            List<Variable> vars = this.state().stateVariables();
            if (this.parameterChangedImpl(var.getLabel(), var, vars)) {
                if (this.updateProductTagVariablePresence(vars)) {
                    this.clearCachedDescriptionAndInfo();
                }
                this.updateGui();
                this.syncOldValueCache(vars);
            }
            this.updateInvalidStatus();
            this.firePropertyChange(key.toString(), null, var);
        }
        this.setDataItemImpl(key, var, cedit);
        if (cedit != null) {
            cedit.end();
            UndoableEdit ue = this.getActualEditToUse(cedit);
            this.addEditToUndoManager(ue);
        }
        boolean isInvalidNow = this.isInvalid() || !this.isContextValid();
        this.triggerTreeUpdate(wasInvalid != isInvalidNow);
    }

    private boolean shouldIgnoreChangeEvent(Variable var, boolean wasInvalid) {
        boolean variableMayChangeTSElementInvalidState;
        if (this.myIgnoreDataItemEvents) {
            return true;
        }
        boolean wasValid = !wasInvalid;
        boolean variableValueIsSameAsBefore = !this.variableValueHasChanged(var);
        boolean bl = variableMayChangeTSElementInvalidState = wasValid != var.isValueValid();
        if (variableMayChangeTSElementInvalidState) {
            return false;
        }
        return variableValueIsSameAsBefore;
    }

    private boolean variableValueHasChanged(Variable var) {
        boolean changed = true;
        if (this.isUndoSupported()) {
            changed = !this.valueObjectsEqual(this.myOldValueCache.get(var.getKey()), var.getValueObject());
        }
        return changed;
    }

    private boolean valueObjectsEqual(Object o1, Object o2) {
        boolean objectsAreEqual;
        if (o1 == o2) {
            objectsAreEqual = true;
        } else if (o1 == null || o2 == null) {
            objectsAreEqual = false;
        } else {
            try {
                objectsAreEqual = o1.equals(o2);
            }
            catch (Exception e) {
                objectsAreEqual = false;
            }
        }
        return objectsAreEqual;
    }

    private void addEditToUndoManager(UndoableEdit edit) {
        ((UndoableTree)((Object)this.getTreeModel().getOwnerTree())).getUndoManager().addEdit(edit);
    }

    private UndoableEdit getActualEditToUse(QueryableCompoundEdit cedit) {
        UndoableEdit ue = cedit;
        if (cedit.getEditCount() == 1) {
            ue = cedit.getEditAt(0);
        }
        return ue;
    }

    private QueryableCompoundEdit handleUndo(Variable var) {
        UndoableTree tree = (UndoableTree)((Object)this.myDAGModel.getOwnerTree());
        UndoVetoController uvc = tree.getUndoManager().getUndoVetoController();
        if (uvc != null && !uvc.supportUndoFor(var)) {
            if (uvc.discardUndoHistoryWhenChanged(var)) {
                tree.getUndoManager().discardAllEdits();
            }
            return null;
        }
        QueryableCompoundEdit cedit = null;
        this.setUndo(var);
        try {
            boolean hasOldValue;
            Object clone = DefaultRMAObjectCloner.cloneVariableValue(myCloner, var);
            if (!tree.getOngoingUndo() && clone != null && (hasOldValue = this.myOldValueCache.containsKey(var.getKey()))) {
                Object oldValue = this.myOldValueCache.get(var.getKey());
                EditNodeEdit edit = new EditNodeEdit(tree, this.myDAGModel.getPathToRoot(this), var.getKey(), oldValue, clone);
                cedit = new QueryableCompoundEdit();
                cedit.addEdit(edit);
            }
            this.myOldValueCache.put(var.getKey(), clone);
        }
        catch (Exception e) {
            ExceptionUtil.handleException(e, "ratingperiod", 1, "Failed to register undo/redo information.", false);
            cedit = null;
        }
        return cedit;
    }

    private boolean parameterChangedImpl(String reference, Variable value, List<Variable> variables) {
        ClassProfile profile = this.getClassProfile();
        if (profile instanceof DynamicClassProfile) {
            return ((DynamicClassProfile)((Object)profile)).parameterChanged(reference, value, variables);
        }
        return false;
    }

    protected void changeType(String newType, CompoundEdit cedit) {
        this.setInvalid(false);
        boolean wasAllowingChildren = this.getClassProfile().getAllowsChildren();
        boolean allowsTypeChange = true;
        if (this.getTreeModel() != null) {
            int len = this.getChildCount();
            for (int i = 0; i < len; ++i) {
                if (this.getTreeModel().allowsDelete(DAGUtil.getCanonicalPath(this.getChildAt(i)))) continue;
                allowsTypeChange = false;
                break;
            }
        }
        if (!allowsTypeChange) {
            this.updateGui();
            DialogFactory.getErrorDialog(RmaDefs.getStringResource("ratingrules.errmsg.typeNotChanged.title"), RmaDefs.getStringResource("ratingrules.errmsg.typeNotChanged.msg"));
            return;
        }
        try {
            boolean wasTDFUser = this.isProfileTreeDefinedFieldUser();
            this.init(this.getName(), newType);
            this.updateTDFUsage(wasTDFUser, this.isProfileTreeDefinedFieldUser());
            this.updateGui();
            this.deleteDisallowedChildren(cedit, wasAllowingChildren);
        }
        catch (Exception x) {
            ExceptionUtil.handleException(x, "ratingperiod", 1, "Failed to change element type to " + newType + ".", true);
        }
    }

    private void updateTDFUsage(boolean wasTDFUser, boolean isTDFUser) {
        TariffDAGModel treeModel = this.getTreeModel();
        if (treeModel != null) {
            TSTariffStructure tariffStructure = (TSTariffStructure)treeModel.getRoot();
            if (wasTDFUser && !isTDFUser) {
                tariffStructure.removeTDFUser(this);
            } else if (!wasTDFUser && isTDFUser) {
                tariffStructure.addTDFUser(this);
            }
        }
    }

    private void deleteDisallowedChildren(CompoundEdit cedit, boolean wasAllowingChildren) {
        if (this.getTreeModel() != null && wasAllowingChildren) {
            boolean isAllowingChildren = this.getClassProfile().getAllowsChildren();
            for (int i = this.getChildCount(); i > 0; --i) {
                TariffDAGNode child = (TariffDAGNode)this.getChildAt(i - 1);
                if (isAllowingChildren && this.isChildAllowed(this.getClassProfile(), child)) continue;
                Object[] path = DAGUtil.getCanonicalPath(child);
                if (cedit != null) {
                    DeleteNodeEdit del = new DeleteNodeEdit((UndoableTree)((Object)this.myDAGModel.getOwnerTree()), path, i - 1);
                    cedit.addEdit(del);
                }
                this.getTreeModel().delete(path);
            }
        }
    }

    private boolean isChildAllowed(ClassProfile classProfile, TariffDAGNode node) {
        boolean result = true;
        if (!classProfile.getAllowsChildren()) {
            result = false;
        } else if (classProfile instanceof TreeBuilderAssistant) {
            TreeBuilderAssistant assistant = (TreeBuilderAssistant)((Object)classProfile);
            if (node.isLink()) {
                result = assistant.allowsAddLink(node);
            } else {
                switch (node.getNodeType()) {
                    case 1: {
                        result = assistant.allowsAddNode(node);
                        break;
                    }
                    case 2: {
                        result = assistant.allowsAddCondition(node);
                        break;
                    }
                    case 3: {
                        result = assistant.allowsAddModifier(node);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled node type: " + node.getNodeType()));
                    }
                }
            }
        }
        return result;
    }

    @Override
    public final void reset() {
        this.resetModified();
    }

    @Override
    public boolean isModified() {
        return this.myIsModified;
    }

    @Deprecated
    public boolean isStructureModified() {
        return this.recIsModified(this);
    }

    private boolean recIsModified(TariffDAGNode node) {
        if (node.isModified()) {
            return true;
        }
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            TariffDAGNode child = (TariffDAGNode)node.getChildAt(i);
            if (!this.recIsModified(child)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resetModified() {
        this.myIsModified = false;
    }

    @Override
    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.myChangeListeners == null) {
            this.myChangeListeners = new PropertyChangeSupport(this);
        }
        this.myChangeListeners.addPropertyChangeListener(listener);
    }

    @Override
    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.myChangeListeners.removePropertyChangeListener(listener);
        if (this.myChangeListeners.getPropertyChangeListeners().length == 0) {
            this.myChangeListeners = null;
        }
    }

    protected void firePropertyChange(String prop, Variable old, Variable _new) {
        if (this.myChangeListeners != null) {
            this.myChangeListeners.firePropertyChange(prop, old, _new);
        }
    }

    protected final void setModified() {
        this.myIsModified = true;
    }

    public ClassProfile getClassProfile() {
        return this.myProfile;
    }

    public boolean isProfileTreeDefinedFieldUser() {
        return this.profileImplementsOrExtends(TreeDefinedFieldUser.class) || this.profileImplementsOrExtends(TreeDefinedFieldUser2.class);
    }

    public boolean profileImplementsOrExtends(Class<?> clazz) {
        return this.myProfile != null && clazz.isInstance(this.myProfile);
    }

    @Override
    public String[] getTreeDefinedFieldInUse() {
        return this.privGetTreeDefinedFieldsInUse(null);
    }

    private String[] privGetTreeDefinedFieldsInUse(List<Variable> stateVariables) {
        String[] fields = null;
        if (this.isProfileTreeDefinedFieldUser()) {
            if (stateVariables != null || this.myState.hasVariables()) {
                List<Variable> vars = stateVariables != null ? stateVariables : this.getOrCreateStateVariables();
                ClassProfile profile = this.getClassProfile();
                if (profile instanceof TreeDefinedFieldUser2) {
                    fields = ((TreeDefinedFieldUser2)((Object)profile)).getTreeDefinedFieldInUse(vars);
                } else {
                    profile.printParameters(new PrintWriter(new DevNullWriter()), 0, "", vars);
                    fields = ((TreeDefinedFieldUser)((Object)profile)).getTreeDefinedFieldInUse();
                }
                this.myTDFsUsedCache = null;
            } else if (this.myTDFsUsedCache != null) {
                fields = this.myTDFsUsedCache;
            } else {
                List<Variable> vars = this.getOrCreateStateVariablesTemporarily();
                fields = this.privGetTreeDefinedFieldsInUse(vars);
                if (fields == null) {
                    fields = EMPTY_STRING_ARRAY;
                }
                this.myTDFsUsedCache = fields;
            }
        }
        return this.tidyTDFArray(fields);
    }

    private String[] tidyTDFArray(String[] tdfs) {
        if (tdfs == null) {
            return null;
        }
        String[] temp = new String[tdfs.length];
        int idx = 0;
        for (int i = 0; i < tdfs.length; ++i) {
            String tdf = tdfs[i];
            if (tdf == null) continue;
            temp[idx++] = tdf;
        }
        return idx == 0 ? null : Arrays.copyOf(temp, idx);
    }

    @Override
    public String getProfileClass() {
        if (this.myProfile != null) {
            return this.myProfile.getClass().toString();
        }
        return this.getClass().toString();
    }

    protected boolean isInvalid() {
        return this.myIsInvalid || this.myChildValidCache.containsAnyInvalid();
    }

    private boolean hasInvalidChild() {
        return this.myChildValidCache.containsAnyInvalid();
    }

    protected void setInvalid(boolean flag) {
        if (flag != this.myIsInvalid) {
            this.myIsInvalid = flag;
            this.notifyParentAndReferersAboutValidStatusChange(!flag);
        }
    }

    @Override
    public final boolean isNodeValid() {
        return this.internalIsNodeValid(false);
    }

    protected boolean internalIsNodeValid(boolean invokedByParent) {
        if (Thread.currentThread().isInterrupted()) {
            throw new UncheckedInterruptedException("Interrupted");
        }
        boolean valid = true;
        if (this.isInvalid() || this.hasInvalidChild()) {
            valid = false;
        }
        if (valid) {
            valid = this.isContextValid();
        }
        if (valid && this.shouldQueryProfileValidStatus()) {
            valid = this.getProfileValidStatus();
        }
        if (valid) {
            valid = this.checkChildrenValidity();
        }
        if (!invokedByParent) {
            this.notifyParentAndReferersAboutValidStatusChange(valid);
        }
        return valid;
    }

    private boolean shouldQueryProfileValidStatus() {
        return this.usesProfile() && !this.state().hasVariables();
    }

    private boolean getProfileValidStatus() {
        boolean valid;
        if (this.myCachedProfileValidationResult != null) {
            valid = this.myCachedProfileValidationResult;
        } else {
            valid = this.validateViaProfile();
            this.myCachedProfileValidationResult = valid;
        }
        return valid;
    }

    private boolean wasContextValid() {
        return this.myPreviousContextValidState;
    }

    private boolean isContextValid() {
        boolean valid = true;
        if (this.profileImplementsOrExtends(ContextAwareValidator.class)) {
            valid = ((ContextAwareValidator)((Object)this.getClassProfile())).validateContext(this);
        }
        this.myPreviousContextValidState = valid;
        return valid;
    }

    private boolean validateViaProfile() {
        List<Variable> vars = this.getOrCreateStateVariablesTemporarily();
        boolean valid = VarListUtil.areAllValid(vars);
        return valid;
    }

    protected boolean checkChildrenValidity() {
        boolean valid = true;
        int len = this.getChildCount();
        for (int i = 0; valid && i < len; ++i) {
            TSElement child = (TSElement)this.getChildAt(i);
            if (this.myChildValidCache.contains(child)) {
                valid = this.myChildValidCache.isValid(child);
                continue;
            }
            valid = child.internalIsNodeValid(true);
            this.myChildValidCache.put(child, valid);
        }
        return valid;
    }

    protected void childChangedValidStatus(TSElement child, Boolean valid) {
        boolean othersAreValid;
        if (this.knowsAboutStatusAlready(child, valid)) {
            return;
        }
        boolean bl = othersAreValid = !this.myChildValidCache.containsInvalidBesides(child);
        if (valid != null) {
            this.myChildValidCache.put(child, valid);
        } else {
            this.myChildValidCache.remove(child);
        }
        if (valid == null) {
            this.notifyParentAndReferersAboutValidStatusChange(null);
        } else if (othersAreValid) {
            if (!valid.booleanValue()) {
                this.notifyParentAndReferersAboutValidStatusChange(false);
            } else {
                this.notifyParentAndReferersAboutValidStatusChange(null);
            }
        }
    }

    private boolean knowsAboutStatusAlready(TSElement child, Boolean valid) {
        boolean hasChildInCache = this.myChildValidCache.contains(child);
        if (hasChildInCache) {
            return valid != null && this.myChildValidCache.isValid(child) == valid.booleanValue();
        }
        return valid == null;
    }

    protected void notifyParentAndReferersAboutValidStatusChange(Boolean valid) {
        DAGNode parent = this.getParent();
        DAGNode[] referers = this.getReferers();
        if (parent != null) {
            ((TSElement)parent).childChangedValidStatus(this, valid);
        }
        for (DAGNode ref : referers) {
            ((TSElement)ref).childChangedValidStatus(this, valid);
        }
    }

    protected void updateInvalidStatus() {
        boolean allValid = VarListUtil.areAllValid(this.myState.stateVariables());
        this.setInvalid(!allValid);
    }

    @Override
    public boolean allowsAddNode(TariffDAGNode treeNode) {
        return this.checkAllowsViaProfile(treeNode, new ProfileAllowsCheck(){

            @Override
            public boolean allows(TreeBuilderAssistant assistant, TariffDAGNode node) {
                return assistant.allowsAddNode(node);
            }
        }, this.defaultAllowsAddNode(treeNode));
    }

    @Override
    public boolean allowsAddCondition(TariffDAGNode treeNode) {
        return this.checkAllowsViaProfile(treeNode, new ProfileAllowsCheck(){

            @Override
            public boolean allows(TreeBuilderAssistant assistant, TariffDAGNode node) {
                return assistant.allowsAddCondition(node);
            }
        }, this.defaultAllowsAddCondition(treeNode));
    }

    @Override
    public boolean allowsAddModifier(TariffDAGNode treeNode) {
        return this.checkAllowsViaProfile(treeNode, new ProfileAllowsCheck(){

            @Override
            public boolean allows(TreeBuilderAssistant assistant, TariffDAGNode node) {
                return assistant.allowsAddModifier(node);
            }
        }, this.defaultAllowsAddModifier(treeNode));
    }

    @Override
    public boolean allowsAddLink(TariffDAGNode treeNode) {
        return this.checkAllowsViaProfile(treeNode, new ProfileAllowsCheck(){

            @Override
            public boolean allows(TreeBuilderAssistant assistant, TariffDAGNode node) {
                return assistant.allowsAddLink(node);
            }
        }, this.defaultAllowsAddLink(treeNode));
    }

    private boolean checkAllowsViaProfile(TariffDAGNode treeNode, ProfileAllowsCheck check, boolean defaultAllows) {
        block3: {
            try {
                if (this.profileImplementsOrExtends(TreeBuilderAssistant.class)) {
                    return check.allows((TreeBuilderAssistant)((Object)this.getClassProfile()), treeNode);
                }
            }
            catch (NullPointerException npe) {
                if (treeNode == null) break block3;
                throw npe;
            }
        }
        return defaultAllows;
    }

    protected abstract boolean defaultAllowsAddNode(TariffDAGNode var1);

    protected abstract boolean defaultAllowsAddCondition(TariffDAGNode var1);

    protected abstract boolean defaultAllowsAddModifier(TariffDAGNode var1);

    protected abstract boolean defaultAllowsAddLink(TariffDAGNode var1);

    @Override
    public boolean getAllowsChildren() {
        return this.getClassProfile().getAllowsChildren();
    }

    protected List<Variable> getUpdatedVariableList(Node iterator) {
        ArrayList<Variable> oldStateVariables = this.myState.hasVariables() ? this.myState.stateVariables() : new ArrayList();
        List<Variable> vars = this.getBaseVariables(iterator, oldStateVariables);
        ClassProfile profile = this.getClassProfile();
        if (profile != null) {
            List<Variable> profileVariables = null;
            try {
                profileVariables = iterator != null ? profile.getVariables(iterator) : profile.getVariables();
            }
            catch (RuntimeException e) {
                if (profile instanceof AbstractConditionProfile) {
                    this.myProfile = new ErrorConditionProfile(((AbstractConditionProfile)this.myProfile).getName(), e);
                } else if (profile instanceof AbstractModifierProfile) {
                    this.myProfile = new ErrorModifierProfile(((AbstractModifierProfile)this.myProfile).getName(), e);
                }
                if (!profile.equals(this.myProfile)) {
                    profileVariables = this.myProfile.getVariables();
                }
                throw e;
            }
            if (profileVariables != null) {
                vars.addAll(CollectionUtils.filter(profileVariables, NOT_NULL_VARIABLE));
                this.updateProductTagVariablePresence(vars);
            }
        }
        return vars;
    }

    private void setStateVariables(List<Variable> vars) {
        this.myState.setVariables(vars);
        this.postUpdateStateVariables();
    }

    protected void postUpdateStateVariables() {
        this.refreshOldValueCache();
        this.updateInvalidStatus();
    }

    private void refreshOldValueCache() {
        this.myOldValueCache.clear();
        this.syncOldValueCache(this.myState.stateVariables());
    }

    private void syncOldValueCache(List<Variable> vars) {
        for (Variable var : vars) {
            String key = var.getKey();
            boolean put = true;
            if (this.myOldValueCache.containsKey(key)) {
                put = this.variableValueHasChanged(var);
            }
            if (!put) continue;
            this.myOldValueCache.put(key, DefaultRMAObjectCloner.cloneVariableValue(myCloner, var));
        }
    }

    protected List<Variable> getBaseVariables(Node iterator, List<Variable> oldStateVariables) {
        Variable nameVar = null;
        Variable idVar = null;
        Variable commentVar = null;
        ArrayList<Variable> vars = new ArrayList<Variable>(12);
        if (oldStateVariables.size() > 0) {
            for (Variable v : oldStateVariables) {
                String key = v.getKey();
                if (key.equals("Name")) {
                    nameVar = v;
                    continue;
                }
                if (key.equals("Id")) {
                    idVar = v;
                    continue;
                }
                if (!key.equals("Comment")) continue;
                commentVar = v;
            }
        }
        if (nameVar == null) {
            nameVar = this.createNameVariable(null, this.getName().trim());
            nameVar.setKey("Name");
        }
        if (idVar == null) {
            String id = this.getId().trim();
            idVar = new StringVariable("Id", id, new LimitLeadingAndTrailingSpacesStringDocument(true));
            ((Variable)idVar).setKey("Id");
        }
        if (commentVar == null && this.shouldUseCommentParameter()) {
            String comment = this.getCommentFromXml(iterator);
            commentVar = new MultilineStringVariable("Comment", comment != null ? comment : "");
            ((Variable)commentVar).setKey("Comment");
        }
        vars.add(nameVar);
        vars.add(idVar);
        if (commentVar != null) {
            vars.add(commentVar);
        }
        return vars;
    }

    protected final void triggerTreeUpdate(boolean updatePathToRoot) {
        TariffDAGModel model = this.getTreeModel();
        if (model != null) {
            model.nodeChanged(this, updatePathToRoot);
        }
    }

    protected void unregisterVariables(List<Variable> vars, boolean isDeletion) {
        this.myIgnoreDataItemEvents = true;
        try {
            if (!isDeletion) {
                this.finishEditing(vars);
            }
            this.unregisterVariables(vars);
        }
        finally {
            this.myIgnoreDataItemEvents = false;
        }
    }

    private void finishEditing(final List<Variable> vars) {
        EDT.runAndWait(new Runnable(){

            @Override
            public void run() {
                for (Variable var : vars) {
                    var.editFinished();
                }
            }
        });
    }

    private void unregisterVariables(List<Variable> vars) {
        for (Variable var : vars) {
            var.setDataItem(null);
        }
    }

    protected void registerVariables(List<Variable> vars) {
        for (Variable var : vars) {
            var.setDataItem(this);
            var.setHelpId(this.getProfileClass());
        }
    }

    public TSState state() {
        return this.myState;
    }

    @Override
    public Map<String, Object> getParameters() {
        Map<String, Object> parameters = null;
        ClassProfile prof = this.getClassProfile();
        if (this.usesProfile() && prof instanceof ClassProfileV2) {
            boolean isInvalid;
            ClassProfileV2 profv2 = (ClassProfileV2)prof;
            boolean bl = isInvalid = !this.isNodeValid();
            if (this.state().isConfiguredByXML() || isInvalid) {
                parameters = profv2.getDisplayValues(this.state().getXMLConfig(), parameters);
            } else {
                List<Variable> vars = this.getOrCreateStateVariables();
                parameters = profv2.getDisplayValues(vars, parameters);
            }
            if (parameters != null) {
                parameters.put("Name", this.getNodeName());
                parameters.put("Id", this.getId());
                if (this.shouldUseCommentParameter()) {
                    parameters.put("Comment", this.getComment());
                }
            }
        }
        if (parameters == null) {
            List<Variable> vars = this.getOrCreateStateVariables();
            parameters = new HashMap<String, Object>();
            for (Variable v : vars) {
                parameters.put(v.getLabel(), v.getValueObject());
            }
        }
        return parameters;
    }

    @Override
    public String getTypename() {
        String name = this.getName();
        String tn = name != null && name.equals(this.myState.type) ? (this.hasAlias() ? this.getAlias() : name) : this.myState.type;
        return tn;
    }

    protected void setTypename(String type) {
        this.myState.type = type;
    }

    @Override
    public String getXMLConfig() {
        StringWriter sw = new StringWriter();
        this.print(new PrintWriter(sw), 0, "");
        return sw.toString();
    }

    private String getXMLConfigWithoutChildren() {
        StringWriter sw = new StringWriter();
        this.print(new PrintWriter(sw), 0, "", false);
        return sw.toString();
    }

    @Override
    public boolean isLazyInit() {
        return !this.myState.hasVariables();
    }

    private void resetValidation() {
        this.myCachedProfileValidationResult = null;
        if (this.myState.hasVariables()) {
            this.reconstructUninitializedState();
        } else {
            this.clearTemporaryVariableList();
        }
        this.setInvalid(false);
        this.triggerTreeUpdate(true);
    }

    protected boolean needUninitializedStateReconstruction() {
        return this.myState.shouldUseVariables() && this.isModified();
    }

    private boolean reconstructUninitializedState() {
        return this.reconstructUninitializedState(true);
    }

    private boolean reconstructUninitializedStateIfNecessary() {
        return this.reconstructUninitializedState(false);
    }

    protected boolean reconstructUninitializedState(boolean force) {
        boolean didRun = false;
        if (force || this.needUninitializedStateReconstruction()) {
            boolean clearVariables;
            didRun = true;
            boolean bl = clearVariables = this.myTableModel == null && this.myState.hasVariables();
            if (clearVariables) {
                this.unregisterVariables(this.myState.stateVariables(), false);
            }
            try {
                if (!this.isInvalid()) {
                    String xml = this.getXMLConfigWithoutChildren();
                    Node n = XMLUtil.buildDocumentFromString(xml).getDocumentElement();
                    n = TSElementHelper.adoptIntoDocumentOfElement(this, n);
                    TSElementHelper.replaceInitDataWith(this, n);
                    this.myState.name = null;
                    this.myState.id = null;
                } else {
                    this.myState.name = this.getName();
                    this.myState.id = this.getId();
                }
                if (clearVariables) {
                    this.myState.clearVariables();
                }
                this.myCachedProfileValidationResult = null;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to re-construct uninitialized state.", e);
            }
        }
        return didRun;
    }

    @Deprecated
    public void updateDOMStructure() {
        this.syncDOMStructure(true);
    }

    protected void syncDOMStructure(boolean recurse) {
        if (this.reconstructUninitializedStateIfNecessary()) {
            this.resetModified();
        }
        if (this.myState.hasXMLConfig() && !TSElementHelper.isRootOfModel(this)) {
            if (!TSElementHelper.isXMLConfigConnectedToParent(this)) {
                TSElementHelper.replaceInitDataWith(this, this.myState.getXMLConfig());
            } else {
                TSElementHelper.ensureXMLConfigPositionInParent(this);
            }
        }
        if (!this.isLink() && recurse) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                TSElement elem = (TSElement)this.getChildAt(i);
                elem.syncDOMStructure(true);
            }
        }
    }

    protected boolean isInLightState() {
        return false;
    }

    @Override
    public final void remove(DAGNode child) {
        this.detachChildDOMNode(child);
        boolean wasValid = this.isContextValid();
        super.remove(child);
        if (wasValid != this.isContextValid()) {
            this.triggerTreeUpdate(true);
        }
    }

    private void detachChildDOMNode(DAGNode child) {
        if (this.getIndexOfChild(child) >= 0) {
            TSElementHelper.removeDOMFromParent((TSElement)child);
        }
    }

    @Override
    public final void insertChildAt(int i, DAGNode node) {
        boolean wasValid = this.isContextValid();
        super.insertChildAt(i, node);
        if (wasValid != this.isContextValid()) {
            this.triggerTreeUpdate(true);
        }
    }

    @Override
    protected final void preRemove() {
        super.preRemove();
        this.performPreRemoveActions();
    }

    protected void performPreRemoveActions() {
        this.unregisterAsTDFUserIfNecessary();
        TSElement parent = (TSElement)this.getParent();
        if (parent != null) {
            parent.childChangedValidStatus(this, null);
        }
    }

    private void registerAsTDFUserIfNecessary() {
        TariffDAGModel model = this.getTreeModel();
        if (model != null && this.isProfileTreeDefinedFieldUser()) {
            ((TSTariffStructure)model.getRoot()).addTDFUser(this);
        }
    }

    private void unregisterAsTDFUserIfNecessary() {
        TariffDAGModel model = this.getTreeModel();
        if (model != null && this.isProfileTreeDefinedFieldUser()) {
            ((TSTariffStructure)model.getRoot()).removeTDFUser(this);
        }
    }

    @Override
    public void notifyTDFChange(TDFChangeEvent event) {
        if (this.myTemporaryVariables != null && this.myTemporaryVariables.get() != null || this.myState.hasVariables() || !this.isNodeValid()) {
            this.resetValidation();
        }
        this.clearCachedDescriptionAndInfo();
    }

    @Override
    public void notifyReinserted() {
        if (this.isProfileTreeDefinedFieldUser()) {
            this.registerAsTDFUserIfNecessary();
            this.resetValidation();
            this.clearCachedDescriptionAndInfo();
        }
        if (!this.isLink()) {
            int cc = this.getChildCount();
            for (int i = 0; i < cc; ++i) {
                TSElement child = (TSElement)this.getChildAt(i);
                child.notifyReinserted();
            }
        }
    }

    private static interface ProfileAllowsCheck {
        public boolean allows(TreeBuilderAssistant var1, TariffDAGNode var2);
    }
}

