/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.dataset.SelectionTreeQualifier;
import com.ericsson.ere.defs.STQRepositories;
import com.ericsson.ere.defs.STQRepository;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TSNode;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.ClassProfile;

public class STQReferenceCountPredicate
implements NodePredicate {
    static final long serialVersionUID = 1L;
    private final int myLeastNumberOfSTQReferences;

    public STQReferenceCountPredicate(int leastNumberOfSTQReferences) {
        if (leastNumberOfSTQReferences < 1) {
            throw new IllegalArgumentException("The least number of references cannot be less than 1");
        }
        this.myLeastNumberOfSTQReferences = leastNumberOfSTQReferences;
    }

    @Override
    public boolean test(TariffDAGNode node) {
        if (node instanceof TSNode) {
            TSNode currentTSNode = (TSNode)node;
            ClassProfile classProfile = currentTSNode.getClassProfile();
            STQRepository stqRepository = STQRepositories.getRepositoryForTreeModel(currentTSNode.getTreeModel());
            SelectionTreeQualifier currentStq = stqRepository.getSTQFor(classProfile);
            if (currentStq == null) {
                return false;
            }
            int referenceCountFor = stqRepository.getReferenceCountFor(currentStq);
            if (referenceCountFor >= this.myLeastNumberOfSTQReferences) {
                return true;
            }
        }
        return false;
    }

    public int getLeastReferenceCount() {
        return this.myLeastNumberOfSTQReferences;
    }
}

