/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.gui.ratingrules.nodes.FinderResult;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.DAGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;

public class FinderResultListSelectionListener
implements ListSelectionListener {
    private JTree myTree;
    private JList myList;

    public FinderResultListSelectionListener(JTree tree, JList list) {
        this.myTree = tree;
        this.myList = list;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getSource() != this.myList) {
            System.err.println("STRANGE: RefListSelectionListener subscribing on other data: " + e);
            return;
        }
        if (e.getValueIsAdjusting()) {
            return;
        }
        FinderResult res = (FinderResult)this.myList.getSelectedValue();
        if (res == null) {
            return;
        }
        String path = res.getPath();
        TariffDAGNode sel = res.getNode();
        if (sel != null) {
            TariffDAGNode root = (TariffDAGNode)this.myTree.getModel().getRoot();
            List<List<DAGNode>> result = new ArrayList<List<DAGNode>>();
            DAGUtil.getPathsToRoot(sel, root, new ArrayList<DAGNode>(100), result);
            result = this.getMatchingPaths(path, result);
            int len = result.size();
            TreePath[] treepaths = new TreePath[len];
            for (int i = 0; i < len; ++i) {
                treepaths[i] = new TreePath(result.get(i).toArray());
            }
            this.myTree.setSelectionPaths(treepaths);
            this.myTree.scrollPathToVisible(treepaths[0]);
        }
    }

    private List<List<DAGNode>> getMatchingPaths(String p, List<List<DAGNode>> res) {
        ArrayList<List<DAGNode>> l = new ArrayList<List<DAGNode>>(1);
        int len = res.size();
        for (int i = 0; i < len; ++i) {
            List<DAGNode> pathlist = res.get(i);
            if (pathlist == null || !this.pathIsMatching(p, pathlist)) continue;
            l.add(pathlist);
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean pathIsMatching(String path, List<DAGNode> list) {
        StringTokenizer tok = new StringTokenizer(path, "/", true);
        int i = 0;
        int len = list.size();
        boolean lastWasDelim = false;
        while (tok.hasMoreTokens()) {
            String nextid;
            block6: {
                nextid = tok.nextToken();
                if (nextid.equals("/")) {
                    if (lastWasDelim) {
                        nextid = "";
                        lastWasDelim = false;
                        break block6;
                    } else {
                        lastWasDelim = true;
                        continue;
                    }
                }
                lastWasDelim = false;
            }
            if (i >= len) {
                return false;
            }
            TariffDAGNode node = (TariffDAGNode)list.get(i);
            if (!nextid.equals(node.getNodeId())) {
                return false;
            }
            ++i;
        }
        return i == len;
    }
}

