/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.bookmarks;

import ericsson.ere.gui.ratingrules.bookmarks.BookmarkItem;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarkTableCellEditor;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarkTableCellRenderer;
import ericsson.ere.gui.ratingrules.bookmarks.DeleteBookmarkAction;
import ericsson.ere.gui.ratingrules.bookmarks.GoToBookmarkAction;
import ericsson.ere.gui.ratingrules.bookmarks.RenameBookmarkAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;

public class BookmarksPane
extends JPanel
implements FocusListener,
TableModelListener {
    private GoToBookmarkAction myGoToAction;
    private DeleteBookmarkAction myDeleteAction;
    private RenameBookmarkAction myEditAction;
    private JTree myTree;
    private JTable myBookmarkTable;
    private JPopupMenu myPopupMenu;
    private boolean myIsChanged = false;

    public BookmarksPane(JTree tree, List<BookmarkItem> existingBookmarks) {
        super(new GridBagLayout());
        this.myTree = tree;
        this.initPane(existingBookmarks);
    }

    private void initPane(List<BookmarkItem> existingBookmarks) {
        this.setSize(200, 100);
        this.setPreferredSize(new Dimension(200, 100));
        DefaultTableModel defaultTableModel = new DefaultTableModel(0, 1);
        this.myBookmarkTable = new JTable(defaultTableModel);
        this.myBookmarkTable.setName("BookmarksPane.JTable.BookmarkTable");
        this.myBookmarkTable.getColumnModel().getColumn(0).setCellRenderer(new BookmarkTableCellRenderer());
        BookmarkTableCellEditor bookmarkTableCellEditor = new BookmarkTableCellEditor();
        bookmarkTableCellEditor.setClickCountToStart(5);
        this.myBookmarkTable.getColumnModel().getColumn(0).setCellEditor(bookmarkTableCellEditor);
        this.myBookmarkTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.myBookmarkTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.myBookmarkTable.setIntercellSpacing(new Dimension(0, 0));
        for (int i = 0; i < existingBookmarks.size(); ++i) {
            existingBookmarks.get(i).initialize(this.myTree);
            defaultTableModel.addRow(new Object[]{existingBookmarks.get(i)});
        }
        this.myBookmarkTable.addFocusListener(this);
        this.myGoToAction = new GoToBookmarkAction(this.myBookmarkTable, this.myTree);
        this.myDeleteAction = new DeleteBookmarkAction(this.myBookmarkTable);
        this.myEditAction = new RenameBookmarkAction(this.myBookmarkTable);
        this.myBookmarkTable.registerKeyboardAction(this.myDeleteAction, KeyStroke.getKeyStroke("DELETE"), 0);
        this.myBookmarkTable.registerKeyboardAction(this.myEditAction, KeyStroke.getKeyStroke("F2"), 0);
        this.myPopupMenu = new JPopupMenu();
        this.myPopupMenu.setName("BookmarksPane.JPopupMenu.BookmarksPopupMenu");
        this.myPopupMenu.add(this.myGoToAction);
        this.myPopupMenu.add(this.myEditAction);
        this.myPopupMenu.add(this.myDeleteAction);
        defaultTableModel.addTableModelListener(this);
        this.myBookmarkTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int row = BookmarksPane.this.myBookmarkTable.rowAtPoint(e.getPoint());
                    if (row != -1) {
                        BookmarksPane.this.myBookmarkTable.setRowSelectionInterval(row, row);
                        BookmarksPane.this.myPopupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                } else if (e.getClickCount() == 2) {
                    BookmarksPane.this.myGoToAction.actionPerformed(null);
                }
            }
        });
        JPanel titlePanel = new JPanel(new BorderLayout());
        titlePanel.setPreferredSize(new Dimension(50, 20));
        JLabel titleLabel = new JLabel("  Bookmarks");
        titleLabel.setName("BookmarksPane.TitleLabel");
        titlePanel.add((Component)titleLabel, "Center");
        JPanel spring = new JPanel();
        spring.setBackground(Color.WHITE);
        JPanel tableContainer = new JPanel(new GridBagLayout());
        tableContainer.setBorder(new EtchedBorder(1));
        tableContainer.add((Component)this.myBookmarkTable, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        tableContainer.add((Component)spring, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)titlePanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        JScrollPane scrollPane = new JScrollPane(tableContainer, 20, 30);
        this.add((Component)scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 15, 1, new Insets(0, 3, 2, 2), 0, 0));
    }

    public JTable getTable() {
        return this.myBookmarkTable;
    }

    public List<BookmarkItem> getBookmarkList() {
        ArrayList<BookmarkItem> list = new ArrayList<BookmarkItem>();
        Vector<Vector> array = ((DefaultTableModel)this.myBookmarkTable.getModel()).getDataVector();
        for (int i = 0; i < array.size(); ++i) {
            list.add((BookmarkItem)array.get(i).get(0));
        }
        return list;
    }

    public void setChanged() {
        this.myIsChanged = true;
    }

    public boolean isChanged() {
        return this.myIsChanged;
    }

    public void resetChanged() {
        this.myIsChanged = false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        List<BookmarkItem> bookmarkList = this.getBookmarkList();
        for (BookmarkItem item : bookmarkList) {
            if (!item.isInitialized()) {
                item.initialize(this.myTree);
                continue;
            }
            item.revalidatePathInTree(this.myTree);
        }
        this.myBookmarkTable.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        Vector<Vector> allData = ((DefaultTableModel)this.myBookmarkTable.getModel()).getDataVector();
        for (int i = 0; i < allData.size(); ++i) {
            BookmarkItem item = (BookmarkItem)allData.get(i).get(0);
            if (!item.isEdited()) continue;
            this.setChanged();
            item.resetEdited();
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.myIsChanged = true;
    }
}

