/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.bookmarks;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarkItem;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarksPane;
import ericsson.ere.gui.ratingrules.bookmarks.OpenBookmarksAction;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.TreePath;

public class AddBookmarkAction
extends AbstractAction {
    private boolean myShowMessage = true;
    private JTree myTree = null;
    private JTable myTable = null;
    private BookmarksPane myBookmarksPanel;
    private OpenBookmarksAction myOpenBookmarksAction;

    public AddBookmarkAction(JTable table, JTree tree, OpenBookmarksAction openBookmarksAction, BookmarksPane bookmarksPanel) {
        super("Add bookmark");
        this.myTree = tree;
        this.myTable = table;
        this.myOpenBookmarksAction = openBookmarksAction;
        this.myBookmarksPanel = bookmarksPanel;
        ImageIcon icon = RmaDefs.getImageIcon("bookmark_add.png");
        this.putValue("SwingLargeIconKey", icon);
        this.putValue("ShortDescription", "Add a bookmark");
    }

    public AddBookmarkAction(JTable table, JTree tree, OpenBookmarksAction openBookmarksAction, BookmarksPane bookmarksPanel, boolean showMessage) {
        this(table, tree, openBookmarksAction, bookmarksPanel);
        this.myShowMessage = showMessage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        TreePath[] selectionPaths = this.myTree.getSelectionPaths();
        if (selectionPaths != null && selectionPaths.length > 0) {
            boolean performAdd = true;
            if (selectionPaths.length > 1 && this.myShowMessage) {
                performAdd = DialogFactory.getQuestionDialog(GuiServiceCenter.getInstance().getMainWindow(), "Add bookmark", "There are multiple nodes selected in the tree. Only the first selected path will be bookmarked. Continue?");
            }
            if (performAdd) {
                TreePath selectedPath = selectionPaths[0];
                TariffDAGNode node = (TariffDAGNode)selectedPath.getLastPathComponent();
                BookmarkItem newItem = new BookmarkItem(node.getNodeName(), selectedPath);
                if (newItem.isPathValidInTree(this.myTree)) {
                    if (!this.myBookmarksPanel.isVisible()) {
                        this.myOpenBookmarksAction.actionPerformed(null);
                    }
                    DefaultTableModel model = (DefaultTableModel)this.myTable.getModel();
                    model.addRow(new Object[]{newItem});
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            int rowCount = AddBookmarkAction.this.myTable.getRowCount();
                            AddBookmarkAction.this.myTable.setRowSelectionInterval(rowCount - 1, rowCount - 1);
                            AddBookmarkAction.this.myTable.editCellAt(rowCount - 1, 0);
                            JTextField editorComponent = (JTextField)AddBookmarkAction.this.myTable.getEditorComponent();
                            editorComponent.selectAll();
                            editorComponent.requestFocusInWindow();
                        }
                    });
                } else if (this.myShowMessage) {
                    DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Add bookmark", "The path in the selection tree is not unique. A bookmark can not be created for the selected node.");
                }
            }
        } else if (this.myShowMessage) {
            DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Add bookmark", "There is no node selected in the tree.");
        }
    }
}

